/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.analyze;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.NoArgs;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.google.aiplugin.agents.tools.analyze.AnalyzeCurrentFileToolHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Analyzes the currently open file in the editor for errors and warnings using the editor's inspections", instructions="Use this tool to identify coding issues, syntax errors, and other problems in your current file.", examples={})
@ToolResult(description="Returns a JSON array of objects containing error information:\n- severity: The severity level of the issue (ERROR, WARNING, etc.)\n- description: A description of the issue\n- lineContent: The content of the line containing the issue\nReturns an empty array ([]) if no issues are found.\nReturns error if no file is currently open.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/google/aiplugin/agents/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/google/aiplugin/agents/BasicToolIcon;", "getIcon", "()Lcom/google/aiplugin/agents/BasicToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/tools/analyze/AnalyzeCurrentFileToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.agents.agents-core"})
public final class AnalyzeCurrentFileTool
implements Tool<NoArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final BasicToolIcon icon = BasicToolIcon.ANALYZE;

    public AnalyzeCurrentFileTool() {
        this.name = "analyze_current_file";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public BasicToolIcon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Analyzing current file";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Analyzed current file";
    }

    @NotNull
    public AnalyzeCurrentFileToolHandler createHandler(@NotNull ToolContext context2, @NotNull NoArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new AnalyzeCurrentFileToolHandler(context2, args);
    }
}

