/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0004J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/google/aiplugin/agents/permissions/UrlPermissionState;", "Lcom/google/aiplugin/agents/permissions/PermissionState;", "included", "", "", "excluded", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getIncluded", "()Ljava/util/List;", "getExcluded", "toString", "toSerializedString", "isIncluded", "", "url", "isExcluded", "getDecision", "Lcom/google/aiplugin/agents/permissions/PermissionDecision;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "Companion", "aiplugin.agents.agents-core"})
public final class UrlPermissionState
extends PermissionState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> included;
    @NotNull
    private final List<String> excluded;

    public UrlPermissionState(@NotNull List<String> included, @NotNull List<String> excluded) {
        Intrinsics.checkNotNullParameter(included, (String)"included");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        super(null);
        this.included = included;
        this.excluded = excluded;
    }

    public /* synthetic */ UrlPermissionState(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, list2);
    }

    @NotNull
    public final List<String> getIncluded() {
        return this.included;
    }

    @NotNull
    public final List<String> getExcluded() {
        return this.excluded;
    }

    @NotNull
    public String toString() {
        return "included=" + this.included + ", excluded=" + this.excluded;
    }

    @Override
    @NotNull
    public String toSerializedString() {
        return CollectionsKt.joinToString$default((Iterable)this.included, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "  " + CollectionsKt.joinToString$default((Iterable)this.excluded, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean isIncluded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getDecision(url) == PermissionDecision.APPROVED;
    }

    public final boolean isExcluded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getDecision(url) == PermissionDecision.DENIED;
    }

    @NotNull
    public final PermissionDecision getDecision(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String bestIncluded = null;
        String bestExcluded = null;
        for (String root : this.included) {
            if (Intrinsics.areEqual((Object)root, (Object)"*")) {
                bestIncluded = root;
                break;
            }
            if (!FileUtil.isAncestor((String)root, (String)url, (boolean)false) || bestIncluded != null && !Companion.urlMatches(bestIncluded, root)) continue;
            bestIncluded = root;
        }
        for (String root : this.excluded) {
            if (Intrinsics.areEqual((Object)root, (Object)"*")) {
                bestExcluded = root;
                break;
            }
            if (!FileUtil.isAncestor((String)root, (String)url, (boolean)false) || bestExcluded != null && !Companion.urlMatches(bestExcluded, root)) continue;
            bestExcluded = root;
        }
        if (bestIncluded == null && bestExcluded == null) {
            return PermissionDecision.ASK;
        }
        if (bestIncluded != null && bestExcluded != null) {
            if (Intrinsics.areEqual((Object)bestIncluded, bestExcluded)) {
                return PermissionDecision.DENIED;
            }
            if (Companion.urlMatches(bestIncluded, bestExcluded)) {
                return PermissionDecision.DENIED;
            }
            if (Companion.urlMatches(bestExcluded, bestIncluded)) {
                return PermissionDecision.APPROVED;
            }
            return PermissionDecision.DENIED;
        }
        return bestIncluded != null ? PermissionDecision.APPROVED : PermissionDecision.DENIED;
    }

    @NotNull
    public final List<String> component1() {
        return this.included;
    }

    @NotNull
    public final List<String> component2() {
        return this.excluded;
    }

    @NotNull
    public final UrlPermissionState copy(@NotNull List<String> included, @NotNull List<String> excluded) {
        Intrinsics.checkNotNullParameter(included, (String)"included");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        return new UrlPermissionState(included, excluded);
    }

    public static /* synthetic */ UrlPermissionState copy$default(UrlPermissionState urlPermissionState, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = urlPermissionState.included;
        }
        if ((n & 2) != 0) {
            list2 = urlPermissionState.excluded;
        }
        return urlPermissionState.copy(list, list2);
    }

    public int hashCode() {
        int result2 = ((Object)this.included).hashCode();
        result2 = result2 * 31 + ((Object)this.excluded).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UrlPermissionState)) {
            return false;
        }
        UrlPermissionState urlPermissionState = (UrlPermissionState)other;
        if (!Intrinsics.areEqual(this.included, urlPermissionState.included)) {
            return false;
        }
        return Intrinsics.areEqual(this.excluded, urlPermissionState.excluded);
    }

    public UrlPermissionState() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/agents/permissions/UrlPermissionState$Companion;", "", "<init>", "()V", "fromSerializedString", "Lcom/google/aiplugin/agents/permissions/UrlPermissionState;", "s", "", "urlMatches", "", "baseUrl", "url", "aiplugin.agents.agents-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UrlPermissionState fromSerializedString(@NotNull String s) {
            List list;
            List included;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int sep = StringsKt.indexOf$default((CharSequence)s, (String)"  ", (int)0, (boolean)false, (int)6, null);
            if (sep == 0) {
                v0 = CollectionsKt.emptyList();
            } else {
                String string = s.substring(0, sep);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String[] stringArray = new String[]{" "};
                v0 = included = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            if (sep == s.length() - 2) {
                list = CollectionsKt.emptyList();
            } else {
                String string = s.substring(sep + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String[] stringArray = new String[]{" "};
                list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
            List excluded = list;
            return new UrlPermissionState(included, excluded);
        }

        public final boolean urlMatches(@NotNull String baseUrl, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return Intrinsics.areEqual((Object)url, (Object)baseUrl) || StringsKt.startsWith$default((String)url, (String)baseUrl, (boolean)false, (int)2, null) && (url.charAt(baseUrl.length()) == '/' || url.charAt(baseUrl.length()) == '&');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

