/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.ToolIcon;
import com.google.aiplugin.agents.permissions.Permission;
import com.google.aiplugin.agents.permissions.PermissionChecker;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionRequest;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.google.aiplugin.agents.permissions.SharedPermissions;
import com.google.aiplugin.agents.permissions.UrlPermissionState;
import com.google.aiplugin.agents.tools.ToolContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/agents/permissions/UrlPermission;", "Lcom/google/aiplugin/agents/permissions/Permission;", "id", "", "displayName", "hint", "icon", "Lcom/google/aiplugin/agents/ToolIcon;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/aiplugin/agents/ToolIcon;)V", "match", "Lcom/google/aiplugin/agents/permissions/PermissionDecision;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "request", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "state", "Lcom/google/aiplugin/agents/permissions/PermissionState;", "Lcom/google/aiplugin/agents/permissions/UrlPermission$UrlPermissionRequest;", "url", "defaultState", "Lcom/google/aiplugin/agents/permissions/UrlPermissionState;", "getDefaultState", "()Lcom/google/aiplugin/agents/permissions/UrlPermissionState;", "UrlPermissionRequest", "aiplugin.agents.agents-core"})
public class UrlPermission
extends Permission {
    @NotNull
    private final UrlPermissionState defaultState;

    public UrlPermission(@NotNull String id, @NotNull String displayName2, @NotNull String hint, @NotNull ToolIcon icon2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        super(id, displayName2, hint, icon2);
        this.defaultState = new UrlPermissionState(null, null, 3, null);
    }

    public /* synthetic */ UrlPermission(String string, String string2, String string3, ToolIcon toolIcon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            toolIcon = BasicToolIcon.WEB;
        }
        this(string, string2, string3, toolIcon);
    }

    @Override
    @Nullable
    public PermissionDecision match(@NotNull ToolContext context2, @NotNull PermissionRequest request2, @NotNull PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(request2 instanceof UrlPermissionRequest) || !(state2 instanceof UrlPermissionState)) {
            return null;
        }
        PermissionDecision decision = ((UrlPermissionState)state2).getDecision(((UrlPermissionRequest)request2).getUrl());
        if (decision != PermissionDecision.ASK) {
            return decision;
        }
        return null;
    }

    @NotNull
    public final UrlPermissionRequest request(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new UrlPermissionRequest(url);
    }

    @Override
    @NotNull
    public UrlPermissionState getDefaultState() {
        return this.defaultState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/google/aiplugin/agents/permissions/UrlPermission$UrlPermissionRequest;", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "displayName", "associatedPermissions", "", "Lcom/google/aiplugin/agents/permissions/Permission;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "getApprovalOptions", "Lcom/google/aiplugin/agents/permissions/PermissionRequest$ApprovalOptions;", "createRequestRationale", "aiplugin.agents.agents-core"})
    @SourceDebugExtension(value={"SMAP\nUrlPermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPermission.kt\ncom/google/aiplugin/agents/permissions/UrlPermission$UrlPermissionRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n295#2,2:151\n774#2:153\n865#2,2:154\n774#2:156\n865#2,2:157\n*S KotlinDebug\n*F\n+ 1 UrlPermission.kt\ncom/google/aiplugin/agents/permissions/UrlPermission$UrlPermissionRequest\n*L\n142#1:151,2\n100#1:153\n100#1:154,2\n101#1:156\n101#1:157,2\n*E\n"})
    public static final class UrlPermissionRequest
    extends PermissionRequest {
        @NotNull
        private final String url;

        public UrlPermissionRequest(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String displayName() {
            return "The agent wants permission to read URL " + this.url;
        }

        @Override
        @NotNull
        public List<Permission> associatedPermissions(@NotNull ToolContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return CollectionsKt.listOf((Object)SharedPermissions.INSTANCE.getREAD_URL_PERMISSION());
        }

        @Override
        @NotNull
        public PermissionRequest.ApprovalOptions getApprovalOptions(@NotNull ToolContext context2) {
            URL url;
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            UrlPermission permission = SharedPermissions.INSTANCE.getREAD_URL_PERMISSION();
            try {
                uRL = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            URL uRL2 = url = uRL;
            String domain = uRL2 != null ? uRL2.getHost() : null;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Accept", UrlPermissionRequest::getApprovalOptions$lambda$0), TuplesKt.to((Object)"Reject", UrlPermissionRequest::getApprovalOptions$lambda$1), domain != null ? TuplesKt.to((Object)("Always allow " + domain), () -> UrlPermissionRequest.getApprovalOptions$lambda$2(context2, permission, url, domain)) : null, TuplesKt.to((Object)"Allow all URLs", () -> UrlPermissionRequest.getApprovalOptions$lambda$3(context2, permission)), TuplesKt.to((Object)"Never allow accessing URLs", () -> UrlPermissionRequest.getApprovalOptions$lambda$4(context2, permission))};
            return new PermissionRequest.ApprovalOptions(BasicToolIcon.WEB, this.displayName(), "Allow accessing " + url + "?", this.createRequestRationale(context2), CollectionsKt.listOfNotNull((Object[])objectArray));
        }

        @Override
        @Nullable
        public String createRequestRationale(@NotNull ToolContext context2) {
            Object v1;
            block3: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                PermissionState permissionState = context2.getPermissions().getSettings().get(SharedPermissions.INSTANCE.getREAD_URL_PERMISSION());
                UrlPermissionState urlPermissionState = permissionState instanceof UrlPermissionState ? (UrlPermissionState)permissionState : null;
                if (urlPermissionState == null) {
                    return null;
                }
                UrlPermissionState state2 = urlPermissionState;
                Iterable $this$firstOrNull$iv = state2.getIncluded();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!UrlPermissionState.Companion.urlMatches(this.url, it)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            String subUrl = v1;
            if (subUrl != null) {
                return "You've already approved " + subUrl + ", but this URL is not covered by that approval.";
            }
            return null;
        }

        private static final PermissionDecision getApprovalOptions$lambda$0() {
            return PermissionDecision.APPROVED;
        }

        private static final PermissionDecision getApprovalOptions$lambda$1() {
            return PermissionDecision.DENIED;
        }

        private static final PermissionDecision getApprovalOptions$lambda$2(ToolContext $context, UrlPermission $permission, URL $url, String $domain) {
            PermissionChecker.updateState$default($context.getPermissions(), $permission, false, arg_0 -> UrlPermissionRequest.getApprovalOptions$lambda$2$0($url, $domain, arg_0), 2, null);
            return PermissionDecision.APPROVED;
        }

        private static final PermissionState getApprovalOptions$lambda$2$0(URL $url, String $domain, PermissionState state2) {
            PermissionState permissionState;
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            String domainUrl = $url.getProtocol() + "://" + $domain;
            if (state2 instanceof UrlPermissionState) {
                String it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = ((UrlPermissionState)state2).getIncluded();
                UrlPermissionState urlPermissionState = (UrlPermissionState)state2;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)"*"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = ((UrlPermissionState)state2).getExcluded();
                List list = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)domainUrl);
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)"*") && !UrlPermissionState.Companion.urlMatches(domainUrl, it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                permissionState = urlPermissionState.copy(list, list2);
            } else {
                permissionState = new UrlPermissionState(CollectionsKt.listOf((Object)domainUrl), null, 2, null);
            }
            return permissionState;
        }

        private static final PermissionDecision getApprovalOptions$lambda$3(ToolContext $context, UrlPermission $permission) {
            PermissionChecker.updateState$default($context.getPermissions(), $permission, false, UrlPermissionRequest::getApprovalOptions$lambda$3$0, 2, null);
            return PermissionDecision.APPROVED;
        }

        private static final PermissionState getApprovalOptions$lambda$3$0(PermissionState state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            return state2 instanceof UrlPermissionState ? (PermissionState)((UrlPermissionState)state2).copy(CollectionsKt.listOf((Object)"*"), CollectionsKt.emptyList()) : (PermissionState)new UrlPermissionState(CollectionsKt.listOf((Object)"*"), null, 2, null);
        }

        private static final PermissionDecision getApprovalOptions$lambda$4(ToolContext $context, UrlPermission $permission) {
            PermissionChecker.updateState$default($context.getPermissions(), $permission, false, UrlPermissionRequest::getApprovalOptions$lambda$4$0, 2, null);
            return PermissionDecision.DENIED;
        }

        private static final PermissionState getApprovalOptions$lambda$4$0(PermissionState state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            return state2 instanceof UrlPermissionState ? (PermissionState)((UrlPermissionState)state2).copy(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)"*")) : (PermissionState)new UrlPermissionState(null, CollectionsKt.listOf((Object)"*"), 1, null);
        }
    }
}

