/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.permissions;

import com.google.aiplugin.agents.BasicToolIcon;
import com.google.aiplugin.agents.ToolIcon;
import com.google.aiplugin.agents.permissions.McpPermissionState;
import com.google.aiplugin.agents.permissions.Permission;
import com.google.aiplugin.agents.permissions.PermissionChecker;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.permissions.PermissionRequest;
import com.google.aiplugin.agents.permissions.PermissionState;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.mcp.McpHostKt;
import io.modelcontextprotocol.kotlin.sdk.client.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\u0016\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/google/aiplugin/agents/permissions/McpPermission;", "Lcom/google/aiplugin/agents/permissions/Permission;", "mcpId", "", "id", "displayName", "hint", "icon", "Lcom/google/aiplugin/agents/ToolIcon;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/aiplugin/agents/ToolIcon;)V", "getMcpId", "()Ljava/lang/String;", "match", "Lcom/google/aiplugin/agents/permissions/PermissionDecision;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "request", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "state", "Lcom/google/aiplugin/agents/permissions/PermissionState;", "Lcom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest;", "tools", "", "tool", "defaultState", "Lcom/google/aiplugin/agents/permissions/McpPermissionState;", "getDefaultState", "()Lcom/google/aiplugin/agents/permissions/McpPermissionState;", "McpPermissionRequest", "aiplugin.agents.agents-core"})
public final class McpPermission
extends Permission {
    @NotNull
    private final String mcpId;
    @NotNull
    private final McpPermissionState defaultState;

    public McpPermission(@NotNull String mcpId, @NotNull String id, @NotNull String displayName2, @NotNull String hint, @NotNull ToolIcon icon2) {
        Intrinsics.checkNotNullParameter((Object)mcpId, (String)"mcpId");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        super(id, displayName2, hint, icon2);
        this.mcpId = mcpId;
        this.defaultState = new McpPermissionState(null, 1, null);
    }

    public /* synthetic */ McpPermission(String string, String object, String object2, String object3, ToolIcon toolIcon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = "mcp." + string;
        }
        if ((n & 4) != 0) {
            object2 = "Use the " + string + " MCP server";
        }
        if ((n & 8) != 0) {
            object3 = "Allow the agent to call tools from the " + string + " MCP server";
        }
        if ((n & 0x10) != 0) {
            toolIcon = BasicToolIcon.MCP;
        }
        this(string, (String)object, (String)object2, (String)object3, toolIcon);
    }

    @NotNull
    public final String getMcpId() {
        return this.mcpId;
    }

    @Override
    @Nullable
    public PermissionDecision match(@NotNull ToolContext context2, @NotNull PermissionRequest request2, @NotNull PermissionState state2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(request2 instanceof McpPermissionRequest) || !(state2 instanceof McpPermissionState)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)this.mcpId, (Object)((McpPermissionRequest)request2).getMcpId())) {
            return null;
        }
        if (((McpPermissionState)state2).getAllowedTools().contains("*")) {
            return PermissionDecision.APPROVED;
        }
        for (String tool : ((McpPermissionRequest)request2).getTools()) {
            if (((McpPermissionState)state2).getAllowedTools().contains(tool)) continue;
            return null;
        }
        return PermissionDecision.APPROVED;
    }

    @NotNull
    public final McpPermissionRequest request(@NotNull String mcpId, @NotNull List<String> tools2) {
        Intrinsics.checkNotNullParameter((Object)mcpId, (String)"mcpId");
        Intrinsics.checkNotNullParameter(tools2, (String)"tools");
        return new McpPermissionRequest(mcpId, tools2);
    }

    @NotNull
    public final McpPermissionRequest request(@NotNull String mcpId, @NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)mcpId, (String)"mcpId");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return this.request(mcpId, CollectionsKt.listOf((Object)tool));
    }

    @Override
    @NotNull
    public McpPermissionState getDefaultState() {
        return this.defaultState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest;", "Lcom/google/aiplugin/agents/permissions/PermissionRequest;", "mcpId", "", "tools", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getMcpId", "()Ljava/lang/String;", "getTools", "()Ljava/util/List;", "displayName", "associatedPermissions", "Lcom/google/aiplugin/agents/permissions/Permission;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "getApprovalOptions", "Lcom/google/aiplugin/agents/permissions/PermissionRequest$ApprovalOptions;", "Companion", "aiplugin.agents.agents-core"})
    @SourceDebugExtension(value={"SMAP\nMcpPermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpPermission.kt\ncom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n774#2:153\n865#2,2:154\n*S KotlinDebug\n*F\n+ 1 McpPermission.kt\ncom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest\n*L\n98#1:153\n98#1:154,2\n*E\n"})
    public static final class McpPermissionRequest
    extends PermissionRequest {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String mcpId;
        @NotNull
        private final List<String> tools;

        public McpPermissionRequest(@NotNull String mcpId, @NotNull List<String> tools2) {
            Intrinsics.checkNotNullParameter((Object)mcpId, (String)"mcpId");
            Intrinsics.checkNotNullParameter(tools2, (String)"tools");
            this.mcpId = mcpId;
            this.tools = tools2;
        }

        public /* synthetic */ McpPermissionRequest(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = CollectionsKt.listOf((Object)"*");
            }
            this(string, list);
        }

        @NotNull
        public final String getMcpId() {
            return this.mcpId;
        }

        @NotNull
        public final List<String> getTools() {
            return this.tools;
        }

        @Override
        @NotNull
        public String displayName() {
            return this.tools.size() == 1 && Intrinsics.areEqual((Object)this.tools.get(0), (Object)"*") ? "The agent wants permission to run all tools from MCP server " + this.mcpId : (this.tools.size() == 1 ? "The agent wants permission to run tool " + this.tools.get(0) + " from MCP server " + this.mcpId : "The agent wants permission to run tools " + CollectionsKt.joinToString$default((Iterable)this.tools, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " from MCP server " + this.mcpId);
        }

        @Override
        @NotNull
        public List<Permission> associatedPermissions(@NotNull ToolContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return CollectionsKt.listOf((Object)new McpPermission(this.mcpId, null, null, null, null, 30, null));
        }

        @Override
        @NotNull
        public PermissionRequest.ApprovalOptions getApprovalOptions(@NotNull ToolContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            McpPermission permission = new McpPermission(this.mcpId, null, null, null, null, 30, null);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"Accept", McpPermissionRequest::getApprovalOptions$lambda$0), TuplesKt.to((Object)"Reject", McpPermissionRequest::getApprovalOptions$lambda$1), TuplesKt.to((Object)"Always allow", () -> McpPermissionRequest.getApprovalOptions$lambda$2(context2, permission, this)), TuplesKt.to((Object)("Allow all tools from " + this.mcpId), () -> McpPermissionRequest.getApprovalOptions$lambda$3(context2, permission))};
            return new PermissionRequest.ApprovalOptions(permission.getIcon(), this.displayName(), "Allow running " + CollectionsKt.joinToString$default((Iterable)this.tools, (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null) + "?", this.createRequestRationale(context2), CollectionsKt.listOfNotNull((Object[])objectArray));
        }

        private static final PermissionDecision getApprovalOptions$lambda$0() {
            return PermissionDecision.APPROVED;
        }

        private static final PermissionDecision getApprovalOptions$lambda$1() {
            return PermissionDecision.DENIED;
        }

        private static final PermissionDecision getApprovalOptions$lambda$2(ToolContext $context, McpPermission $permission, McpPermissionRequest this$0) {
            PermissionChecker.updateState$default($context.getPermissions(), $permission, false, arg_0 -> McpPermissionRequest.getApprovalOptions$lambda$2$0(this$0, arg_0), 2, null);
            return PermissionDecision.APPROVED;
        }

        /*
         * WARNING - void declaration
         */
        private static final PermissionState getApprovalOptions$lambda$2$0(McpPermissionRequest this$0, PermissionState state2) {
            PermissionState permissionState;
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            if (state2 instanceof McpPermissionState) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = ((McpPermissionState)state2).getAllowedTools();
                McpPermissionState mcpPermissionState = (McpPermissionState)state2;
                boolean $i$f$filter = false;
                void var4_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!this$0.tools.contains(it) && !Intrinsics.areEqual((Object)it, (Object)"*"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                permissionState = mcpPermissionState.copy(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this$0.tools));
            } else {
                permissionState = new McpPermissionState(this$0.tools);
            }
            return permissionState;
        }

        private static final PermissionDecision getApprovalOptions$lambda$3(ToolContext $context, McpPermission $permission) {
            PermissionChecker.updateState$default($context.getPermissions(), $permission, false, McpPermissionRequest::getApprovalOptions$lambda$3$0, 2, null);
            return PermissionDecision.APPROVED;
        }

        private static final PermissionState getApprovalOptions$lambda$3$0(PermissionState state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            return state2 instanceof McpPermissionState ? (PermissionState)((McpPermissionState)state2).copy(CollectionsKt.listOf((Object)"*")) : (PermissionState)new McpPermissionState(CollectionsKt.listOf((Object)"*"));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest$Companion;", "", "<init>", "()V", "request", "Lcom/google/aiplugin/agents/permissions/McpPermission$McpPermissionRequest;", "client", "Lio/modelcontextprotocol/kotlin/sdk/client/Client;", "tools", "", "", "mcpId", "aiplugin.agents.agents-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final McpPermissionRequest request(@NotNull Client client2, @NotNull List<String> tools2) {
                Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
                Intrinsics.checkNotNullParameter(tools2, (String)"tools");
                return new McpPermissionRequest(McpHostKt.id(client2), tools2);
            }

            @NotNull
            public final McpPermissionRequest request(@NotNull String mcpId, @NotNull List<String> tools2) {
                Intrinsics.checkNotNullParameter((Object)mcpId, (String)"mcpId");
                Intrinsics.checkNotNullParameter(tools2, (String)"tools");
                return new McpPermissionRequest(mcpId, tools2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

