/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.testgeneration;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.testgeneration.TestScenarioPromptBuilder;
import com.android.studio.ml.bot.testgeneration.TestType;
import com.android.studio.ml.bot.testgeneration.TestTypeEnum;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/testgeneration/AndroidTestScenarioHelper;", "Lcom/android/studio/ml/bot/testgeneration/TestScenarioPromptBuilder;", "<init>", "()V", "getTargetTestType", "Lcom/android/studio/ml/bot/testgeneration/TestType;", "destinationPsiDirectory", "Lcom/intellij/psi/PsiDirectory;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class AndroidTestScenarioHelper
implements TestScenarioPromptBuilder {
    public static final int $stable;

    @Override
    @NotNull
    public TestType getTargetTestType(@NotNull PsiDirectory destinationPsiDirectory) {
        Intrinsics.checkNotNullParameter((Object)destinationPsiDirectory, (String)"destinationPsiDirectory");
        Module module2 = GenericPsiUtils.getModule((PsiElement)((PsiElement)destinationPsiDirectory));
        if (module2 == null) {
            return new TestType(TestTypeEnum.NOT_TEST, "Failed to obtain test directory module");
        }
        Module module3 = module2;
        TestArtifactSearchScopes testArtifactSearchScopes = TestArtifactSearchScopes.Companion.getInstance(module3);
        if (testArtifactSearchScopes == null) {
            return new TestType(TestTypeEnum.NOT_TEST, "Failed to obtain test directory search scope");
        }
        TestArtifactSearchScopes searchScope = testArtifactSearchScopes;
        VirtualFile virtualFile2 = destinationPsiDirectory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        VirtualFile destinationVirtualFile = virtualFile2;
        return searchScope.isAndroidTestSource(destinationVirtualFile) ? new TestType(TestTypeEnum.ANDROID_TEST, "") : (searchScope.isScreenshotTestSource(destinationVirtualFile) ? new TestType(TestTypeEnum.SCREENSHOT_TEST, "") : (searchScope.isTestSource(destinationVirtualFile) || searchScope.isUnitTestSource(destinationVirtualFile) ? new TestType(TestTypeEnum.UNIT_TEST, "") : new TestType(TestTypeEnum.NOT_TEST, "Destination folder is not a valid test source folder")));
    }
}

