/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.ui;

import com.intellij.ui.components.JBTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.DocumentFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J4\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/templates/ui/DocumentLengthFilter;", "Ljavax/swing/text/DocumentFilter;", "textField", "Lcom/intellij/ui/components/JBTextField;", "maxLength", "", "(Lcom/intellij/ui/components/JBTextField;I)V", "insertString", "", "fb", "Ljavax/swing/text/DocumentFilter$FilterBypass;", "offset", "string", "", "attr", "Ljavax/swing/text/AttributeSet;", "replace", "length", "text", "attrs", "aiplugin.core.aicore"})
final class DocumentLengthFilter
extends DocumentFilter {
    @NotNull
    private final JBTextField textField;
    private final int maxLength;

    public DocumentLengthFilter(@NotNull JBTextField textField, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        this.textField = textField;
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(@NotNull DocumentFilter.FilterBypass fb, int offset2, @Nullable String string, @Nullable AttributeSet attr) {
        String toInsert;
        Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
        if (string == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.textField.getClientProperty((Object)"com.android.studio.ml.ui.BypassLengthLimit"), (Object)true)) {
            super.insertString(fb, offset2, string, attr);
            return;
        }
        int currentLength = fb.getDocument().getLength();
        int available = this.maxLength - currentLength;
        if (available <= 0) {
            return;
        }
        if (string.length() > available) {
            String string2 = string.substring(0, available);
            v1 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            v1 = toInsert = string;
        }
        if (((CharSequence)toInsert).length() > 0) {
            super.insertString(fb, offset2, toInsert, attr);
        }
    }

    @Override
    public void replace(@NotNull DocumentFilter.FilterBypass fb, int offset2, int length, @Nullable String text2, @Nullable AttributeSet attrs) {
        String toInsert;
        Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
        if (text2 == null) {
            super.replace(fb, offset2, length, null, attrs);
            return;
        }
        if (Intrinsics.areEqual((Object)this.textField.getClientProperty((Object)"com.android.studio.ml.ui.BypassLengthLimit"), (Object)true)) {
            super.replace(fb, offset2, length, text2, attrs);
            return;
        }
        int currentLength = fb.getDocument().getLength();
        int lengthAfterDelete = currentLength - length;
        int spaceAvailable = this.maxLength - lengthAfterDelete;
        if (spaceAvailable <= 0) {
            v0 = "";
        } else if (text2.length() > spaceAvailable) {
            String string = text2.substring(0, spaceAvailable);
            v0 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            v0 = toInsert = text2;
        }
        if (((CharSequence)toInsert).length() > 0 || length > 0) {
            super.replace(fb, offset2, length, toInsert, attrs);
        }
    }
}

