/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.modelproviders.providerinfo;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.templates.modelproviders.data.ModelDetails;
import com.intellij.util.ui.ColumnInfo;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \n2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001`\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/templates/modelproviders/providerinfo/ReleaseDateColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/android/studio/ml/templates/modelproviders/data/ModelDetails;", "", "()V", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "valueOf", "item", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class ReleaseDateColumn
extends ColumnInfo<ModelDetails, String> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    private static final DateTimeFormatter OUTPUT_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    public ReleaseDateColumn() {
        super(SmlBundle.message("sml.studiobot.settings.modelProviders.modelinfo.models.releaseDate.title", new Object[0]));
    }

    @NotNull
    public String valueOf(@NotNull ModelDetails item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Instant instant = item.getReleaseDate();
        if (instant == null) {
            return "";
        }
        Instant releaseDate = instant;
        String string = ConvertersKt.toJavaInstant((Instant)releaseDate).atZone(ZoneOffset.UTC).format(OUTPUT_FORMATTER);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Nullable
    public Comparator<ModelDetails> getComparator() {
        return ReleaseDateColumn::getComparator$lambda$0;
    }

    private static final int getComparator$lambda$0(ModelDetails model1, ModelDetails model2) {
        return ReleaseDateColumn.Companion.compareTo(model1.getReleaseDate(), model2.getReleaseDate());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/studio/ml/templates/modelproviders/providerinfo/ReleaseDateColumn$Companion;", "", "()V", "OUTPUT_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "compareTo", "", "Lkotlinx/datetime/Instant;", "other", "aiplugin.core.aicore"})
    private static final class Companion {
        private Companion() {
        }

        private final int compareTo(Instant $this$compareTo, Instant other) {
            return $this$compareTo == null && other == null ? 0 : ($this$compareTo == null ? -1 : (other == null ? 1 : $this$compareTo.compareTo(other)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

