/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.suggestion.controls.ShortcutExtensionsKt;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtilCompat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\b\u0010\u001a\u001a\u00020\u0011H\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/studio/ml/suggestion/controls/TabToProceedHintControl;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/Editor;", "moveToOffsetSupplier", "Lkotlin/Function0;", "", "gutterIconClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "suggestionBoundsProvider", "Ljava/awt/Rectangle;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "currentInlay", "Lcom/intellij/openapi/editor/Inlay;", "addGutterIcon", "", "addInlay", "createInlayPresentationForTabToMove", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "currentCaretLine", "currentInlayLine", "()Ljava/lang/Integer;", "getInlayHintText", "", "removeInlay", "Companion", "TabToProceedGutterIconRenderer", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTabToProceedHintControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabToProceedHintControl.kt\ncom/android/studio/ml/suggestion/controls/TabToProceedHintControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class TabToProceedHintControl
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<Integer> moveToOffsetSupplier;
    @NotNull
    private final Function0<Rectangle> suggestionBoundsProvider;
    @Nullable
    private Inlay<?> currentInlay;
    public static final int $stable = 8;

    public TabToProceedHintControl(@NotNull Editor editor2, @NotNull Function0<Integer> moveToOffsetSupplier, @NotNull AnAction gutterIconClickAction, @NotNull Disposable parentDisposable, @NotNull Function0<? extends Rectangle> suggestionBoundsProvider) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(moveToOffsetSupplier, (String)"moveToOffsetSupplier");
        Intrinsics.checkNotNullParameter((Object)gutterIconClickAction, (String)"gutterIconClickAction");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(suggestionBoundsProvider, (String)"suggestionBoundsProvider");
        this.editor = editor2;
        this.moveToOffsetSupplier = moveToOffsetSupplier;
        this.suggestionBoundsProvider = suggestionBoundsProvider;
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        this.addInlay();
        this.editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Integer n = this.currentInlayLine();
                if (n == null || this.currentCaretLine() != n) {
                    this.removeInlay();
                    this.addInlay();
                }
            }
        }, (Disposable)this);
        this.addGutterIcon(this.moveToOffsetSupplier, gutterIconClickAction);
    }

    private final void removeInlay() {
        block0: {
            Inlay<?> inlay = this.currentInlay;
            if (inlay == null) break block0;
            Inlay<?> it = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
            this.currentInlay = null;
        }
    }

    private final void addInlay() {
        Inlay inlay;
        InlayPresentation inlayPresentation = this.createInlayPresentationForTabToMove(this.editor);
        int caretOffset2 = this.editor.getCaretModel().getOffset();
        Rectangle suggestionBounds = (Rectangle)this.suggestionBoundsProvider.invoke();
        if (suggestionBounds != null) {
            int lineNumber = this.editor.getDocument().getLineNumber(caretOffset2);
            int lineEndOffset = this.editor.getDocument().getLineEndOffset(lineNumber);
            Point point = this.editor.offsetToXY(lineEndOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            Point inlayPlacementXY = point;
            Rectangle hintBounds = new Rectangle(inlayPlacementXY.x, inlayPlacementXY.y, inlayPresentation.getWidth(), inlayPresentation.getHeight());
            if (hintBounds.intersects(suggestionBounds)) {
                return;
            }
        }
        if ((inlay = this.editor.getInlayModel().addAfterLineEndElement(caretOffset2, new InlayProperties(), (EditorCustomElementRenderer)new PresentationRenderer(inlayPresentation))) == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)inlay));
        this.currentInlay = inlay;
    }

    private final int currentCaretLine() {
        return this.editor.getDocument().getLineNumber(this.editor.getCaretModel().getOffset());
    }

    private final Integer currentInlayLine() {
        Integer n;
        Inlay<?> inlay = this.currentInlay;
        if (inlay != null) {
            Inlay<?> it = inlay;
            boolean bl = false;
            int offset2 = it.getOffset();
            n = this.editor.getDocument().getLineNumber(offset2);
        } else {
            n = null;
        }
        return n;
    }

    private final InlayPresentation createInlayPresentationForTabToMove(Editor editor2) {
        Color tabTextBackgroundColor = EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)Lookup.LOOKUP_COLOR);
        Color tabTextBorderColor = DefaultLanguageHighlighterColors.INLAY_DEFAULT.getDefaultAttributes().getForegroundColor();
        ScaleAwarePresentationFactory $this$createInlayPresentationForTabToMove_u24lambda_u240 = new ScaleAwarePresentationFactory(editor2, new PresentationFactory(editor2));
        boolean bl = false;
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{TabToProceedHintControl.Companion.withBorder(TabToProceedHintControl.Companion.withRoundedCornerBox($this$createInlayPresentationForTabToMove_u24lambda_u240.smallText(ShortcutExtensionsKt.asString(KeymapUtil.getPrimaryShortcut((String)"NextEditPredictionProceedAction"))), (InlayPresentationFactory)$this$createInlayPresentationForTabToMove_u24lambda_u240, tabTextBackgroundColor), (InlayPresentationFactory)$this$createInlayPresentationForTabToMove_u24lambda_u240, tabTextBorderColor), com.android.studio.ml.suggestion.controls.TabToProceedHintControl$Companion.withBorder$default(Companion, com.android.studio.ml.suggestion.controls.TabToProceedHintControl$Companion.withRoundedCornerBox$default(Companion, $this$createInlayPresentationForTabToMove_u24lambda_u240.smallText(this.getInlayHintText(editor2)), (InlayPresentationFactory)$this$createInlayPresentationForTabToMove_u24lambda_u240, null, 2, null), (InlayPresentationFactory)$this$createInlayPresentationForTabToMove_u24lambda_u240, null, 2, null)};
        return TabToProceedHintControl.Companion.verticallyCentered($this$createInlayPresentationForTabToMove_u24lambda_u240.seq(inlayPresentationArray), $this$createInlayPresentationForTabToMove_u24lambda_u240);
    }

    @VisibleForTesting
    @NotNull
    public final String getInlayHintText(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int moveToLineNumber = document3.getLineNumber(((Number)this.moveToOffsetSupplier.invoke()).intValue()) + 1;
        int currentLineNumber = document3.getLineNumber(editor2.getCaretModel().getOffset()) + 1;
        if (moveToLineNumber != currentLineNumber) {
            return "to move to line " + moveToLineNumber;
        }
        return "to move";
    }

    private final void addGutterIcon(Function0<Integer> moveToOffsetSupplier, AnAction gutterIconClickAction) {
        RangeHighlighter rangeHighlighter;
        int offset2 = ((Number)moveToOffsetSupplier.invoke()).intValue();
        RangeHighlighter $this$addGutterIcon_u24lambda_u240 = rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset2, offset2, 1000, null, HighlighterTargetArea.EXACT_RANGE);
        boolean bl = false;
        $this$addGutterIcon_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)new TabToProceedGutterIconRenderer(gutterIconClickAction));
        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"apply(...)");
        RangeHighlighter rangeHighlighter3 = rangeHighlighter2;
        Disposer.register((Disposable)((Disposable)this), () -> TabToProceedHintControl.addGutterIcon$lambda$1(this, rangeHighlighter3));
    }

    private static final void addGutterIcon$lambda$1(TabToProceedHintControl this$0, RangeHighlighter $rangeHighlighter) {
        this$0.editor.getMarkupModel().removeHighlighter($rangeHighlighter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J&\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J \u0010\u000e\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/suggestion/controls/TabToProceedHintControl$Companion;", "", "()V", "verticallyCentered", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/ScaleAwarePresentationFactory;", "withBorder", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory;", "backgroundColor", "Ljava/awt/Color;", "withContainer", "padding", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$Padding;", "withRoundedCornerBox", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        private final InlayPresentation withBorder(InlayPresentation $this$withBorder, InlayPresentationFactory factory, Color backgroundColor) {
            return this.withContainer($this$withBorder, factory, new InlayPresentationFactory.Padding(1, 1, 1, 1), backgroundColor);
        }

        static /* synthetic */ InlayPresentation withBorder$default(Companion companion, InlayPresentation inlayPresentation, InlayPresentationFactory inlayPresentationFactory, Color color, int n, Object object) {
            if ((n & 2) != 0) {
                color = null;
            }
            return companion.withBorder(inlayPresentation, inlayPresentationFactory, color);
        }

        private final InlayPresentation withRoundedCornerBox(InlayPresentation $this$withRoundedCornerBox, InlayPresentationFactory factory, Color backgroundColor) {
            return this.withContainer($this$withRoundedCornerBox, factory, new InlayPresentationFactory.Padding(3, 3, 2, 0), backgroundColor);
        }

        static /* synthetic */ InlayPresentation withRoundedCornerBox$default(Companion companion, InlayPresentation inlayPresentation, InlayPresentationFactory inlayPresentationFactory, Color color, int n, Object object) {
            if ((n & 2) != 0) {
                color = null;
            }
            return companion.withRoundedCornerBox(inlayPresentation, inlayPresentationFactory, color);
        }

        private final InlayPresentation withContainer(InlayPresentation $this$withContainer, InlayPresentationFactory factory, InlayPresentationFactory.Padding padding, Color backgroundColor) {
            return factory.container($this$withContainer, padding, new InlayPresentationFactory.RoundedCorners(8, 8), backgroundColor, backgroundColor == null ? 0.0f : 1.0f);
        }

        private final InlayPresentation verticallyCentered(InlayPresentation $this$verticallyCentered, ScaleAwarePresentationFactory factory) {
            return factory.lineCentered($this$verticallyCentered);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/suggestion/controls/TabToProceedHintControl$TabToProceedGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "clickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnAction;)V", "equals", "", "other", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "getIcon", "Ljavax/swing/Icon;", "hashCode", "", "MyIcon", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=0)
    public static final class TabToProceedGutterIconRenderer
    extends GutterIconRenderer {
        @NotNull
        private final AnAction clickAction;
        public static final int $stable = 8;

        public TabToProceedGutterIconRenderer(@NotNull AnAction clickAction) {
            Intrinsics.checkNotNullParameter((Object)clickAction, (String)"clickAction");
            this.clickAction = clickAction;
        }

        public boolean equals(@Nullable Object other) {
            return other == this;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public AnAction getClickAction() {
            return this.clickAction;
        }

        @NotNull
        public Icon getIcon() {
            return MyIcon.INSTANCE;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            return GutterIconRenderer.Alignment.RIGHT;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/studio/ml/suggestion/controls/TabToProceedHintControl$TabToProceedGutterIconRenderer$MyIcon;", "Ljavax/swing/Icon;", "()V", "ICON_PADDING", "", "backgroundColor", "Lcom/intellij/ui/JBColor;", "colorizedIcon", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "aiplugin.core.aicore"})
        private static final class MyIcon
        implements Icon {
            @NotNull
            public static final MyIcon INSTANCE = new MyIcon();
            @NotNull
            private static final JBColor backgroundColor = new JBColor(4621050, 5540599);
            @NotNull
            private static final Icon colorizedIcon;
            private static final int ICON_PADDING = 4;

            private MyIcon() {
            }

            @Override
            public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                g.setColor((Color)backgroundColor);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                colorizedIcon.paintIcon(c, g, x + JBUIScale.scale((int)4), y);
            }

            @Override
            public int getIconWidth() {
                return colorizedIcon.getIconWidth() + JBUIScale.scale((int)8);
            }

            @Override
            public int getIconHeight() {
                return colorizedIcon.getIconHeight();
            }

            static {
                Icon icon2 = AllIcons.General.ArrowRight;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ArrowRight");
                Color color = Color.WHITE;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
                colorizedIcon = IconUtilCompat.INSTANCE.colorize(icon2, color, false, false);
            }
        }
    }
}

