/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/suggestion/controls/FoldingRegionEnforcer;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;)V", "markers", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/intellij/openapi/editor/RangeMarker;", "kotlin.jvm.PlatformType", "", "enforce", "", "keepExpanded", "marker", "lifetime", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFoldingRegionEnforcer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FoldingRegionEnforcer.kt\ncom/android/studio/ml/suggestion/controls/FoldingRegionEnforcer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1761#2,3:93\n*S KotlinDebug\n*F\n+ 1 FoldingRegionEnforcer.kt\ncom/android/studio/ml/suggestion/controls/FoldingRegionEnforcer\n*L\n81#1:93,3\n*E\n"})
public final class FoldingRegionEnforcer {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    private final ConcurrentHashMap.KeySetView<RangeMarker, Boolean> markers;
    public static final int $stable = 8;

    public FoldingRegionEnforcer(@NotNull Project project2, @NotNull Editor editor2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project2;
        this.editor = editor2;
        this.markers = ConcurrentHashMap.newKeySet();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            /*
             * WARNING - void declaration
             */
            public void daemonFinished(Collection<? extends FileEditor> fileEditors) {
                boolean bl;
                block4: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                    Iterable iterable = fileEditors;
                    FoldingRegionEnforcer foldingRegionEnforcer = this;
                    boolean $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FileEditor it = (FileEditor)element$iv;
                            boolean bl2 = false;
                            TextEditor textEditor = it instanceof TextEditor ? (TextEditor)it : null;
                            if (!Intrinsics.areEqual((Object)(textEditor != null ? textEditor.getEditor() : null), (Object)foldingRegionEnforcer.editor)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.enforce();
                }
            }
        });
    }

    public final void keepExpanded(@NotNull RangeMarker marker, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.markers.add(marker);
        Disposer.register((Disposable)lifetime, () -> FoldingRegionEnforcer.keepExpanded$lambda$0(this, marker));
    }

    public final void enforce() {
        if (this.editor.isDisposed() || this.markers.isEmpty()) {
            return;
        }
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"getFoldingModel(...)");
        FoldingModel foldingModel2 = foldingModel;
        ApplicationKt.getApplication().invokeLater(() -> FoldingRegionEnforcer.enforce$lambda$0(foldingModel2, this));
    }

    private static final void keepExpanded$lambda$0(FoldingRegionEnforcer this$0, RangeMarker $marker) {
        this$0.markers.remove($marker);
        CodeFoldingManager.getInstance((Project)this$0.project).scheduleAsyncFoldingUpdate(this$0.editor);
    }

    private static final void enforce$lambda$0(FoldingModel $foldingModel, FoldingRegionEnforcer this$0) {
        $foldingModel.runBatchFoldingOperation(() -> FoldingRegionEnforcer.enforce$lambda$0$0($foldingModel, this$0));
    }

    private static final void enforce$lambda$0$0(FoldingModel $foldingModel, FoldingRegionEnforcer this$0) {
        FoldRegion[] foldRegionArray = $foldingModel.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        for (FoldRegion region : foldRegionArray) {
            boolean overlapsAnyMarker;
            block5: {
                if (!region.isValid() || region.shouldNeverExpand()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)region.getTextRange(), (String)"getTextRange(...)");
                ConcurrentHashMap.KeySetView<RangeMarker, Boolean> keySetView = this$0.markers;
                Intrinsics.checkNotNullExpressionValue(keySetView, (String)"markers");
                Iterable $this$any$iv = keySetView;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextRange regionRange;
                        RangeMarker it = (RangeMarker)element$iv;
                        boolean bl = false;
                        if (!(it.isValid() && regionRange.intersects(it.getTextRange()))) continue;
                        v2 = true;
                        break block5;
                    }
                    v2 = overlapsAnyMarker = false;
                }
            }
            if (!overlapsAnyMarker) continue;
            if (!region.isExpanded()) {
                region.setExpanded(true);
            }
            $foldingModel.removeFoldRegion(region);
        }
    }
}

