/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/suggestion/controls/CodeFolder;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "updateFoldsOnDispose", "", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;ZLcom/intellij/openapi/editor/FoldingModel;Lcom/intellij/openapi/editor/FoldRegion;)V", "dispose", "", "CodeFolderService", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
public final class CodeFolder
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    private final boolean updateFoldsOnDispose;
    @NotNull
    private final FoldingModel foldingModel;
    @NotNull
    private final FoldRegion foldRegion;
    public static final int $stable = 8;

    public CodeFolder(@NotNull Project project2, @NotNull Editor editor2, boolean updateFoldsOnDispose, @NotNull FoldingModel foldingModel, @NotNull FoldRegion foldRegion) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        Intrinsics.checkNotNullParameter((Object)foldRegion, (String)"foldRegion");
        this.project = project2;
        this.editor = editor2;
        this.updateFoldsOnDispose = updateFoldsOnDispose;
        this.foldingModel = foldingModel;
        this.foldRegion = foldRegion;
    }

    public void dispose() {
        if (this.editor.isDisposed()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperation(() -> CodeFolder.dispose$lambda$0(this));
        if (this.updateFoldsOnDispose) {
            CodeFoldingManager.getInstance((Project)this.project).scheduleAsyncFoldingUpdate(this.editor);
        }
    }

    private static final void dispose$lambda$0(CodeFolder this$0) {
        this$0.foldingModel.runBatchFoldingOperation(() -> CodeFolder.dispose$lambda$0$0(this$0));
    }

    private static final void dispose$lambda$0$0(CodeFolder this$0) {
        this$0.foldingModel.removeFoldRegion(this$0.foldRegion);
    }

    @Service
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/suggestion/controls/CodeFolder$CodeFolderService;", "", "()V", "create", "Lcom/android/studio/ml/suggestion/controls/CodeFolder;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "aiplugin.core.aicore"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nCodeFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFolder.kt\ncom/android/studio/ml/suggestion/controls/CodeFolder$CodeFolderService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1#2:126\n774#3:127\n865#3,2:128\n*S KotlinDebug\n*F\n+ 1 CodeFolder.kt\ncom/android/studio/ml/suggestion/controls/CodeFolder$CodeFolderService\n*L\n68#1:127\n68#1:128,2\n*E\n"})
    public static final class CodeFolderService {
        public static final int $stable;

        @Nullable
        public final CodeFolder create(@NotNull Project project2, @NotNull Editor editor2, @NotNull TextRange textRange) {
            CodeFolder codeFolder;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            if (!(textRange.getLength() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            FoldingModel foldingModel = editor2.getFoldingModel();
            FoldingModelEx foldingModelEx = foldingModel instanceof FoldingModelEx ? (FoldingModelEx)foldingModel : null;
            if (foldingModelEx == null) {
                return null;
            }
            FoldingModelEx foldingModel2 = foldingModelEx;
            Ref.ObjectRef foldRegion = new Ref.ObjectRef();
            Ref.BooleanRef updateFoldsOnDispose = new Ref.BooleanRef();
            foldingModel2.runBatchFoldingOperation(() -> CodeFolderService.create$lambda$0(foldRegion, foldingModel2, textRange, updateFoldsOnDispose));
            FoldRegion foldRegion2 = (FoldRegion)foldRegion.element;
            if (foldRegion2 != null) {
                FoldRegion it = foldRegion2;
                boolean bl = false;
                codeFolder = new CodeFolder(project2, editor2, updateFoldsOnDispose.element, (FoldingModel)foldingModel2, it);
            } else {
                codeFolder = null;
            }
            return codeFolder;
        }

        /*
         * WARNING - void declaration
         */
        private static final void create$lambda$0(Ref.ObjectRef $foldRegion, FoldingModelEx $foldingModel, TextRange $textRange, Ref.BooleanRef $updateFoldsOnDispose) {
            $foldRegion.element = $foldingModel.createFoldRegion($textRange.getStartOffset(), $textRange.getEndOffset(), "", null, true);
            if ($foldRegion.element == null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                List list = $foldingModel.getRegionsOverlappingWith($textRange.getStartOffset(), $textRange.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
                Iterable iterable = list;
                boolean $i$f$filter = false;
                void var7_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange intersection;
                    FoldRegion overlapping = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)overlapping.getTextRange(), (Object)$textRange) ? true : !Intrinsics.areEqual((Object)(intersection = overlapping.getTextRange().intersection($textRange)), (Object)overlapping.getTextRange()) && !Intrinsics.areEqual((Object)intersection, (Object)$textRange))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List regionsToRemove = (List)destination$iv$iv;
                for (FoldRegion region : regionsToRemove) {
                    $updateFoldsOnDispose.element = true;
                    $foldingModel.removeFoldRegion(region);
                }
                $foldRegion.element = $foldingModel.createFoldRegion($textRange.getStartOffset(), $textRange.getEndOffset(), "", null, true);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lcom/android/studio/ml/suggestion/controls/CodeFolder$Companion;", "", "()V", "create", "Lcom/android/studio/ml/suggestion/controls/CodeFolder;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "ensureExpanded", "", "getOverlappingFoldedRegions", "", "Lcom/intellij/openapi/editor/FoldRegion;", "isInFoldedRegion", "", "aiplugin.core.aicore"})
    @SourceDebugExtension(value={"SMAP\nCodeFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFolder.kt\ncom/android/studio/ml/suggestion/controls/CodeFolder$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n30#2,2:126\n774#3:128\n865#3,2:129\n*S KotlinDebug\n*F\n+ 1 CodeFolder.kt\ncom/android/studio/ml/suggestion/controls/CodeFolder$Companion\n*L\n99#1:126,2\n121#1:128\n121#1:129,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CodeFolder create(@NotNull Project project2, @NotNull Editor editor2, @NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<CodeFolderService> serviceClass$iv = CodeFolderService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((CodeFolderService)object).create(project2, editor2, textRange);
        }

        public final void ensureExpanded(@NotNull Editor editor2, @NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            FoldingModel foldingModel = editor2.getFoldingModel();
            FoldingModelEx foldingModelEx = foldingModel instanceof FoldingModelEx ? (FoldingModelEx)foldingModel : null;
            if (foldingModelEx == null) {
                return;
            }
            FoldingModelEx foldingModel2 = foldingModelEx;
            foldingModel2.runBatchFoldingOperation(() -> Companion.ensureExpanded$lambda$0(editor2, textRange));
        }

        public final boolean isInFoldedRegion(@NotNull Editor editor2, @NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            return !((Collection)this.getOverlappingFoldedRegions(editor2, textRange)).isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private final List<FoldRegion> getOverlappingFoldedRegions(Editor editor2, TextRange textRange) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            FoldingModel foldingModel = editor2.getFoldingModel();
            FoldingModelEx foldingModelEx = foldingModel instanceof FoldingModelEx ? (FoldingModelEx)foldingModel : null;
            if (foldingModelEx == null) {
                return CollectionsKt.emptyList();
            }
            FoldingModelEx foldingModel2 = foldingModelEx;
            List list = foldingModel2.getRegionsOverlappingWith(textRange.getStartOffset(), textRange.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegionsOverlappingWith(...)");
            Iterable iterable = list;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FoldRegion it = (FoldRegion)element$iv$iv;
                boolean bl = false;
                if (!(!it.isExpanded() && it.getTextRange().contains(textRange))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final void ensureExpanded$lambda$0(Editor $editor, TextRange $textRange) {
            for (FoldRegion region : Companion.getOverlappingFoldedRegions($editor, $textRange)) {
                region.setExpanded(true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

