/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.releasenotes.fetchers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Version;
import com.android.studio.ml.releasenotes.ReleaseNotes;
import com.android.studio.ml.releasenotes.ReleaseNotesContentProvider;
import com.android.studio.ml.releasenotes.ReleaseNotesQuery;
import com.android.studio.ml.releasenotes.ReleaseNotesUtils;
import com.android.studio.ml.releasenotes.fetchers.ReleaseNotesFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/releasenotes/fetchers/FirebaseReleaseNotesFetcher;", "Lcom/android/studio/ml/releasenotes/fetchers/ReleaseNotesFetcher;", "<init>", "()V", "url", "", "getReleaseNotesUrl", "Ljava/net/URL;", "query", "Lcom/android/studio/ml/releasenotes/ReleaseNotesQuery;", "fetch", "", "Lcom/android/studio/ml/releasenotes/ReleaseNotes;", "request", "contentProvider", "Lcom/android/studio/ml/releasenotes/ReleaseNotesContentProvider;", "getReleaseNotesHtmlPage", "aiplugin.android"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nFirebaseReleaseNotesFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseReleaseNotesFetcher.kt\ncom/android/studio/ml/releasenotes/fetchers/FirebaseReleaseNotesFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class FirebaseReleaseNotesFetcher
implements ReleaseNotesFetcher {
    @NotNull
    private final String url;
    public static final int $stable;

    public FirebaseReleaseNotesFetcher() {
        this.url = "https://firebase.google.com/support/release-notes/android/index.html";
    }

    @Override
    @NotNull
    public URL getReleaseNotesUrl(@NotNull ReleaseNotesQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return new URL(this.url);
    }

    @Override
    @Nullable
    public List<ReleaseNotes> fetch(@NotNull ReleaseNotesQuery request2, @NotNull ReleaseNotesContentProvider contentProvider) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        String artifact = request2.getLibrary().getArtifact();
        String newVersion = request2.getTargetVersion();
        Version oldVersion = request2.getLibrary().getVersion();
        String html = this.getReleaseNotesHtmlPage(contentProvider);
        Version from = oldVersion;
        Version to = Version.Companion.parse(newVersion);
        String artifactName = switch (artifact) {
            case "com.google.firebase.crashlytics.gradle.plugin" -> "crashlytics_gradle_plugin";
            case "com.google.firebase.appdistribution.gradle.plugin" -> "appdistro_gradle_plugin";
            case "com.google.firebase.firebase-perf.gradle.plugin" -> "performance_gradle_plugin";
            default -> StringsKt.removePrefix((String)artifact, (CharSequence)"firebase-");
        };
        int offset2 = 0;
        String h3 = "<h3 id=\"" + artifactName + "_v";
        String h4 = "<h4 id=\"" + artifactName + "_v";
        List releaseNotes = new ArrayList();
        while (true) {
            int n;
            int nextH3 = StringsKt.indexOf$default((CharSequence)html, (String)h3, (int)offset2, (boolean)false, (int)4, null);
            int nextH4 = StringsKt.indexOf$default((CharSequence)html, (String)h4, (int)offset2, (boolean)false, (int)4, null);
            if (nextH3 == -1) {
                if (nextH4 == -1) break;
                n = nextH4;
            } else {
                n = nextH4 == -1 ? nextH3 : Math.min(nextH3, nextH4);
            }
            int next = n;
            int versionStart = next + h3.length();
            int versionEnd = StringsKt.indexOf$default((CharSequence)html, (String)"\"", (int)versionStart, (boolean)false, (int)4, null);
            if (versionEnd == -1) break;
            int it = StringsKt.indexOf$default((CharSequence)html, (String)("</h" + html.charAt(next + 2) + ">"), (int)versionEnd, (boolean)false, (int)4, null);
            boolean bl = false;
            int contentStart = it == -1 ? next : it + 5;
            int it2 = StringsKt.indexOf$default((CharSequence)html, (String)"\n<h", (int)versionEnd, (boolean)false, (int)4, null);
            boolean bl2 = false;
            int end = it2 != -1 ? it2 : html.length();
            String string = html.substring(versionStart, versionEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Version version = Version.Companion.parse(StringsKt.replace$default((String)string, (String)"-", (String)".", (boolean)false, (int)4, null));
            if (version.compareTo(from) >= 0 && version.compareTo(to) <= 0) {
                String versionSnippet;
                Intrinsics.checkNotNullExpressionValue((Object)html.substring(contentStart, end), (String)"substring(...)");
                String cleanHtml = StringsKt.replace$default((String)StringsKt.replace$default((String)versionSnippet, (String)"<li><p>", (String)"<li>", (boolean)false, (int)4, null), (String)"</p></li>", (String)"</li>", (boolean)false, (int)4, null);
                StringBuilder sb = new StringBuilder();
                List lines = StringsKt.lines((CharSequence)cleanHtml);
                boolean inExcluded = false;
                for (String line : lines) {
                    if (inExcluded && !FirebaseReleaseNotesFetcher.fetch$shouldExclude(line)) {
                        String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                        if (!StringsKt.startsWith$default((String)trimmed, (String)"<li", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)trimmed, (String)"<ul", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)trimmed, (String)"</ul", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)trimmed, (String)"<p>", (boolean)false, (int)2, null)) continue;
                        inExcluded = false;
                    } else if (FirebaseReleaseNotesFetcher.fetch$shouldExclude(line)) {
                        inExcluded = true;
                        continue;
                    }
                    sb.append(line).append("\n");
                }
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String text2 = ReleaseNotesUtils.INSTANCE.stripMarkdownJunk(ReleaseNotesUtils.INSTANCE.convertToMarkdown(string2));
                if (!StringsKt.isBlank((CharSequence)text2)) {
                    releaseNotes.add(new ReleaseNotes(version, text2));
                }
            }
            offset2 = end;
        }
        return releaseNotes;
    }

    private final String getReleaseNotesHtmlPage(ReleaseNotesContentProvider contentProvider) {
        Object object = contentProvider.getReleaseNotes(new URL(this.url));
        if (object == null || (object = ((ReleaseNotesContentProvider.ReleaseNotesContent)object).getContent()) == null) {
            object = "";
        }
        return object;
    }

    private static final boolean fetch$shouldExclude(String line) {
        return StringsKt.contains$default((CharSequence)line, (CharSequence)"<span class=\"release-fixed\">", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"<p>The Kotlin extensions library transitively includes", (boolean)false, (int)2, null);
    }
}

