/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.layoutinspector;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.DefaultBrandingProviderFactory;
import com.android.studio.ml.StudioGeminiBundle;
import com.android.studio.ml.bot.BotToolWindowService;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.layoutinspector.StackTraceExtractorKt;
import com.android.studio.ml.layoutinspector.StateInspectionAgent;
import com.android.studio.ml.layoutinspector.StateInspectionRewriterKt;
import com.android.tools.idea.layoutinspector.stateinspection.ComposableDefinition;
import com.android.tools.idea.layoutinspector.stateinspection.ComposableDefinitionKt;
import com.android.tools.idea.layoutinspector.stateinspection.LayoutInspectorExplainWithAIHyperLinkInfo;
import com.android.tools.idea.studiobot.StudioBot;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolsProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/studio/ml/layoutinspector/StateInspectionFilter;", "Lcom/intellij/execution/filters/Filter;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "Companion", "StudioBotHyperlinkInfo", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class StateInspectionFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    public static final int $stable = 8;
    @NotNull
    private static final String linkText;

    public StateInspectionFilter(@NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!StudioBot.Companion.getInstance().isAvailable()) {
            return null;
        }
        int offset2 = entireLength - line.length();
        int start2 = StringsKt.indexOf$default((CharSequence)line, (String)linkText, (int)0, (boolean)false, (int)6, null);
        if (start2 < 0) {
            return null;
        }
        int end = start2 + linkText.length();
        Filter.ResultItem item = new Filter.ResultItem(start2 + offset2, end + offset2, (HyperlinkInfo)new StudioBotHyperlinkInfo(this.editor));
        return new Filter.Result(CollectionsKt.listOf((Object)item));
    }

    static {
        Object[] objectArray = new Object[]{DefaultBrandingProviderFactory.INSTANCE.forFirstParty().getAskText()};
        linkText = StudioGeminiBundle.Companion.message("layout.inspector.studio.bot.link.text", objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/layoutinspector/StateInspectionFilter$Companion;", "", "<init>", "()V", "linkText", "", "getLinkText", "()Ljava/lang/String;", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLinkText() {
            return linkText;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/layoutinspector/StateInspectionFilter$StudioBotHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "Lcom/android/tools/idea/layoutinspector/stateinspection/LayoutInspectorExplainWithAIHyperLinkInfo;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "aiplugin.android"})
    private static final class StudioBotHyperlinkInfo
    implements HyperlinkInfo,
    LayoutInspectorExplainWithAIHyperLinkInfo {
        @NotNull
        private final EditorEx editor;

        public StudioBotHyperlinkInfo(@NotNull EditorEx editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
        }

        public void navigate(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (!StateInspectionRewriterKt.stateInspectionAgentAvailable(project2) || !StudioBot.Companion.getInstance().chat(project2).isReadyToReceiveQuery(ResponseMode.Agent)) {
                return;
            }
            ComposableDefinition composableDefinition = (ComposableDefinition)this.editor.getUserData(ComposableDefinitionKt.getLAYOUT_INSPECTOR_COMPOSABLE_INSPECTED_KEY());
            if (composableDefinition == null) {
                return;
            }
            ComposableDefinition data2 = composableDefinition;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            String stackTrace = StackTraceExtractorKt.extractStateReadWithStackTrace((Document)documentEx, this.editor.getCaretModel().getOffset());
            Set<Tool<?>> tools2 = ToolsProvider.Companion.getTools(project2);
            StateInspectionAgent agent2 = new StateInspectionAgent(data2.getComposable(), data2.getFileName(), stackTrace, tools2, null, 16, null);
            String sessionText = "Exploring Recomposition State Reads";
            String displayText = "Explain State Read for " + data2.getComposable();
            ApplicationManager.getApplication().invokeLater(() -> StudioBotHyperlinkInfo.navigate$lambda$0(project2, agent2, displayText, sessionText));
        }

        private static final void navigate$lambda$0(Project $project, StateInspectionAgent $agent, String $displayText, String $sessionText) {
            BotToolWindowService.runAgentOnPinnedSession$default(BotToolWindowService.Companion.getInstance($project), $agent, $displayText, $sessionText, null, null, 24, null);
        }
    }
}

