/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.recorder;

import com.android.sdklib.deviceprovisioner.Resolution;
import com.android.studio.ml.journeys.recorder.Gesture;
import com.google.inputrecorder.proto.MotionEventProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a@\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0007\u001aD\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u001e\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u001a(\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n0\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001H\u0000\u001aL\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n0\u00012\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n0\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002\u00a8\u0006\u001a"}, d2={"quantizeGesturesToClipTimeCoordinates", "", "Lkotlin/Triple;", "", "", "events", "Lcom/google/inputrecorder/proto/MotionEventProto;", "offsetMs", "quantizationMs", "getVideoCursorPathString", "Lkotlin/Pair;", "", "cursorPath", "videoResolution", "Lcom/android/sdklib/deviceprovisioner/Resolution;", "screenResolution", "getGestureTimestamps", "gestures", "Lcom/android/studio/ml/journeys/recorder/Gesture;", "padGestureTimestamps", "timestamps", "startPadding", "endPadding", "frameTime", "formatTimeString", "ms", "aiplugin.android.journeys"})
@SourceDebugExtension(value={"SMAP\nVideoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoUtils.kt\ncom/android/studio/ml/journeys/recorder/VideoUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1878#2,3:146\n1869#2,2:149\n1563#2:151\n1634#2,3:152\n1573#2:155\n1604#2,4:156\n*S KotlinDebug\n*F\n+ 1 VideoUtils.kt\ncom/android/studio/ml/journeys/recorder/VideoUtilsKt\n*L\n41#1:146,3\n104#1:149,2\n117#1:151\n117#1:152,3\n126#1:155\n126#1:156,4\n*E\n"})
public final class VideoUtilsKt {
    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public static final List<Triple<Long, Integer, Integer>> quantizeGesturesToClipTimeCoordinates(@NotNull List<MotionEventProto> events, long offsetMs, int quantizationMs) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        List quantizer = new ArrayList();
        long previousTimeQuantized = 0L;
        Iterable $this$forEachIndexed$iv = events;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void event;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MotionEventProto motionEventProto = (MotionEventProto)item$iv;
            int index = n;
            boolean bl = false;
            long timeMs = TimeUnit.NANOSECONDS.toMillis(event.getEventTimeNanos()) - offsetMs;
            long timeQuantized = timeMs / (long)quantizationMs * (long)quantizationMs;
            if (timeQuantized == previousTimeQuantized) {
                if (quantizer.size() > 1) {
                    quantizer.removeLast();
                } else if (quantizer.size() == 1) {
                    timeQuantized = timeMs;
                }
            }
            previousTimeQuantized = timeQuantized;
            if (index == 0 || index == events.size() - 1) {
                timeQuantized = timeMs;
            }
            Triple quanta = new Triple((Object)timeQuantized, (Object)((int)((Number)CollectionsKt.first((List)event.getX())).floatValue()), (Object)((int)((Number)CollectionsKt.first((List)event.getY())).floatValue()));
            quantizer.add(quanta);
        }
        return quantizer;
    }

    public static /* synthetic */ List quantizeGesturesToClipTimeCoordinates$default(List list, long l2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 25;
        }
        return VideoUtilsKt.quantizeGesturesToClipTimeCoordinates(list, l2, n);
    }

    @TestOnly
    @NotNull
    public static final Pair<String, String> getVideoCursorPathString(@NotNull List<Triple<Long, Integer, Integer>> cursorPath, @NotNull Resolution videoResolution, @NotNull Resolution screenResolution) {
        Intrinsics.checkNotNullParameter(cursorPath, (String)"cursorPath");
        Intrinsics.checkNotNullParameter((Object)videoResolution, (String)"videoResolution");
        Intrinsics.checkNotNullParameter((Object)screenResolution, (String)"screenResolution");
        Pair pair = videoResolution.getWidth() >= screenResolution.getWidth() && videoResolution.getHeight() >= screenResolution.getHeight() ? new Pair((Object)screenResolution.getWidth(), (Object)screenResolution.getHeight()) : new Pair((Object)Math.min(screenResolution.getWidth() * videoResolution.getHeight() / screenResolution.getHeight(), videoResolution.getWidth()), (Object)Math.min(screenResolution.getHeight() * videoResolution.getWidth() / screenResolution.getWidth(), videoResolution.getHeight()));
        int videoDeviceWidth = ((Number)pair.component1()).intValue();
        int videoDeviceHeight = ((Number)pair.component2()).intValue();
        int xOffset = (videoResolution.getWidth() - videoDeviceWidth) / 2;
        int yOffset = (videoResolution.getHeight() - videoDeviceHeight) / 2;
        String time = null;
        time = VideoUtilsKt.formatTimeString(0L);
        String x = null;
        x = "NaN";
        String y = null;
        y = "NaN";
        StringBuilder xString = new StringBuilder("x='if(1");
        StringBuilder yString = new StringBuilder("y='if(1");
        Iterable $this$forEach$iv = cursorPath;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple it = (Triple)element$iv;
            boolean bl = false;
            time = VideoUtilsKt.formatTimeString(((Number)it.getFirst()).longValue());
            xString.append("*lt(t, " + time + "), " + x + ")");
            yString.append("*lt(t, " + time + "), " + y + ")");
            x = String.valueOf(((Number)it.getSecond()).intValue() * videoDeviceWidth / screenResolution.getWidth() + xOffset);
            y = String.valueOf(((Number)it.getThird()).intValue() * videoDeviceHeight / screenResolution.getHeight() + yOffset);
            xString.append("+if(gte(t, " + time + ")");
            yString.append("+if(gte(t, " + time + ")");
        }
        return new Pair((Object)xString.append(", NaN)'").toString(), (Object)yString.append(", NaN)'").toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Long, Long>> getGestureTimestamps(@NotNull List<Gesture> gestures) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(gestures, (String)"gestures");
        Iterable $this$map$iv = gestures;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Gesture gesture = (Gesture)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it.getVideoChunk().getGesture_start_ms(), (Object)it.getVideoChunk().getGesture_stop_ms()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public static final List<Pair<Long, Long>> padGestureTimestamps(@NotNull List<Pair<Long, Long>> timestamps, long startPadding, long endPadding, long frameTime) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(timestamps, (String)"timestamps");
        Iterable $this$mapIndexed$iv = timestamps;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void timestamp;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)(index > 0 ? RangesKt.coerceAtLeast((long)(((Number)timestamp.getFirst()).longValue() - startPadding), (long)Math.min(((Number)timestamp.getFirst()).longValue(), ((Number)timestamps.get((int)(index - true)).getSecond()).longValue() + frameTime)) : RangesKt.coerceAtLeast((long)(((Number)timestamp.getFirst()).longValue() - startPadding), (long)0L)), (Object)(index < timestamps.size() - 1 ? RangesKt.coerceAtMost((long)(((Number)timestamp.getSecond()).longValue() + endPadding), (long)Math.max(((Number)timestamp.getSecond()).longValue(), ((Number)timestamps.get((int)(index + true)).getFirst()).longValue() - frameTime)) : ((Number)timestamp.getSecond()).longValue() + endPadding)));
        }
        return (List)destination$iv$iv;
    }

    private static final String formatTimeString(long ms) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(ms);
        String string = seconds + ".%03d";
        Object[] objectArray = new Object[]{ms - TimeUnit.SECONDS.toMillis(seconds)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

