/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.recorder;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionKt;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.ddmlib.IDevice;
import com.android.studio.ml.journeys.JourneyUtils;
import com.android.studio.ml.journeys.JourneysEditor;
import com.android.studio.ml.journeys.JourneysSplitEditor;
import com.android.studio.ml.journeys.recorder.RecorderService;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.studiobot.StudioBot;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import icons.StudioIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/studio/ml/journeys/recorder/RecordAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
public final class RecordAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;

    public void update(@NotNull AnActionEvent e) {
        Presentation it;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Intrinsics.areEqual((Object)StudioFlags.JOURNEYS_WITH_GEMINI_EXECUTION.get(), (Object)true) || !Intrinsics.areEqual((Object)StudioFlags.JOURNEYS_WITH_GEMINI_RECORDING.get(), (Object)true)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        e.getPresentation().setIcon(StudioIcons.Profiler.Toolbar.RECORD);
        Project project2 = e.getProject();
        if (project2 == null) {
            Presentation it2 = e.getPresentation();
            boolean bl = false;
            it2.setEnabled(false);
            it2.setText("Record Journeys");
            it2.setDescription("No project detected");
            return;
        }
        if (!StudioBot.Companion.getInstance().isAvailable()) {
            it = e.getPresentation();
            boolean bl = false;
            it.setEnabled(false);
            it.setText("Record Journeys");
            it.setDescription("Gemini not enabled and signed in");
        }
        it = e.getPresentation();
        boolean bl = false;
        it.setEnabled(true);
        RecorderService service = RecorderService.Companion.getInstance(project2);
        if (service.getRunningState().getValue() == RecorderService.Companion.RunningState.RUNNING) {
            it.setText("Stop Journeys");
            it.setDescription("Stop Journeys with Gemini recording");
            it.setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING);
        } else if (service.getRunningState().getValue() == RecorderService.Companion.RunningState.STOPPED) {
            it.setText("Record Journeys");
            it.setDescription("Start Journeys with Gemini recording");
            it.setIcon(StudioIcons.Profiler.Toolbar.RECORD);
        } else if (service.getRunningState().getValue() == RecorderService.Companion.RunningState.STARTING) {
            it.setText("Starting Journeys");
            it.setDescription("Starting Journeys with Gemini...");
            it.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
            it.setEnabled(false);
        } else {
            it.setText("Stopping Journeys");
            it.setDescription("Stopping Journeys with Gemini...");
            it.setIcon(StudioIcons.Profiler.Toolbar.STOP_SESSION);
            it.setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Intrinsics.areEqual((Object)StudioFlags.JOURNEYS_WITH_GEMINI_RECORDING.get(), (Object)true)) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Object object = e.getData(PlatformCoreDataKeys.FILE_EDITOR);
        Object object2 = object instanceof JourneysSplitEditor ? (JourneysSplitEditor)((Object)object) : null;
        if (object2 == null || (object2 = (JourneysEditor)object2.getPreview()) == null) {
            return;
        }
        Object editor2 = object2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/journeys/recorder/RecordAction$Companion;", "", "<init>", "()V", "actionPerformed", "", "project", "Lcom/intellij/openapi/project/Project;", "appendMethod", "Lkotlin/Function1;", "", "aiplugin.android.journeys"})
    public static final class Companion {
        private Companion() {
        }

        public final void actionPerformed(@NotNull Project project2, @NotNull Function1<? super String, Unit> appendMethod) {
            String packageName;
            ConnectedDevice device;
            String[] stringArray;
            Collection runningDevices;
            RunConfiguration runConfig;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(appendMethod, (String)"appendMethod");
            if (!Intrinsics.areEqual((Object)StudioFlags.JOURNEYS_WITH_GEMINI_RECORDING.get(), (Object)true)) {
                return;
            }
            if (!JourneyUtils.INSTANCE.checkIfUserIsLoggedIntoGeminiPlugin(project2)) {
                return;
            }
            Object overridePackage = null;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project2).getSelectedConfiguration();
            Object object = runConfig = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
            if (runConfig == null) {
                RecorderService.Companion.notify$aiplugin_android_journeys(project2, "Invalid run configuration selected.", NotificationType.WARNING);
                return;
            }
            ExecutionTarget executionTarget = ExecutionTargetManager.getInstance((Project)project2).getActiveTarget();
            AndroidExecutionTarget androidExecutionTarget = executionTarget instanceof AndroidExecutionTarget ? (AndroidExecutionTarget)executionTarget : null;
            Collection collection = runningDevices = androidExecutionTarget != null ? androidExecutionTarget.getRunningDevices() : null;
            if (runningDevices == null) {
                RecorderService.Companion.notify$aiplugin_android_journeys(project2, "No device selected.", NotificationType.WARNING);
                return;
            }
            IDevice iDevice = (IDevice)CollectionsKt.firstOrNull((Iterable)runningDevices);
            if (iDevice != null) {
                Object v4;
                block13: {
                    IDevice device2 = iDevice;
                    boolean bl = false;
                    stringArray = (String[])AdbSessionKt.getConnectedDevicesTracker((AdbSession)AdbLibService.Companion.getSession(project2)).getConnectedDevices().getValue();
                    for (Object t : stringArray) {
                        ConnectedDevice it = (ConnectedDevice)t;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)ConnectedDeviceKt.getSerialNumber((ConnectedDevice)it), (Object)device2.getSerialNumber()) && ConnectedDeviceKt.isOnline((ConnectedDevice)it))) continue;
                        v4 = t;
                        break block13;
                    }
                    v4 = null;
                }
                v5 = v4;
            } else {
                v5 = device = null;
            }
            if (device == null) {
                RecorderService.Companion.notify$aiplugin_android_journeys(project2, "Device not (fully) running; please wait and try again.", NotificationType.WARNING);
                return;
            }
            ApplicationIdProvider applicationIdProvider = ProjectSystemUtil.getProjectSystem((Project)project2).getApplicationIdProvider(runConfig);
            String string = packageName = applicationIdProvider != null ? applicationIdProvider.getPackageName() : null;
            if (packageName == null) {
                RecorderService.Companion.notify$aiplugin_android_journeys(project2, "Invalid application ID.", NotificationType.WARNING);
                return;
            }
            RecorderService recorderService = RecorderService.Companion.getInstance(project2);
            if (recorderService.getRunningState().getValue() == RecorderService.Companion.RunningState.STOPPED) {
                stringArray = new String[]{"journeys.with.gemini", packageName, ConnectedDeviceKt.getSerialNumber((ConnectedDevice)device), String.valueOf(System.currentTimeMillis())};
                Path path2 = Path.of(PathManager.getTempPath(), stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                File outputDir = new File(((Object)path2).toString());
                if (!outputDir.mkdirs()) {
                    RecorderService.Companion.notify$aiplugin_android_journeys(project2, "Could not create temp directories.", NotificationType.ERROR);
                }
                RecorderService.start$default(recorderService, appendMethod, device, outputDir, false, 0L, false, 56, null);
            } else if (recorderService.getRunningState().getValue() == RecorderService.Companion.RunningState.RUNNING) {
                RecorderService.Companion.getInstance(project2).stop();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

