/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.journeys.metrics.JourneyEngineErrorParser;
import com.android.studio.ml.journeys.metrics.JourneysTracker;
import com.android.studio.ml.journeys.metrics.JourneysTrackerKt;
import com.android.studio.ml.journeys.run.JourneysRunToken;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.Token;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.google.wireless.android.sdk.stats.JourneyEngineErrorEvent;
import com.google.wireless.android.sdk.stats.JourneyFinishedEvent;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "journeysTracker", "Lcom/android/studio/ml/journeys/metrics/JourneysTracker;", "project", "Lcom/intellij/openapi/project/Project;", "journeysRunTokenProvider", "Lkotlin/Function0;", "Lcom/android/studio/ml/journeys/run/JourneysRunToken;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "<init>", "(Lcom/android/studio/ml/journeys/metrics/JourneysTracker;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "journeysRunToken", "getJourneysRunToken", "()Lcom/android/studio/ml/journeys/run/JourneysRunToken;", "journeysRunToken$delegate", "Lkotlin/Lazy;", "onTestCaseFinished", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "testCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "isJourneyTestSuite", "", "aiplugin.android.journeys"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nJourneysTestResultMetricsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JourneysTestResultMetricsListener.kt\ncom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Token.kt\ncom/android/tools/idea/projectsystem/TokenKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n24#2:89\n47#3:90\n669#4,11:91\n*S KotlinDebug\n*F\n+ 1 JourneysTestResultMetricsListener.kt\ncom/android/studio/ml/journeys/metrics/JourneysTestResultMetricsListener\n*L\n76#1:89\n46#1:90\n46#1:91,11\n*E\n"})
public final class JourneysTestResultMetricsListener
implements AndroidTestResultListener {
    @NotNull
    private final JourneysTracker journeysTracker;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<JourneysRunToken<AndroidProjectSystem>> journeysRunTokenProvider;
    @NotNull
    private final Lazy journeysRunToken$delegate;
    public static final int $stable = 8;

    public JourneysTestResultMetricsListener(@NotNull JourneysTracker journeysTracker, @NotNull Project project2, @NotNull Function0<? extends JourneysRunToken<AndroidProjectSystem>> journeysRunTokenProvider) {
        Intrinsics.checkNotNullParameter((Object)journeysTracker, (String)"journeysTracker");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(journeysRunTokenProvider, (String)"journeysRunTokenProvider");
        this.journeysTracker = journeysTracker;
        this.project = project2;
        this.journeysRunTokenProvider = journeysRunTokenProvider;
        this.journeysRunToken$delegate = LazyKt.lazy(() -> JourneysTestResultMetricsListener.journeysRunToken_delegate$lambda$0(this));
    }

    public /* synthetic */ JourneysTestResultMetricsListener(JourneysTracker journeysTracker, Project project2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = () -> JourneysTestResultMetricsListener._init_$lambda$0(project2);
        }
        this(journeysTracker, project2, (Function0<? extends JourneysRunToken<AndroidProjectSystem>>)function0);
    }

    private final JourneysRunToken<AndroidProjectSystem> getJourneysRunToken() {
        Lazy lazy = this.journeysRunToken$delegate;
        return (JourneysRunToken)lazy.getValue();
    }

    public void onTestCaseFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testSuite, (String)"testSuite");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        if (!this.isJourneyTestSuite(testSuite)) {
            return;
        }
        String errorStackTrace = testCase.getErrorStackTrace();
        if (!(((CharSequence)errorStackTrace).length() == 0) && !JourneyEngineErrorParser.Companion.isEngineAssertionException(errorStackTrace)) {
            String reason = JourneyEngineErrorParser.Companion.tryToParseReasonFromEngineException(errorStackTrace);
            JourneyEngineErrorEvent.ErrorType errorType = JourneysTrackerKt.mapErrorType(reason);
            this.journeysTracker.trackJourneyError(errorType);
            this.journeysTracker.trackJourneyFinished(JourneyFinishedEvent.TestResult.ABORTED);
        } else {
            JourneyFinishedEvent.TestResult result2 = JourneysTrackerKt.mapToMetricsType(testCase.getResult());
            if (result2 == null) {
                JourneysTestResultMetricsListener $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JourneysTestResultMetricsListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Journey test finished with unexpected result: " + testCase.getResult());
                return;
            }
            this.journeysTracker.trackJourneyFinished(result2);
        }
    }

    private final boolean isJourneyTestSuite(AndroidTestSuite testSuite) {
        RunConfiguration runConfiguration = testSuite.getRunConfiguration();
        if (runConfiguration == null) {
            return false;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        JourneysRunToken<AndroidProjectSystem> journeysRunToken = this.getJourneysRunToken();
        return journeysRunToken != null ? journeysRunToken.isRunConfigurationForJourney(runConfiguration2) : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final JourneysRunToken _init_$lambda$0(Project $project) {
        Object v0;
        block2: {
            AndroidProjectSystem androidProjectSystem = ProjectSystemUtil.getProjectSystem((Project)$project);
            ExtensionPointName<JourneysRunToken<AndroidProjectSystem>> extensionPointName$iv = JourneysRunToken.Companion.getEP_NAME();
            boolean $i$f$getTokenOrNull = false;
            Iterable $this$singleOrNull$iv$iv = extensionPointName$iv.getExtensionList();
            boolean $i$f$singleOrNull = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                void $this$getTokenOrNull$iv;
                Token it$iv = (Token)element$iv$iv;
                boolean bl = false;
                if (!it$iv.isApplicable((AndroidProjectSystem)$this$getTokenOrNull$iv)) continue;
                if (found$iv$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv$iv = element$iv$iv;
                found$iv$iv = true;
            }
            v0 = !found$iv$iv ? null : single$iv$iv;
        }
        return (JourneysRunToken)((Token)v0);
    }

    private static final JourneysRunToken journeysRunToken_delegate$lambda$0(JourneysTestResultMetricsListener this$0) {
        return (JourneysRunToken)this$0.journeysRunTokenProvider.invoke();
    }
}

