/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.gradle.template;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.studio.ml.journeys.gradle.template.NewJourneyWizardModel;
import com.android.tools.adtui.validation.Validator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/journeys/gradle/template/JourneyFileNameValidator;", "Lcom/android/tools/adtui/validation/Validator;", "", "fieldName", "wizardModel", "Lcom/android/studio/ml/journeys/gradle/template/NewJourneyWizardModel;", "<init>", "(Ljava/lang/String;Lcom/android/studio/ml/journeys/gradle/template/NewJourneyWizardModel;)V", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "value", "aiplugin.android.journeys.gradle"})
public final class JourneyFileNameValidator
implements Validator<String> {
    @NotNull
    private final String fieldName;
    @NotNull
    private final NewJourneyWizardModel wizardModel;

    public JourneyFileNameValidator(@NotNull String fieldName, @NotNull NewJourneyWizardModel wizardModel) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)((Object)wizardModel), (String)"wizardModel");
        this.fieldName = fieldName;
        this.wizardModel = wizardModel;
    }

    @NotNull
    public Validator.Result validate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            return new Validator.Result(Validator.Severity.ERROR, this.fieldName + ": Name should not be empty", null, 4, null);
        }
        String error = FileResourceNameValidator.getErrorTextForNameWithoutExtension((String)value, (ResourceFolderType)ResourceFolderType.XML);
        if (error != null) {
            return new Validator.Result(Validator.Severity.ERROR, this.fieldName + ": " + error, null, 4, null);
        }
        String fileName = value + ".journey.xml";
        if (this.wizardModel.journeyFileExists(fileName)) {
            return new Validator.Result(Validator.Severity.ERROR, this.fieldName + ": File with name '" + fileName + "' already exists", null, 4, null);
        }
        return Validator.Result.OK;
    }
}

