/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.gradle.runconfiguration;

import com.android.studio.ml.SmlBundle;
import com.android.studio.ml.bot.StudioBotFlags;
import com.android.studio.ml.journeys.gradle.runconfiguration.GeminiEnabledTestSuiteRunConfigurationExtension;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.login.GoogleLoginCredentialProvider;
import com.android.tools.idea.studiobot.StudioBot;
import com.android.tools.idea.studiobot.ads.GeminiAdvertiser;
import com.android.tools.idea.studiobot.ads.GeminiFeature;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "accessTokenWriter", "Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$AccessTokenWriter;", "<init>", "(Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$AccessTokenWriter;)V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGeminiAccessToken", "project", "Lcom/intellij/openapi/project/Project;", "AccessTokenWriter", "DefaultAccessTokenWriter", "aiplugin.android.journeys.gradle"})
@SourceDebugExtension(value={"SMAP\nGeminiEnabledTestSuiteTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiEnabledTestSuiteTaskManager.kt\ncom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n24#2:175\n24#2:176\n*S KotlinDebug\n*F\n+ 1 GeminiEnabledTestSuiteTaskManager.kt\ncom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager\n*L\n70#1:175\n88#1:176\n*E\n"})
public final class GeminiEnabledTestSuiteTaskManager
implements GradleTaskManagerExtension {
    @NotNull
    private final AccessTokenWriter accessTokenWriter;

    public GeminiEnabledTestSuiteTaskManager(@NotNull AccessTokenWriter accessTokenWriter) {
        Intrinsics.checkNotNullParameter((Object)accessTokenWriter, (String)"accessTokenWriter");
        this.accessTokenWriter = accessTokenWriter;
    }

    public /* synthetic */ GeminiEnabledTestSuiteTaskManager(AccessTokenWriter accessTokenWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            accessTokenWriter = new DefaultAccessTokenWriter();
        }
        this(accessTokenWriter);
    }

    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        File file;
        String string;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!((Boolean)StudioFlags.AGP_TEST_SUITES_ENABLED.get()).booleanValue() || !Intrinsics.areEqual((Object)settings.getUserData(GeminiEnabledTestSuiteRunConfigurationExtension.BooleanOptions.FORWARD_STUDIO_GEMINI_ACCESS_TOKEN.getUserDataKey()), (Object)true)) {
            return;
        }
        if (settings.getEnv().get("GEMINI_ACCESS_TOKEN_PATH") != null) {
            GeminiEnabledTestSuiteTaskManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GeminiEnabledTestSuiteTaskManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("The GEMINI_ACCESS_TOKEN_PATH environment variable is already set. Skipping adding it.");
            return;
        }
        Project project2 = id.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        if (ApplicationManagerEx.isInIntegrationTest()) {
            string = "fake_access_token";
        } else {
            string = this.getGeminiAccessToken(project3);
            if (string == null) {
                throw new ProcessCanceledException();
            }
        }
        String accessToken = string;
        try {
            file = this.accessTokenWriter.writeAccessTokenToTemporaryFile(accessToken);
        }
        catch (Exception e) {
            GeminiEnabledTestSuiteTaskManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GeminiEnabledTestSuiteTaskManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error preparing Gemini credentials for test suite task", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> GeminiEnabledTestSuiteTaskManager.configureTasks$lambda$0(project3));
            throw new ProcessCanceledException();
        }
        File accessTokenFile = file;
        settings.addEnvironmentVariable("GEMINI_ACCESS_TOKEN_PATH", accessTokenFile.getAbsolutePath());
    }

    private final String getGeminiAccessToken(Project project2) {
        if (StudioBot.Companion.getInstance().isAvailable()) {
            return GoogleLoginCredentialProvider.Companion.getGeminiAccessTokenAsJson();
        }
        if (!StudioBotFlags.Companion.getInstance().isAdvertiserEnabled()) {
            ApplicationManager.getApplication().invokeLater(() -> GeminiEnabledTestSuiteTaskManager.getGeminiAccessToken$lambda$0(project2));
        } else {
            GeminiAdvertiser.DialogInfo dialogInfo = new GeminiAdvertiser.DialogInfo(SmlBundle.INSTANCE.getMessage("sml.studiobot.advertiser.description.journeys", new Object[0]), null, null, 6, null);
            ApplicationManager.getApplication().invokeLater(() -> GeminiEnabledTestSuiteTaskManager.getGeminiAccessToken$lambda$1(project2, dialogInfo));
        }
        return null;
    }

    private static final void configureTasks$lambda$0(Project $project) {
        Messages.showErrorDialog((Project)$project, (String)"An error occurred while preparing Gemini credentials for test execution. Check idea.log for a detailed error message.", (String)"Error");
    }

    private static final void getGeminiAccessToken$lambda$0(Project $project) {
        ToolWindow toolWindow;
        String[] stringArray = new String[]{Messages.getCancelButton(), "Enable Gemini"};
        String[] options = stringArray;
        int result2 = Messages.showIdeaMessageDialog(null, (String)"To use Journeys with Gemini, you must enable Gemini in Android Studio by following the prompts in the Gemini tool window.", (String)"Enable Gemini", (String[])options, (int)1, (Icon)AllIcons.General.Warning, null);
        if (result2 == 1 && (toolWindow = ToolWindowManager.Companion.getInstance($project).getToolWindow("StudioBot")) != null) {
            toolWindow.show();
        }
    }

    private static final void getGeminiAccessToken$lambda$1(Project $project, GeminiAdvertiser.DialogInfo $dialogInfo) {
        GeminiAdvertiser.Companion.advertiseAndSignIn($project, GeminiFeature.JOURNEYS, $dialogInfo);
    }

    public GeminiEnabledTestSuiteTaskManager() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$AccessTokenWriter;", "", "writeAccessTokenToTemporaryFile", "Ljava/io/File;", "credential", "", "aiplugin.android.journeys.gradle"})
    public static interface AccessTokenWriter {
        @NotNull
        public File writeAccessTokenToTemporaryFile(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$DefaultAccessTokenWriter;", "Lcom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$AccessTokenWriter;", "<init>", "()V", "writeAccessTokenToTemporaryFile", "Ljava/io/File;", "credential", "", "aiplugin.android.journeys.gradle"})
    @SourceDebugExtension(value={"SMAP\nGeminiEnabledTestSuiteTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeminiEnabledTestSuiteTaskManager.kt\ncom/android/studio/ml/journeys/gradle/runconfiguration/GeminiEnabledTestSuiteTaskManager$DefaultAccessTokenWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
    public static final class DefaultAccessTokenWriter
    implements AccessTokenWriter {
        @Override
        @NotNull
        public File writeAccessTokenToTemporaryFile(@NotNull String credential) {
            File file;
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            Path tokenTempDir = Paths.get(PathManager.getTempPath(), new String[0]).resolve("GeminiEnabledTestSuiteTaskManager");
            if (!Files.exists(tokenTempDir, new LinkOption[0])) {
                Files.createDirectories(tokenTempDir, new FileAttribute[0]);
            }
            Path tempFilePath = Files.createTempFile(tokenTempDir, "access_token", ".json", new FileAttribute[0]);
            Files.writeString(tempFilePath, (CharSequence)credential, new OpenOption[0]);
            File $this$writeAccessTokenToTemporaryFile_u24lambda_u240 = file = tempFilePath.toFile();
            boolean bl = false;
            $this$writeAccessTokenToTemporaryFile_u24lambda_u240.deleteOnExit();
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"apply(...)");
            return file2;
        }
    }
}

