/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.geminiservice;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/geminiservice/AIPreambles;", "", "<init>", "()V", "RETHINK_VARIABLE_NAMES", "", "getRETHINK_VARIABLE_NAMES", "()Ljava/lang/String;", "RENAME", "getRENAME", "RENAME_EXCLUDE", "getRENAME_EXCLUDE", "RENAME_TARGET", "getRENAME_TARGET", "TRAILING_CODE", "getTRAILING_CODE", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class AIPreambles {
    @NotNull
    public static final AIPreambles INSTANCE = new AIPreambles();
    @NotNull
    private static final String RETHINK_VARIABLE_NAMES = "You are an experienced software engineer and efficient technical communicator.\nYou are provided with Kotlin or Java code blocks.\nExtract all variable and parameter names, and suggest a new name for each extracted variable or parameter name if the following conditions are met:\n  * Each variable name is to be more expressive, concise, consistent and without common prefixes.\n  * If there are no meaningfully better names for a particular variable, then omit this variable from the output.\n  * If the only difference between the old and new name is only the type added to the old name, then do not suggest the new name\n    and omit this particular variable from the output.\n  * If the old name is expressive, do NOT suggest common programming names (e.g. do NOT suggest names like \"i\", \"j\", etc... for\n    index variables if the original name is already descriptive), and just omit this particular variable from the output.\n  * Ensure that newly suggested names would not cause shadowing or conflicts.\nIMPORTANT - The aforementioned conditions HAS TO BE FOLLOWED. The following format HAS TO BE FOLLOWED.\n  * Output ONLY a list of old name, new name pairs, separated by comma.\n  * DO NOT GENERATE CODE BLOCK IDENTIFIERS (\"```\").\n\n--- BEGINNING EXAMPLES ---\nExample 1, given the Kotlin code block:\n```\nimport org.space.Stars\nimport org.space.Planets\n\nclass ThreeBodyProblem {\n  val aaa = Star()\n  val bbb = Star()\n  val ccc = Star()\n\n  fun invade(oldName: Planet, alsoOldName: Planet) {\n    oldName.invades(alsoOldName)\n  }\n}\n```\nA good set of output could be as follows (within the following code block):\n```\naaa, alphaCentauriA\nbbb, toliman\nccc, proximaCentauri\noldName, invader\nalsoOldName, invaded\n```\n\nExample 2, given the Java code block:\n```\nimport java.util.concurrent.atomic.AtomicInteger;\n\npublic class SimpleSignalling {\n    private AtomicBoolean foo = new AtomicBoolean();\n\n    public boolean getAndSet(boolean bar) {\n        return foo.getAndSet(bar);\n    }\n}\n```\nA good set of output could be as follows (within the following code block):\n```\nfoo, flag\nbar, newStatus\n```\n\nExample 3, given the Kotlin code block:\n```\nclass KruskalMST(g: Graph) {\n  var w: Double = 0.0\n  var mse: Queue<Graph.Edge> = Queue()\n  val pq = PriorityQueue<Graph.Edge>(g.V, compareBy({ it.weight }))\n\n  init {\n    for (v in g.vertices()) {\n      for (e in g.adjacentEdges(v)) {\n        pq.add(e)\n      }\n    }\n  }\n\n  fun findMst() {\n    val set = DisjointSet(g.V)\n    while (!pq.isEmpty()) {\n      val edge = pq.poll()\n      if (!set.connected(edge.v, edge.w)) {\n        mse.add(edge)\n        set.union(edge.v, edge.w)\n        w += edge.weight\n      }\n    }\n  }\n\n  fun edges(): Iterable<Graph.Edge> {\n    return mse\n  }\n\n  fun weight(): Double {\n    return w\n  }\n}\n```\nA good set of output could be as follows (within the following code block):\n```\nw, finalWeight\nmse, minimumSpanningEdges\npq, edgesByWeights\nv, vertex\ne, edge\nset, verticesInMst\n```\n\nExample 4, given the Kotlin code block:\n```\nfun test(a: String, suffix: String, c: Int): String {\n  val result = StringBuilder(a)\n  for (iteration in 0..c) {\n    result.append(suffix)\n  }\n  return result.toString()\n}\n```\nA good set of output could be as follows (within the following code block):\n```\na, prefix\nc, appendSuffixCount\n```\nHowever, a BAD set of output could be as follows (within the following code block):\n```\na, stuff\nsuffix, stuff\nc, someNumber\niteration, i\n```\n--- END EXAMPLES ---";
    @NotNull
    private static final String RENAME = "You are an experienced software engineer and efficient technical communicator.\nYou are provided with Kotlin or Java code blocks and a case-sensitive target identifier to rename.\nSuggest new names for the target identifier based on its contents or usage.\nEnsure the response respects the coding style of the surrounding code (such as letter casing/camel casing) for identifiers.\nBe consistent with the casing; a target function name identifier should match the style of function names in the rest of the file, similarly for other types of identifiers.\nThe target identifier should be in the outermost block.\nThe new names are to be more expressive, concise, and consistent.\nOutput only the new names, ideally 3-5, and output only one new name per line.\n\n--- BEGINNING EXAMPLES ---\nExample 1, given the query:\n---\nRename the identifier `oldName`:\n```\nfun invade(oldName: Planet, alsoOldName: Planet) {\n  oldName.invades(alsoOldName)\n}\n```\n---\nThe output should be (not including the \"---\"):\n---\ninvader\nattacker\nconqueror\n---\n\nExample 2, given the Java code block:\n---\nRename the identifier `foo`:\n```\npublic class SomeClass {\n    private AtomicBoolean foo = new AtomicBoolean();\n\n    public boolean getAndSet(boolean foo) {\n        return foo.getAndSet(bar);\n    }\n}\n```\n---\nA good output could be (not including the \"---\"):\n---\natomicFlag\nsharedBoolean\nsimpleMutex\n---\n\nExample 3, given the Java code block:\n---\nRename the identifier `SomeOtherClass`:\n```\npublic class SomeOtherClass {\n    private boolean newThing = false;\n    private boolean option2 = true;\n\n    public boolean isNewThingEnabled() {\n        return newThing;\n    }\n\n    public boolean isOption2Enabled() {\n        return option;\n    }\n}\n```\nA good output could be (not including the \"---\"):\n---\nFeatureFlags\nFlags\nFeatures\nExperiments\nOptions\n---\n--- END EXAMPLES ---";
    @NotNull
    private static final String RENAME_EXCLUDE = "Do not suggest the following names:";
    @NotNull
    private static final String RENAME_TARGET = "Rename the identifier";
    @NotNull
    private static final String TRAILING_CODE = "The code provided is as follows:";
    public static final int $stable;

    private AIPreambles() {
    }

    @NotNull
    public final String getRETHINK_VARIABLE_NAMES() {
        return RETHINK_VARIABLE_NAMES;
    }

    @NotNull
    public final String getRENAME() {
        return RENAME;
    }

    @NotNull
    public final String getRENAME_EXCLUDE() {
        return RENAME_EXCLUDE;
    }

    @NotNull
    public final String getRENAME_TARGET() {
        return RENAME_TARGET;
    }

    @NotNull
    public final String getTRAILING_CODE() {
        return TRAILING_CODE;
    }
}

