/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.studio.ml.device.DeviceSnapshot;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/device/DeviceHandleSnapshot;", "Lcom/android/studio/ml/device/DeviceSnapshot;", "deviceHandle", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "<init>", "(Lcom/android/sdklib/deviceprovisioner/DeviceHandle;)V", "getDeviceHandle", "()Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "adbSerialNumber", "", "getAdbSerialNumber", "()Ljava/lang/String;", "status", "getStatus", "properties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "getProperties", "()Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "identityHash", "getIdentityHash", "aiplugin.android"})
@StabilityInferred(parameters=0)
public final class DeviceHandleSnapshot
implements DeviceSnapshot {
    @NotNull
    private final DeviceHandle deviceHandle;
    public static final int $stable = 8;

    public DeviceHandleSnapshot(@NotNull DeviceHandle deviceHandle) {
        Intrinsics.checkNotNullParameter((Object)deviceHandle, (String)"deviceHandle");
        this.deviceHandle = deviceHandle;
    }

    @NotNull
    public final DeviceHandle getDeviceHandle() {
        return this.deviceHandle;
    }

    @Override
    @Nullable
    public String getAdbSerialNumber() {
        DeviceState deviceState = this.deviceHandle.getState();
        DeviceState.Connected connected = deviceState instanceof DeviceState.Connected ? (DeviceState.Connected)deviceState : null;
        return connected != null && (connected = connected.getConnectedDevice()) != null ? ConnectedDeviceKt.getSerialNumber((ConnectedDevice)connected) : null;
    }

    @Override
    @NotNull
    public String getStatus() {
        return this.deviceHandle.getState().getStatus();
    }

    @Override
    @NotNull
    public DeviceProperties getProperties() {
        return this.deviceHandle.getState().getProperties();
    }

    @Override
    @NotNull
    public String getIdentityHash() {
        String string = Integer.toString(System.identityHashCode(this.deviceHandle), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.take((String)string, (int)5);
    }
}

