/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.device;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceActionException;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.sdklib.deviceprovisioner.DeviceStateKt;
import com.android.sdklib.deviceprovisioner.TemplateActivationAction;
import com.android.studio.ml.device.ConnectDeviceArgs;
import com.android.studio.ml.device.ConnectDeviceTool;
import com.android.studio.ml.device.ConnectDeviceToolKt;
import com.android.studio.ml.device.DeviceHandleSnapshot;
import com.android.studio.ml.device.DeviceSnapshot;
import com.android.studio.ml.device.DeviceTemplateSnapshot;
import com.android.studio.ml.device.DevicesKt;
import com.android.studio.ml.icons.AndroidToolIcon;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.google.aiplugin.agents.tools.ToolResult;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Connects to a device", description="Attempts to make a device available for use, e.g. by starting an emulator or reserving a remote device", examples={})
@ToolResult(description="The ADB serial number of the connected device if successful.")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/device/ConnectDeviceTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/device/ConnectDeviceArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "icon", "Lcom/android/studio/ml/icons/AndroidToolIcon;", "getIcon", "()Lcom/android/studio/ml/icons/AndroidToolIcon;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class ConnectDeviceTool
implements Tool<ConnectDeviceArgs> {
    @NotNull
    public static final ConnectDeviceTool INSTANCE = new ConnectDeviceTool();
    @NotNull
    private static final String name = "connect_device";
    @NotNull
    private static final AndroidToolIcon icon = AndroidToolIcon.CONNECTION;
    public static final int $stable;

    private ConnectDeviceTool() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public AndroidToolIcon getIcon() {
        return icon;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Connecting to device: " + args.getName();
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Connected to device: " + args.getName();
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull ConnectDeviceArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ToolHandler(context2, args){
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ ConnectDeviceArgs $args;
            {
                this.$context = $context;
                this.$args = $args;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public Object handle(Continuation<? super Response> $completion) {
                block22: {
                    block23: {
                        if (!($completion instanceof createHandler.handle.1)) ** GOTO lbl-1000
                        var11_2 = $completion;
                        if ((var11_2.label & -2147483648) != 0) {
                            var11_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                Object L$0;
                                /* synthetic */ Object result;
                                final /* synthetic */ createHandler.1 this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.handle((Continuation<? super Response>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$service$iv = (ComponentManager)this.$context.getProject();
                                $i$f$service = false;
                                serviceClass$iv = DeviceProvisionerService.class;
                                v0 = $this$service$iv.getService(serviceClass$iv);
                                if (v0 == null) {
                                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                }
                                deviceProvisioner = ((DeviceProvisionerService)v0).getDeviceProvisioner();
                                snapshotsByName = (TreeMap)MapsKt.toMap((Iterable)DevicesKt.assignUniqueNames(DevicesKt.deviceSnapshots(deviceProvisioner)), (Map)new TreeMap<K, V>());
                                v1 = snapshotsByName.keySet();
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"<get-keys>(...)");
                                matches = ConnectDeviceToolKt.resolve(CollectionsKt.toList((Iterable)v1), this.$args.getName());
                                if (matches.isEmpty()) {
                                    return new Response(null, "Unknown device: " + this.$args.getName(), null, null, null, 29, null);
                                }
                                if (matches.size() > 1) {
                                    matchList = CollectionsKt.joinToString$default((Iterable)matches, null, (CharSequence)"- ", (CharSequence)"\n", (int)0, null, null, (int)57, null);
                                    return new Response("Multiple matching devices found:\n" + matchList + "\nRe-invoke the tool with one of these devices.", null, null, null, null, 30, null);
                                }
                                v2 = snapshotsByName.get(CollectionsKt.single(matches));
                                Intrinsics.checkNotNull(v2);
                                snapshot = (DeviceSnapshot)v2;
                                var6_10 = null;
                                var7_11 = snapshot;
                                if (!(var7_11 instanceof DeviceTemplateSnapshot)) break;
                                $continuation.label = 1;
                                v3 = TemplateActivationAction.activate$default((TemplateActivationAction)((DeviceTemplateSnapshot)snapshot).getDeviceTemplate().getActivationAction(), null, (Continuation)$continuation, (int)1, null);
                                if (v3 == var12_4) {
                                    return var12_4;
                                }
                                ** GOTO lbl42
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl42:
                                // 2 sources

                                var6_10 = (DeviceHandle)v3;
                                break block22;
                            }
                        }
                        if (!(var7_11 instanceof DeviceHandleSnapshot)) break block23;
                        handle = ((DeviceHandleSnapshot)snapshot).getDeviceHandle();
                        $continuation.L$0 = handle;
                        $continuation.label = 2;
                        v4 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)handle.getStateFlow()), (Function2)((Function2)new Function2<DeviceState, Continuation<? super Boolean>, Object>(null){
                            int label;
                            /* synthetic */ Object L$0;

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        DeviceState it = (DeviceState)this.L$0;
                                        return Boxing.boxBoolean((boolean)it.isTransitioning());
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(DeviceState p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation)$continuation);
                        if (v4 == var12_4) {
                            return var12_4;
                        }
                        ** GOTO lbl56
                        {
                            case 2: {
                                handle = (DeviceHandle)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl56:
                                // 2 sources

                                if (!(handle.getState() instanceof DeviceState.Connected)) {
                                    v5 = handle.getActivationAction();
                                    if (v5 == null) {
                                        return new Response(null, "Unable to activate device", null, null, null, 29, null);
                                    }
                                    activationAction = v5;
                                    $continuation.L$0 = handle;
                                    $continuation.label = 3;
                                    v6 = activationAction.activate((Continuation)$continuation);
                                    ** if (v6 != var12_4) goto lbl68
lbl67:
                                    // 1 sources

                                    return var12_4;
                                }
lbl68:
                                // 3 sources

                                break block22;
                            }
                            case 3: {
                                handle = (DeviceHandle)$continuation.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v6 = $result;
                                    break block22;
                                }
                                catch (DeviceActionException e) {
                                    return new Response(null, e.getMessage(), null, null, null, 29, null);
                                }
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                $continuation.L$0 = handle;
                $continuation.label = 4;
                v7 = DeviceStateKt.awaitReady((DeviceHandle)handle, (Continuation)$continuation);
                if (v7 == var12_4) {
                    return var12_4;
                }
                ** GOTO lbl91
                {
                    case 4: {
                        handle = (DeviceHandle)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl91:
                        // 2 sources

                        if ((v8 /* !! */  = handle.getState().getConnectedDevice()) == null || (v8 /* !! */  = ConnectedDeviceKt.getSerialNumber((ConnectedDevice)v8 /* !! */ )) == null) {
                            return new Response(null, "Device suddenly disconnected", null, null, null, 29, null);
                        }
                        serialNumber /* !! */  = v8 /* !! */ ;
                        return new Response("Connected to \"" + this.$args.getName() + "\" with serial number: " + (String)serialNumber /* !! */ , null, null, null, null, 30, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }
}

