/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.deploy;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.deploy.LiveEditArgs;
import com.android.studio.ml.deploy.LiveEditToolHandler;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Uses Live Edit to modify the existing running Android application with a given prompt", examples={"When filePath=\"main.kt\" prompt=\"change the background color to red\", the tool will\nmodify the running application's behavior so that the UI created by main.kt will have\na background color red."})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/studio/ml/deploy/LiveEditTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/deploy/LiveEditArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "getRunningDisplayText", "args", "getCompletedDisplayText", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class LiveEditTool
implements Tool<LiveEditArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public LiveEditTool() {
        this.name = "live_edit";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getRunningDisplayText(@NotNull LiveEditArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Running Live Edit";
    }

    @Override
    @NotNull
    public String getCompletedDisplayText(@NotNull LiveEditArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return "Ran Live Edit";
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull LiveEditArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new LiveEditToolHandler(context2, args);
    }
}

