/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.debugger.ExceptionAwareHandler;
import com.android.studio.ml.debugger.RemoveLineBreakpointArgs;
import com.android.studio.ml.debugger.UtilsKt;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@ToolDescription(summary="Removes a breakpoint at a specified file and line", instructions="\n      This tool is part of a group of tools allowing interaction with the debugger. The available\n      tools are:\n        add_line_breakpoint:  Add a breakpoint at a line for code.\n        debugger_pause: Pause a running session.\n        debugger_resume: Resume a paused session.\n        debugger_step Step through the code.\n        deploy:  Start the debugger by deploying in debug mode.\n        evaluate_expression: Evaluate an expression.\n        get_debugger_state:  Check if the debugger is running, paused or not-started.\n        get_frame_variables: Get the variables in a frame.\n        get_stack_frames: Get a list of stack frames of a thread in a paused session.\n        get_threads: Get a list of threads in a paused session.\n        remove_line_breakpoint:  Remove a breakpoint.\n    ", examples={"remove_line_breakpoint(fileName=\"/src/com/app/MainActivity.kt\", lineNumber=10)"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/studio/ml/debugger/RemoveLineBreakpointTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/debugger/RemoveLineBreakpointArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "removeBreakpoint", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "lineNumber", "", "aiplugin.android"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRemoveLineBreakpointTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveLineBreakpointTool.kt\ncom/android/studio/ml/debugger/RemoveLineBreakpointTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n808#2,11:84\n774#2:95\n865#2,2:96\n1869#2,2:98\n*S KotlinDebug\n*F\n+ 1 RemoveLineBreakpointTool.kt\ncom/android/studio/ml/debugger/RemoveLineBreakpointTool\n*L\n71#1:84,11\n71#1:95\n71#1:96,2\n75#1:98,2\n*E\n"})
public final class RemoveLineBreakpointTool
implements Tool<RemoveLineBreakpointArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public RemoveLineBreakpointTool() {
        this.name = "remove_line_breakpoint";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull RemoveLineBreakpointArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ExceptionAwareHandler(this, context2, args){
            final /* synthetic */ RemoveLineBreakpointTool this$0;
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ RemoveLineBreakpointArgs $args;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$args = $args;
            }

            public Object tryHandle(Continuation<? super String> $completion) {
                return RemoveLineBreakpointTool.access$removeBreakpoint(this.this$0, this.$context.getProject(), this.$args.getFileName(), this.$args.getLineNumber());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String removeBreakpoint(Project project2, String fileName, int lineNumber) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        VirtualFile virtualFile2 = UtilsKt.getVirtualFile(project2, fileName);
        if (virtualFile2 == null) {
            throw new IllegalStateException(("File '" + fileName + "' not found in project").toString());
        }
        VirtualFile virtualFile3 = virtualFile2;
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project2).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)breakpointManager, (String)"getBreakpointManager(...)");
        BreakpointManager breakpointManager2 = breakpointManager;
        List list = breakpointManager2.getBreakpoints();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBreakpoints(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LineBreakpoint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SourcePosition position;
            LineBreakpoint it = (LineBreakpoint)element$iv$iv;
            boolean bl = false;
            if (!(it.getSourcePosition() == null ? false : Intrinsics.areEqual((Object)position.getFile().getVirtualFile(), (Object)virtualFile3) && position.getLine() == lineNumber - 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List breakpoints = (List)destination$iv$iv;
        Iterable $this$forEach$iv = breakpoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineBreakpoint it = (LineBreakpoint)element$iv;
            boolean bl = false;
            breakpointManager2.removeBreakpoint((Breakpoint)it);
        }
        return switch (breakpoints.size()) {
            case 0 -> "There is no breakpoint at " + fileName + ":" + lineNumber;
            case 1 -> "Removed the breakpoint at " + fileName + ":" + lineNumber;
            default -> "Removed " + breakpoints.size() + " breakpoints at " + fileName + ":" + lineNumber;
        };
    }

    public static final /* synthetic */ String access$removeBreakpoint(RemoveLineBreakpointTool $this, Project project2, String fileName, int lineNumber) {
        return $this.removeBreakpoint(project2, fileName, lineNumber);
    }
}

