/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00020\u000b2\u000b\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/studio/ml/debugger/ExecutionStackCollector;", "Lcom/intellij/xdebugger/frame/XSuspendContext$XExecutionStackContainer;", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "<init>", "(Lkotlinx/coroutines/CancellableContinuation;)V", "stacks", "", "addExecutionStack", "", "executionStacks", "last", "", "errorOccurred", "errorMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "aiplugin.android"})
final class ExecutionStackCollector
implements XSuspendContext.XExecutionStackContainer {
    @NotNull
    private final CancellableContinuation<List<? extends XExecutionStack>> continuation;
    @NotNull
    private final List<XExecutionStack> stacks;

    public ExecutionStackCollector(@NotNull CancellableContinuation<? super List<? extends XExecutionStack>> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        this.continuation = continuation;
        this.stacks = new ArrayList();
    }

    public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
        Intrinsics.checkNotNullParameter(executionStacks, (String)"executionStacks");
        if (this.continuation.isActive()) {
            this.stacks.addAll((Collection<XExecutionStack>)executionStacks);
            if (last) {
                ((Continuation)this.continuation).resumeWith(Result.constructor-impl(this.stacks));
            }
        }
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (this.continuation.isActive()) {
            ((Continuation)this.continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new InternalError("Internal error collecting threads: " + errorMessage))));
        }
    }
}

