/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.debugger;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.debugger.AddLineBreakpointArgs;
import com.android.studio.ml.debugger.AddLineBreakpointTool;
import com.android.studio.ml.debugger.ExceptionAwareHandler;
import com.android.studio.ml.debugger.UtilsKt;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolDescription;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

@ToolDescription(summary="Adds a breakpoint at a specified file and line", instructions="\n      This tool is part of a group of tools allowing interaction with the debugger. The available\n      tools are:\n        add_line_breakpoint:  Add a breakpoint at a line for code.\n        debugger_pause: Pause a running session.\n        debugger_resume: Resume a paused session.\n        debugger_step Step through the code.\n        deploy:  Start the debugger by deploying in debug mode.\n        evaluate_expression: Evaluate an expression.\n        get_debugger_state:  Check if the debugger is running, paused or not-started.\n        get_frame_variables: Get the variables in a frame.\n        get_stack_frames: Get a list of stack frames of a thread in a paused session.\n        get_threads: Get a list of threads in a paused session.\n        remove_line_breakpoint:  Remove a breakpoint.\n    ", examples={"add_line_breakpoint(fileName=\"/src/com/app/MainActivity.kt\", lineNumber=10)"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J.\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0082@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/android/studio/ml/debugger/AddLineBreakpointTool;", "Lcom/google/aiplugin/agents/Tool;", "Lcom/android/studio/ml/debugger/AddLineBreakpointArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "createHandler", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "addBreakpoint", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "lineNumber", "", "condition", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.android"})
@StabilityInferred(parameters=1)
public final class AddLineBreakpointTool
implements Tool<AddLineBreakpointArgs> {
    @NotNull
    private final String name;
    public static final int $stable;

    public AddLineBreakpointTool() {
        this.name = "add_line_breakpoint";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ToolHandler createHandler(@NotNull ToolContext context2, @NotNull AddLineBreakpointArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new ExceptionAwareHandler(this, context2, args){
            final /* synthetic */ AddLineBreakpointTool this$0;
            final /* synthetic */ ToolContext $context;
            final /* synthetic */ AddLineBreakpointArgs $args;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$args = $args;
            }

            public Object tryHandle(Continuation<? super String> $completion) {
                return AddLineBreakpointTool.access$addBreakpoint(this.this$0, this.$context.getProject(), this.$args.getFileName(), this.$args.getLineNumber(), this.$args.getCondition(), $completion);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Object addBreakpoint(Project var1_1, String var2_2, int var3_3, String var4_4, Continuation<? super String> $completion) {
        if (!($completion instanceof addBreakpoint.1)) ** GOTO lbl-1000
        var13_6 = $completion;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AddLineBreakpointTool this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AddLineBreakpointTool.access$addBreakpoint(this.this$0, null, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = UtilsKt.getVirtualFile((Project)project, fileName);
                if (v0 == null) {
                    throw new IllegalStateException(("File '" + fileName + "' not found in project").toString());
                }
                virtualFile = v0;
                v1 = FileDocumentManager.getInstance().getDocument(virtualFile);
                if (v1 == null) {
                    throw new IllegalStateException(("Document not found for " + virtualFile).toString());
                }
                document = v1;
                var9_11 = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
                Intrinsics.checkNotNullExpressionValue((Object)var9_11, (String)"getBreakpointManager(...)");
                breakpointManager = var9_11;
                $continuation.L$0 = fileName;
                $continuation.L$1 = condition;
                $continuation.I$0 = lineNumber;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LineBreakpoint<?>>, Object>(breakpointManager, document, lineNumber, null){
                    int label;
                    final /* synthetic */ BreakpointManager $breakpointManager;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ int $lineNumber;
                    {
                        this.$breakpointManager = $breakpointManager;
                        this.$document = $document;
                        this.$lineNumber = $lineNumber;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return this.$breakpointManager.addLineBreakpoint(this.$document, this.$lineNumber - 1);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super LineBreakpoint<?>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var14_8) {
                    return var14_8;
                }
                ** GOTO lbl37
            }
            case 1: {
                lineNumber = $continuation.I$0;
                condition = (String)$continuation.L$1;
                fileName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                if ((breakpoint = (LineBreakpoint)v2) == null) {
                    throw new IllegalStateException("Failed to set breakpoint".toString());
                }
                if (((CharSequence)condition).length() > 0) {
                    v3 = Path.of(fileName, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"of(...)");
                    var11_13 = PathsKt.getExtension((Path)v3);
                    fileType = Intrinsics.areEqual((Object)var11_13, (Object)"java") != false ? (LanguageFileType)JavaFileType.INSTANCE : (Intrinsics.areEqual((Object)var11_13, (Object)"kt") != false ? (LanguageFileType)KotlinFileType.INSTANCE : null);
                    breakpoint.setCondition((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition, "", (FileType)fileType));
                }
                return "Added a breakpoint at " + fileName + ":" + lineNumber;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$addBreakpoint(AddLineBreakpointTool $this, Project project2, String fileName, int lineNumber, String condition, Continuation $completion) {
        return $this.addBreakpoint(project2, fileName, lineNumber, condition, (Continuation<? super String>)$completion);
    }
}

