/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer.AgentDrawerSuggestionControl;
import com.android.studio.ml.bot.ui.compose.timeline.agent.experimental.changesdrawer.InsertedLineHighlighterRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000e*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/InsertedLineHighlighter;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/RangeMarker;)V", "currentHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isDisposed", "", "createHighlighter", "line", "", "dispose", "", "getLinesToHighlight", "Lkotlin/ranges/IntRange;", "updateHighlightedLines", "getSingleSpannedLine", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Ljava/lang/Integer;", "aiplugin.core.aicore"})
@VisibleForTesting
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentDrawerSuggestionControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentDrawerSuggestionControl.kt\ncom/android/studio/ml/bot/ui/compose/timeline/agent/experimental/changesdrawer/InsertedLineHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,702:1\n1#2:703\n*E\n"})
public final class InsertedLineHighlighter
implements Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final RangeMarker range;
    @NotNull
    private Set<? extends RangeHighlighter> currentHighlighters;
    private boolean isDisposed;
    public static final int $stable = 8;

    public InsertedLineHighlighter(@NotNull Editor editor2, @NotNull RangeMarker range) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.editor = editor2;
        this.range = range;
        this.currentHighlighters = SetsKt.emptySet();
        this.updateHighlightedLines();
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ApplicationKt.getApplication().invokeLater(() -> 1.documentChanged$lambda$0(this));
            }

            private static final void documentChanged$lambda$0(InsertedLineHighlighter this$0) {
                this$0.updateHighlightedLines();
            }
        }, (Disposable)this);
    }

    private final void updateHighlightedLines() {
        if (this.isDisposed) {
            return;
        }
        Set linesToHighlight = CollectionsKt.toMutableSet((Iterable)((Iterable)this.getLinesToHighlight()));
        List newHighlighters = new ArrayList();
        for (RangeHighlighter rangeHighlighter : this.currentHighlighters) {
            Integer currentLine = this.getSingleSpannedLine(rangeHighlighter);
            if (currentLine == null || !linesToHighlight.contains(currentLine)) {
                this.editor.getMarkupModel().removeHighlighter(rangeHighlighter);
                continue;
            }
            newHighlighters.add(rangeHighlighter);
            linesToHighlight.remove(currentLine);
        }
        Iterator<Object> iterator = linesToHighlight.iterator();
        while (iterator.hasNext()) {
            int n = ((Number)iterator.next()).intValue();
            newHighlighters.add(this.createHighlighter(n));
        }
        this.currentHighlighters = CollectionsKt.toSet((Iterable)newHighlighters);
    }

    private final Integer getSingleSpannedLine(RangeHighlighter $this$getSingleSpannedLine) {
        int endLine;
        if (!$this$getSingleSpannedLine.isValid()) {
            return null;
        }
        int startLine = $this$getSingleSpannedLine.getDocument().getLineNumber($this$getSingleSpannedLine.getStartOffset());
        if (startLine != (endLine = $this$getSingleSpannedLine.getDocument().getLineNumber($this$getSingleSpannedLine.getEndOffset()))) {
            return null;
        }
        if ($this$getSingleSpannedLine.getDocument().getLineStartOffset(startLine) != $this$getSingleSpannedLine.getStartOffset() || $this$getSingleSpannedLine.getDocument().getLineEndOffset(startLine) != $this$getSingleSpannedLine.getEndOffset()) {
            return null;
        }
        return startLine;
    }

    private final IntRange getLinesToHighlight() {
        if (this.range.getTextRange().isEmpty()) {
            return IntRange.Companion.getEMPTY();
        }
        Document document2 = this.range.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int startLineInclusive = document3.getLineNumber(this.range.getStartOffset());
        int endLineExclusive = this.range.getEndOffset() == document3.getTextLength() ? document3.getLineCount() : document3.getLineNumber(this.range.getEndOffset());
        return RangesKt.until((int)startLineInclusive, (int)endLineExclusive);
    }

    private final RangeHighlighter createHighlighter(int line) {
        RangeHighlighter rangeHighlighter;
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int lineStart = document3.getLineStartOffset(line);
        int lineEnd = document3.getLineEndOffset(line);
        RangeHighlighter rangeHighlighter2 = this.editor.getMarkupModel().addRangeHighlighter(AgentDrawerSuggestionControl.Companion.getNewTextAttributesKey$aiplugin_core_aicore(), lineStart, lineEnd, 5000, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter $this$createHighlighter_u24lambda_u240 = rangeHighlighter = rangeHighlighter2;
        boolean bl = false;
        TextAttributesKey textAttributesKey = AgentDrawerSuggestionControl.Companion.getNewTextAttributesKey$aiplugin_core_aicore();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"<get-newTextAttributesKey>(...)");
        $this$createHighlighter_u24lambda_u240.setCustomRenderer((CustomHighlighterRenderer)new InsertedLineHighlighterRenderer(textAttributesKey));
        return rangeHighlighter;
    }

    public void dispose() {
        this.isDisposed = true;
        for (RangeHighlighter rangeHighlighter : this.currentHighlighters) {
            this.editor.getMarkupModel().removeHighlighter(rangeHighlighter);
        }
    }
}

