/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.draganddrop.DragAndDropEvent;
import androidx.compose.ui.draganddrop.DragAndDropTarget;
import androidx.compose.ui.draganddrop.DragAndDrop_desktopKt;
import androidx.compose.ui.text.AnnotatedString;
import com.android.studio.ml.bot.ui.compose.components.ProjectProvider;
import com.android.studio.ml.bot.ui.compose.timeline.QueryBoxDropAndPasteHelperKt;
import com.android.studio.ml.bot.ui.compose.timeline.messages.MessageClipboardKt;
import com.android.studio.ml.bot.ui.compose.timeline.querybox.QueryBoxController;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/QueryBoxDragAndDropTarget;", "Landroidx/compose/ui/draganddrop/DragAndDropTarget;", "queryBoxController", "Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxController;", "projectProvider", "Lcom/android/studio/ml/bot/ui/compose/components/ProjectProvider;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/android/studio/ml/bot/ui/compose/timeline/querybox/QueryBoxController;Lcom/android/studio/ml/bot/ui/compose/components/ProjectProvider;Lkotlinx/coroutines/CoroutineScope;)V", "handleDrop", "", "transferable", "Ljava/awt/datatransfer/Transferable;", "handleDrop$aiplugin_core_aicore", "onDrop", "event", "Landroidx/compose/ui/draganddrop/DragAndDropEvent;", "onEnded", "", "onEntered", "onExited", "aiplugin.core.aicore"})
@VisibleForTesting
@StabilityInferred(parameters=0)
public final class QueryBoxDragAndDropTarget
implements DragAndDropTarget {
    @NotNull
    private final QueryBoxController queryBoxController;
    @NotNull
    private final ProjectProvider projectProvider;
    @NotNull
    private final CoroutineScope coroutineScope;
    public static final int $stable = 8;

    public QueryBoxDragAndDropTarget(@NotNull QueryBoxController queryBoxController, @NotNull ProjectProvider projectProvider, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)queryBoxController, (String)"queryBoxController");
        Intrinsics.checkNotNullParameter((Object)projectProvider, (String)"projectProvider");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.queryBoxController = queryBoxController;
        this.projectProvider = projectProvider;
        this.coroutineScope = coroutineScope;
    }

    public boolean onDrop(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Transferable transferable = DragAndDrop_desktopKt.getAwtTransferable((DragAndDropEvent)event);
        return this.handleDrop$aiplugin_core_aicore(transferable);
    }

    @VisibleForTesting
    public final boolean handleDrop$aiplugin_core_aicore(@NotNull Transferable transferable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        this.queryBoxController.getQueryBoxState().setShowDragAndDropUi(false);
        boolean attachmentAdded = QueryBoxDropAndPasteHelperKt.addAttachments(this.queryBoxController.getQueryBoxState(), transferable, this.projectProvider, this.coroutineScope);
        if (attachmentAdded) {
            return true;
        }
        if (transferable.isDataFlavorSupported(MessageClipboardKt.getAnnotatedStringFlavor())) {
            AnnotatedString annotatedString;
            object = transferable.getTransferData(MessageClipboardKt.getAnnotatedStringFlavor());
            AnnotatedString annotatedString2 = annotatedString = object instanceof AnnotatedString ? (AnnotatedString)object : null;
            if (annotatedString != null) {
                QueryBoxController.insertQuery$default(this.queryBoxController, annotatedString.getText(), 0, 2, null);
                return true;
            }
        }
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String text2;
            object = transferable.getTransferData(DataFlavor.stringFlavor);
            String string = text2 = object instanceof String ? (String)object : null;
            if (text2 != null) {
                QueryBoxController.insertQuery$default(this.queryBoxController, text2, 0, 2, null);
                return true;
            }
        }
        return false;
    }

    public void onEntered(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queryBoxController.getQueryBoxState().setShowDragAndDropUi(true);
    }

    public void onExited(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queryBoxController.getQueryBoxState().setShowDragAndDropUi(false);
    }

    public void onEnded(@NotNull DragAndDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queryBoxController.getQueryBoxState().setShowDragAndDropUi(false);
    }
}

