/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.timeline;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.bot.ui.compose.timeline.LinkifyMarkdownKt;
import com.android.studio.ml.bot.ui.compose.timeline.PathInString;
import com.android.studio.ml.bot.ui.compose.timeline.PathStore;
import com.android.studio.ml.bot.ui.compose.timeline.messages.ComposeChunk;
import com.google.aiplugin.agents.Tool;
import com.google.aiplugin.agents.tools.read.ReadFileTool;
import com.google.aiplugin.agents.tools.read.ReadUrlTool;
import com.google.aiplugin.agents.tools.write.ReplaceTextTool;
import com.google.aiplugin.agents.tools.write.WriteFileTool;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0006\u0010\u0012\u001a\u00020\u000eJ \u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J \u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0011J\u0012\u0010\u001d\u001a\u00020\u000e*\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/studio/ml/bot/ui/compose/timeline/PathTracker;", "", "maxPaths", "", "(I)V", "currentTool", "Lcom/google/aiplugin/agents/Tool;", "pathStore", "Lcom/android/studio/ml/bot/ui/compose/timeline/PathStore;", "addPathsFromText", "", "response", "", "trackBracketBalance", "", "getTrackedFiles", "", "Ljava/io/File;", "isNotEmpty", "matchFilename", "string", "start", "end", "matchRelativePath", "recognizePaths", "chunk", "Lcom/android/studio/ml/bot/ui/compose/timeline/messages/ComposeChunk;", "trackPath", "file", "responseContainsPaths", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinkifyMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkifyMarkdown.kt\ncom/android/studio/ml/bot/ui/compose/timeline/PathTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1#2:421\n*E\n"})
public final class PathTracker {
    @NotNull
    private final PathStore pathStore;
    @Nullable
    private Tool<?> currentTool;
    public static final int $stable = 8;

    public PathTracker(int maxPaths) {
        this.pathStore = new PathStore(maxPaths);
    }

    public /* synthetic */ PathTracker(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        this(n);
    }

    private final boolean responseContainsPaths(Tool<?> $this$responseContainsPaths) {
        return $this$responseContainsPaths != null && !($this$responseContainsPaths instanceof ReadFileTool) && !($this$responseContainsPaths instanceof ReadUrlTool);
    }

    @NotNull
    public final List<File> getTrackedFiles() {
        return this.pathStore.getTrackedFiles();
    }

    public final void recognizePaths(@NotNull ComposeChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk instanceof ComposeChunk.ToolCall) {
            Tool tool = ((ComposeChunk.ToolCall)chunk).getTool();
            this.currentTool = tool;
            if (tool instanceof WriteFileTool || tool instanceof ReplaceTextTool || tool instanceof ReadFileTool) {
                Object object = ((ComposeChunk.ToolCall)chunk).getArgs().get("absolutePath");
                if (object != null && (object = object.toString()) != null) {
                    Object it = object;
                    boolean bl = false;
                    this.trackPath(new File((String)it));
                }
                return;
            }
            if (!this.responseContainsPaths(tool)) {
                return;
            }
            for (Object value : ((ComposeChunk.ToolCall)chunk).getArgs().values()) {
                if (!(value instanceof String)) continue;
                this.addPathsFromText((String)value, false);
            }
            String string = ((ComposeChunk.ToolCall)chunk).getResponse();
            if (string == null) {
                return;
            }
            String response2 = string;
            this.addPathsFromText(response2, false);
        } else if (chunk instanceof ComposeChunk.ToolCallResponse) {
            if (this.responseContainsPaths(this.currentTool)) {
                String response3 = ((ComposeChunk.ToolCallResponse)chunk).getResponse();
                this.addPathsFromText(response3, false);
            }
        } else {
            this.currentTool = null;
            if (chunk instanceof ComposeChunk.Markdown) {
                this.addPathsFromText(((ComposeChunk.Markdown)chunk).getRawMarkdown(), true);
            } else if (chunk instanceof ComposeChunk.Code) {
                this.addPathsFromText(((ComposeChunk.Code)chunk).getCode().getText(), true);
            }
        }
    }

    public final void addPathsFromText(@NotNull String response2, boolean trackBracketBalance) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        PathInString pathInString = LinkifyMarkdownKt.findNextPath$default(response2, 0, true, trackBracketBalance, null, 16, null);
        if (pathInString == null) {
            return;
        }
        PathInString curr = pathInString;
        while (true) {
            PathInString pathInString2 = curr;
            int end = pathInString2.component2();
            File file = pathInString2.component3();
            this.trackPath(file);
            if (LinkifyMarkdownKt.findNextPath$default(response2, end, true, trackBracketBalance, null, 16, null) == null) break;
        }
    }

    public final void trackPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.pathStore.add(file);
    }

    public final boolean isNotEmpty() {
        return this.pathStore.isNotEmpty();
    }

    @Nullable
    public final File matchFilename(@NotNull String string, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.pathStore.matchFilename(string, start2, end);
    }

    @Nullable
    public final File matchRelativePath(@NotNull String string, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return PathStore.matchRelativePath$default(this.pathStore, string, start2, end, false, 8, null);
    }

    public PathTracker() {
        this(0, 1, null);
    }
}

