/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.ui.compose.shaders;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.android.studio.ml.bot.ui.compose.shaders.RotatingSweepShaderBrush;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.RuntimeEffect;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"ROTATING_SWEEP_GRADIENT_EFFECT", "Lorg/jetbrains/skia/RuntimeEffect;", "ROTATING_SWEEP_GRADIENT_SKSL", "", "darkThinkingColors", "", "Landroidx/compose/ui/graphics/Color;", "lightThinkingColors", "thinkingColors", "darkTheme", "", "thinkGradientSweep", "Landroidx/compose/ui/graphics/Brush;", "Landroidx/compose/ui/graphics/Brush$Companion;", "rotationAmount", "", "aiplugin.core.aicore"})
public final class ThinkingSweepGradientKt {
    @Language(value="GLSL")
    @NotNull
    private static final String ROTATING_SWEEP_GRADIENT_SKSL = "uniform vec2 iResolution;           // Width and height of the composable\nuniform float iTime;                // Rotation offset (0.0 to 2.0 * PI)\nlayout(color) uniform vec3 iColor1; // First color (e.g., Red)\nlayout(color) uniform vec3 iColor2; // Second color (e.g., Green)\nlayout(color) uniform vec3 iColor3; // Third color (e.g., Blue)\n\nconst float PI = 3.141592653589793;\nconst float TWO_PI = 2.0 * PI;\n\nvec4 main(vec2 fragCoord) {\n    // Calculate coordinates relative to the center of the composable.\n    // Normalize by the smaller dimension to keep the gradient circular.\n    vec2 centeredCoord = fragCoord - 0.5 * iResolution;\n    float minDimension = min(iResolution.x, iResolution.y);\n    vec2 uv = centeredCoord / minDimension;\n\n    // Calculate the angle of the current pixel relative to the center.\n    // atan(y, x) returns an angle in the range [-PI, PI].\n    float angle = atan(uv.y, uv.x);\n\n    // Apply the rotation offset.\n    // Subtracting iTime makes the gradient rotate clockwise as iTime increases.\n    angle -= iTime;\n\n    // Normalize the angle to a 0.0 to 1.0 range.\n    // (angle + PI) / TWO_PI maps the angle (which might be outside [-PI, PI] after iTime shift)\n    // to a range that might be outside [0,1].\n    // Using fract() ensures t wraps smoothly within [0,1).\n    float t = fract((angle + PI) / TWO_PI);\n\n    vec3 finalColor;\n    float segmentBoundary1 = .33333;\n    float segmentBoundary2 = .66667;\n\n    if (t < segmentBoundary1) {\n        // Interpolate between color1 and color2\n        float local_t = t / segmentBoundary1;\n        finalColor = mix(iColor1, iColor2, local_t);\n    } else if (t < segmentBoundary2) {\n        // Interpolate between color2 and color3\n        float local_t = (t - segmentBoundary1) / segmentBoundary1; // segmentBoundary1 is also the length of the segment\n        finalColor = mix(iColor2, iColor3, local_t);\n    } else {\n        // Interpolate between color3 and color1\n        float local_t = (t - segmentBoundary2) / segmentBoundary1;\n        finalColor = mix(iColor3, iColor1, local_t);\n    }\n\n    return vec4(finalColor, 1.0);\n}";
    @NotNull
    private static final RuntimeEffect ROTATING_SWEEP_GRADIENT_EFFECT = RuntimeEffect.Companion.makeForShader(ROTATING_SWEEP_GRADIENT_SKSL);
    @NotNull
    private static final List<Color> darkThinkingColors;
    @NotNull
    private static final List<Color> lightThinkingColors;

    @NotNull
    public static final Brush thinkGradientSweep(@NotNull Brush.Companion $this$thinkGradientSweep, boolean darkTheme, float rotationAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$thinkGradientSweep, (String)"<this>");
        return (Brush)new RotatingSweepShaderBrush(ThinkingSweepGradientKt.thinkingColors(darkTheme), rotationAmount);
    }

    public static /* synthetic */ Brush thinkGradientSweep$default(Brush.Companion companion, boolean bl, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        return ThinkingSweepGradientKt.thinkGradientSweep(companion, bl, f);
    }

    @NotNull
    public static final List<Color> thinkingColors(boolean darkTheme) {
        return darkTheme ? darkThinkingColors : lightThinkingColors;
    }

    public static final /* synthetic */ RuntimeEffect access$getROTATING_SWEEP_GRADIENT_EFFECT$p() {
        return ROTATING_SWEEP_GRADIENT_EFFECT;
    }

    static {
        Object[] objectArray = new Color[]{Color.box-impl((long)ColorKt.Color((int)-13148243)), Color.box-impl((long)ColorKt.Color((int)-9681252)), Color.box-impl((long)ColorKt.Color((int)-13282417))};
        darkThinkingColors = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Color[]{Color.box-impl((long)ColorKt.Color((int)-7819785)), Color.box-impl((long)ColorKt.Color((int)-6195212)), Color.box-impl((long)ColorKt.Color((int)-9397003))};
        lightThinkingColors = CollectionsKt.listOf((Object[])objectArray);
    }
}

