/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.permissions;

import com.android.studio.ml.bot.permissions.PermissionNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0001H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0006\u0010 \u001a\u00020\rJ\b\u0010!\u001a\u00020\u0019H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/studio/ml/bot/permissions/PermissionTreeNode;", "Ljavax/swing/tree/TreeNode;", "parent", "node", "Lcom/android/studio/ml/bot/permissions/PermissionNode;", "(Ljavax/swing/tree/TreeNode;Lcom/android/studio/ml/bot/permissions/PermissionNode;)V", "children", "", "getChildren", "()Ljava/util/List;", "getNode", "()Lcom/android/studio/ml/bot/permissions/PermissionNode;", "apply", "", "Ljava/util/Enumeration;", "findFirstPermissionPath", "Ljavax/swing/tree/TreePath;", "findTreeNode", "getAllowsChildren", "", "getChildAt", "index", "", "getChildCount", "getDisplayName", "", "getIcon", "Ljavax/swing/Icon;", "getIndex", "getParent", "hasChanged", "isLeaf", "reset", "toString", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nPermissionSettingsUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionSettingsUi.kt\ncom/android/studio/ml/bot/permissions/PermissionTreeNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,920:1\n1563#2:921\n1634#2,3:922\n37#3:925\n36#3,3:926\n*S KotlinDebug\n*F\n+ 1 PermissionSettingsUi.kt\ncom/android/studio/ml/bot/permissions/PermissionTreeNode\n*L\n772#1:921\n772#1:922,3\n838#1:925\n838#1:926,3\n*E\n"})
final class PermissionTreeNode
implements TreeNode {
    @Nullable
    private final TreeNode parent;
    @NotNull
    private final PermissionNode node;
    @NotNull
    private final List<PermissionTreeNode> children;

    /*
     * WARNING - void declaration
     */
    public PermissionTreeNode(@Nullable TreeNode parent, @NotNull PermissionNode node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.parent = parent;
        this.node = node;
        Iterable iterable = this.node.getChildren();
        PermissionTreeNode permissionTreeNode = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionNode permissionNode = (PermissionNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PermissionTreeNode(this, (PermissionNode)it));
        }
        permissionTreeNode.children = (List)destination$iv$iv;
    }

    @NotNull
    public final PermissionNode getNode() {
        return this.node;
    }

    @Nullable
    public final Icon getIcon() {
        return this.node.getIcon();
    }

    @NotNull
    public final String getDisplayName() {
        return this.node.getDisplayName();
    }

    @NotNull
    public final List<PermissionTreeNode> getChildren() {
        return this.children;
    }

    @Override
    @NotNull
    public TreeNode getChildAt(int index) {
        return this.children.get(index);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    @Nullable
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(@NotNull TreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return CollectionsKt.indexOf(this.children, (Object)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return !((Collection)this.children).isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    @NotNull
    public Enumeration<? extends TreeNode> children() {
        Enumeration enumeration = Collections.enumeration((Collection)this.children);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
        return enumeration;
    }

    @NotNull
    public String toString() {
        return this.node.getDisplayName();
    }

    @Nullable
    public final PermissionTreeNode findTreeNode(@NotNull PermissionNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)this.node, (Object)node)) {
            return this;
        }
        for (PermissionTreeNode child : this.children) {
            PermissionTreeNode treeNode = child.findTreeNode(node);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    public final boolean hasChanged() {
        if (this.node.hasChanged()) {
            return true;
        }
        for (PermissionTreeNode child : this.children) {
            if (!child.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public final void reset() {
        this.node.reset();
        for (PermissionTreeNode child : this.children) {
            child.reset();
        }
    }

    public final void apply() {
        if (this.node.hasChanged()) {
            this.node.apply();
        }
        for (PermissionTreeNode child : this.children) {
            child.apply();
        }
    }

    @Nullable
    public final TreePath findFirstPermissionPath() {
        if (this.node.getPermission() != null) {
            return new TreePath(this);
        }
        for (PermissionTreeNode child : this.children) {
            TreePath treePath = child.findFirstPermissionPath();
            if (treePath == null) continue;
            TreePath path2 = treePath;
            Collection collection = CollectionsKt.listOf((Object)this);
            Object[] objectArray = path2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
            Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)collection, (Iterable)ArraysKt.toList((Object[])objectArray));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new TreePath(thisCollection$iv.toArray(new Object[0]));
        }
        return null;
    }
}

