/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.parse;

import com.android.studio.ml.SmlConversation;
import com.android.studio.ml.bot.parse.CodeFragment;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.mimetype.MimeTypeUtilsKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a5\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0002\u0010\b\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0003\u00a8\u0006\u0011"}, d2={"guessToolResponseMimeType", "Lcom/android/tools/idea/studiobot/MimeType;", "response", "", "name", "args", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "prettyPrintJsonFast", "json", "isTest", "", "Lcom/android/studio/ml/SmlConversation$CodeChunk;", "isValidJavaIdentifier", "lengthWithoutWhitespace", "", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/android/studio/ml/bot/parse/UtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1104#2,3:166\n1069#2,2:172\n1761#3,3:169\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/android/studio/ml/bot/parse/UtilsKt\n*L\n25#1:166,3\n42#1:172,2\n29#1:169,3\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final int lengthWithoutWhitespace(@NotNull String $this$lengthWithoutWhitespace) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$lengthWithoutWhitespace, (String)"<this>");
        CharSequence $this$count$iv = $this$lengthWithoutWhitespace;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(!CharsKt.isWhitespace((char)it))) continue;
            ++count$iv;
        }
        return (int)var3_3;
    }

    public static final boolean isTest(@NotNull SmlConversation.CodeChunk $this$isTest) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isTest, (String)"<this>");
            Iterable $this$any$iv = $this$isTest.getFragments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CodeFragment it = (CodeFragment)element$iv;
                    boolean bl2 = false;
                    String $this$isTest_u24lambda_u240_u240 = it.getText();
                    boolean bl3 = false;
                    boolean bl4 = StringsKt.contains$default((CharSequence)$this$isTest_u24lambda_u240_u240, (CharSequence)"@Test", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isTest_u24lambda_u240_u240, (CharSequence)"@RunWith", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isTest_u24lambda_u240_u240, (CharSequence)"assertEquals", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isTest_u24lambda_u240_u240, (CharSequence)"assertTrue", (boolean)false, (int)2, null);
                    if (!bl4) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isValidJavaIdentifier(@NotNull String $this$isValidJavaIdentifier) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isValidJavaIdentifier, (String)"<this>");
            if (((CharSequence)$this$isValidJavaIdentifier).length() == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(StringsKt.first((CharSequence)$this$isValidJavaIdentifier))) {
                return false;
            }
            CharSequence $this$all$iv = StringsKt.drop((String)$this$isValidJavaIdentifier, (int)1);
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (Character.isJavaIdentifierPart(it)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final String prettyPrintJsonFast(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (json.length() <= 2) {
            return json;
        }
        StringBuilder sb = new StringBuilder(json.length() * 2);
        Ref.IntRef indent = new Ref.IntRef();
        boolean inString = false;
        int n = json.length();
        block8: for (int j = 0; j < n; ++j) {
            char c = json.charAt(j);
            switch (c) {
                case '[': 
                case '{': {
                    sb.append(c);
                    if (inString) continue block8;
                    indent.element += 2;
                    UtilsKt.prettyPrintJsonFast$newline(sb, indent);
                    continue block8;
                }
                case ']': 
                case '}': {
                    if (!inString) {
                        indent.element -= 2;
                        UtilsKt.prettyPrintJsonFast$newline(sb, indent);
                    }
                    sb.append(c);
                    continue block8;
                }
                case ',': {
                    sb.append(c);
                    if (inString) continue block8;
                    UtilsKt.prettyPrintJsonFast$newline(sb, indent);
                    continue block8;
                }
                case ':': {
                    sb.append(c);
                    if (inString) continue block8;
                    sb.append(' ');
                    continue block8;
                }
                case '\"': {
                    sb.append(c);
                    int backslashes = 0;
                    for (int i2 = sb.length() - 2; i2 >= 0 && sb.charAt(i2) == '\\'; --i2) {
                        ++backslashes;
                    }
                    if (backslashes % 2 != 0) continue block8;
                    inString = !inString;
                    continue block8;
                }
                case '\n': 
                case ' ': {
                    if (!inString) {
                        return json;
                    }
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public static final String guessToolResponseMimeType(@Nullable String response2, @NotNull String name, @NotNull Map<String, ? extends Object> args) {
        boolean looksLikeJsonArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        CharSequence charSequence = response2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        switch (name) {
            case "write_file": 
            case "read_file": {
                Object ext;
                String mime;
                Object object = args.get("absolutePath");
                if (object == null || (object = object.toString()) == null || (object = StringsKt.substringAfterLast$default((String)object, (String)".", null, (int)2, null)) == null) {
                    object = "";
                }
                if ((mime = MimeTypeUtilsKt.fromExtension(MimeType.Companion, (String)(ext = object))) == null) break;
                return mime;
            }
            case "get_code": {
                String clientLanguage;
                String mime;
                Object object = args.get("clientLanguages");
                String string = clientLanguage = object != null ? object.toString() : null;
                if (clientLanguage == null) break;
                String string2 = MimeTypeUtilsKt.fromMarkdownLanguageName(MimeType.Companion, clientLanguage);
                if (string2 == null) {
                    string2 = MimeTypeUtilsKt.fromExtension(MimeType.Companion, clientLanguage);
                }
                if ((mime = string2) == null) break;
                return mime;
            }
        }
        String response3 = ((Object)StringsKt.trim((CharSequence)response2)).toString();
        boolean looksLikeJsonObject = StringsKt.startsWith$default((String)response3, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)response3, (String)"}", (boolean)false, (int)2, null);
        boolean bl = looksLikeJsonArray = StringsKt.startsWith$default((String)response3, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)response3, (String)"]", (boolean)false, (int)2, null);
        return looksLikeJsonObject || looksLikeJsonArray ? MimeType.Companion.getJSON-i_3W7CY() : (StringsKt.startsWith$default((String)response3, (String)"<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)response3, (String)">", (boolean)false, (int)2, null) ? MimeType.Companion.getXML-i_3W7CY() : null);
    }

    private static final void prettyPrintJsonFast$newline(StringBuilder sb, Ref.IntRef indent) {
        sb.append('\n');
        int n = indent.element;
        for (int i2 = 0; i2 < n; ++i2) {
            sb.append(' ');
        }
    }
}

