/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.history;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.time.TimeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eBO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001e\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\r\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\tR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/studio/ml/bot/history/HistoryPersister;", "T", "", "store", "Ljava/nio/file/Path;", "loggerTag", "", "serialize", "Lkotlin/Function2;", "", "Ljava/io/BufferedOutputStream;", "", "deserialize", "Lkotlin/Function1;", "Ljava/io/BufferedInputStream;", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "launchPersister", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "persist", "entries", "readPersistedState", "Companion", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHistoryPersister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryPersister.kt\ncom/android/studio/ml/bot/history/HistoryPersister\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class HistoryPersister<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path store;
    @NotNull
    private final Function2<List<? extends T>, BufferedOutputStream, Unit> serialize;
    @NotNull
    private final Function1<BufferedInputStream, List<T>> deserialize;
    @NotNull
    private final Logger logger;
    public static final int $stable = 8;
    @NotNull
    private static final Duration debounceTimeout;

    public HistoryPersister(@NotNull Path store, @NotNull String loggerTag, @NotNull Function2<? super List<? extends T>, ? super BufferedOutputStream, Unit> serialize, @NotNull Function1<? super BufferedInputStream, ? extends List<? extends T>> deserialize2) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)loggerTag, (String)"loggerTag");
        Intrinsics.checkNotNullParameter(serialize, (String)"serialize");
        Intrinsics.checkNotNullParameter(deserialize2, (String)"deserialize");
        this.store = store;
        this.serialize = serialize;
        this.deserialize = deserialize2;
        Logger logger = Logger.getInstance((String)loggerTag);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Job launchPersister(@NotNull CoroutineScope scope2, @NotNull StateFlow<? extends List<? extends T>> state2, @NotNull CoroutineDispatcher dispatcher2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        return FlowKt.launchIn((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)TimeKt.debounce((Flow)((Flow)state2), (Duration)debounceTimeout), (Function2)new Function2<List<? extends T>, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ HistoryPersister<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List history2 = (List)this.L$0;
                        HistoryPersister.access$persist(this.this$0, history2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(List<? extends T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (CoroutineContext)((CoroutineContext)dispatcher2)), (CoroutineScope)scope2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void persist(List<? extends T> entries) {
        this.logger.debug("Persisting history, " + Instant.now());
        PathsKt.createParentDirectories((Path)this.store, (FileAttribute[])new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(this.store, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream stream = (BufferedOutputStream)closeable;
            boolean bl = false;
            this.serialize.invoke(entries, (Object)stream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<T> readPersistedState() {
        List list;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.store, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || !Files.isReadable(this.store)) {
            this.logger.info("No persisted conversation history available");
            return CollectionsKt.emptyList();
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(this.store, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            list = (List)this.deserialize.invoke((Object)stream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    public static final /* synthetic */ void access$persist(HistoryPersister $this, List entries) {
        $this.persist(entries);
    }

    static {
        Duration duration = Duration.ofSeconds(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        debounceTimeout = duration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/bot/history/HistoryPersister$Companion;", "", "()V", "debounceTimeout", "Ljava/time/Duration;", "getDebounceTimeout", "()Ljava/time/Duration;", "aiplugin.core.aicore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDebounceTimeout() {
            return debounceTimeout;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

