/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.agents.ui;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.SnapshotStateMap;
import com.android.studio.ml.bot.agents.tools.DiffRequestsKt;
import com.android.studio.ml.bot.ui.compose.KeyedIcon;
import com.android.studio.ml.bot.ui.compose.KnownIconKt;
import com.android.studio.ml.metrics.AiCodeEditingActionListener;
import com.android.tools.idea.studiobot.FileChange;
import com.google.aiplugin.agents.localhistory.GeminiActivityPresentationProviderKt;
import com.google.aiplugin.agents.tools.ToolContextKt;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0018J\u001c\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0086@\u00a2\u0006\u0002\u0010%R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00070\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00120\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/android/studio/ml/bot/agents/ui/AgentChangesSummaryController;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changesModificationStamps", "", "Lcom/intellij/openapi/editor/Document;", "", "getChangesModificationStamps", "()Ljava/util/Map;", "documents", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDocuments", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "fileIcons", "Lcom/android/studio/ml/bot/ui/compose/KeyedIcon;", "getFileIcons", "getProject", "()Lcom/intellij/openapi/project/Project;", "summarizedChanges", "Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "Lcom/android/tools/idea/studiobot/FileChange;", "getSummarizedChanges", "()Landroidx/compose/runtime/snapshots/SnapshotStateMap;", "checkForFileModifications", "", "openAllDiffs", "openInDiffView", "change", "rollbackAll", "rollbackChange", "updateChangeList", "changes", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.core.aicore"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentChangesSummaryController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentChangesSummaryController.kt\ncom/android/studio/ml/bot/agents/ui/AgentChangesSummaryController\n+ 2 GeminiActivityPresentationProvider.kt\ncom/google/aiplugin/agents/localhistory/GeminiActivityPresentationProviderKt\n*L\n1#1,138:1\n82#2,14:139\n*S KotlinDebug\n*F\n+ 1 AgentChangesSummaryController.kt\ncom/android/studio/ml/bot/agents/ui/AgentChangesSummaryController\n*L\n124#1:139,14\n*E\n"})
public final class AgentChangesSummaryController {
    @NotNull
    private final Project project;
    @NotNull
    private final SnapshotStateMap<VirtualFile, FileChange> summarizedChanges;
    @NotNull
    private final MutableStateFlow<Map<VirtualFile, KeyedIcon>> fileIcons;
    @NotNull
    private final MutableStateFlow<Map<VirtualFile, Document>> documents;
    @NotNull
    private final Map<Document, Long> changesModificationStamps;
    public static final int $stable = 8;

    public AgentChangesSummaryController(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.summarizedChanges = SnapshotStateKt.mutableStateMapOf();
        this.fileIcons = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.documents = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.changesModificationStamps = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SnapshotStateMap<VirtualFile, FileChange> getSummarizedChanges() {
        return this.summarizedChanges;
    }

    @NotNull
    public final MutableStateFlow<Map<VirtualFile, KeyedIcon>> getFileIcons() {
        return this.fileIcons;
    }

    @NotNull
    public final MutableStateFlow<Map<VirtualFile, Document>> getDocuments() {
        return this.documents;
    }

    @NotNull
    public final Map<Document, Long> getChangesModificationStamps() {
        return this.changesModificationStamps;
    }

    @Nullable
    public final Object updateChangeList(@NotNull List<FileChange> changes, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(this, changes){
            final /* synthetic */ AgentChangesSummaryController this$0;
            final /* synthetic */ List<FileChange> $changes;
            {
                this.this$0 = $receiver;
                this.$changes = $changes;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$associateTo$iv$iv;
                Object object;
                void $this$associateTo$iv$iv2;
                Iterable $this$associate$iv;
                this.this$0.getSummarizedChanges().putAll(ToolContextKt.getTotalChangesPerFile(this.$changes));
                Iterable iterable = this.this$0.getSummarizedChanges().keySet();
                Object object2 = this.this$0.getDocuments();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var4_7 = $this$associate$iv;
                Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv2) {
                    Map map2 = destination$iv$iv;
                    VirtualFile file = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    object = TuplesKt.to((Object)file, (Object)FileDocumentManager.getInstance().getDocument(file));
                    map2.put(object.getFirst(), object.getSecond());
                }
                object2.setValue(destination$iv$iv);
                for (Document document2 : CollectionsKt.filterNotNull((Iterable)((Map)this.this$0.getDocuments().getValue()).values())) {
                    this.this$0.getChangesModificationStamps().put(document2, document2.getModificationStamp());
                }
                $this$associate$iv = this.this$0.getSummarizedChanges().keySet();
                AgentChangesSummaryController agentChangesSummaryController = this.this$0;
                object2 = this.this$0.getFileIcons();
                boolean $i$f$associate2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv2);
                boolean $i$f$associateTo2 = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    KeyedIcon keyedIcon;
                    Icon icon2;
                    object = destination$iv$iv2;
                    VirtualFile file = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    Object object3 = PsiManager.getInstance((Project)agentChangesSummaryController.getProject()).findFile(file);
                    if (object3 != null && (object3 = (icon2 = object3.getIcon(0))) != null) {
                        Intrinsics.checkNotNull((Object)object3);
                        keyedIcon = KnownIconKt.toKeyedIconOrNull(icon2, agentChangesSummaryController.getClass());
                    } else {
                        keyedIcon = null;
                    }
                    Pair pair = TuplesKt.to((Object)file, keyedIcon);
                    object.put(pair.getFirst(), pair.getSecond());
                }
                object2.setValue((Object)destination$iv$iv2);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void checkForFileModifications() {
        for (Map.Entry entry : ((Map)this.documents.getValue()).entrySet()) {
            FileChange change;
            VirtualFile vf = (VirtualFile)entry.getKey();
            Document document2 = (Document)entry.getValue();
            if (document2 == null || !this.changesModificationStamps.containsKey(document2) || (FileChange)this.summarizedChanges.get((Object)vf) == null) continue;
            Long l2 = this.changesModificationStamps.get(document2);
            if (l2 != null && document2.getModificationStamp() == l2.longValue()) continue;
            change.getCanBeRolledBack().setValue((Object)false);
        }
    }

    public final void openInDiffView(@NotNull FileChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory, (String)"getInstance(...)");
        DiffContentFactory diffContentFactory2 = diffContentFactory;
        DocumentContent documentContent = diffContentFactory2.create(this.project, change.getDiff().getBefore(), change.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        DocumentContent left = documentContent;
        DocumentContent documentContent2 = diffContentFactory2.create(this.project, change.getDiff().getAfter(), change.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"create(...)");
        DocumentContent right = documentContent2;
        SimpleDiffRequest diffRequest = new SimpleDiffRequest("Diff: " + change.getFile().getName(), (DiffContent)left, (DiffContent)right, "Before", "After");
        DiffManager.getInstance().showDiff(this.project, (DiffRequest)diffRequest);
    }

    public final void openAllDiffs() {
        block0: {
            DiffRequestChain diffRequestChain = DiffRequestsKt.createDiffRequestChain(this.project, this.summarizedChanges.values());
            if (diffRequestChain == null) break block0;
            DiffRequestChain chain = diffRequestChain;
            boolean bl = false;
            DiffManager.getInstance().showDiff(this.project, chain, DiffDialogHints.DEFAULT);
        }
    }

    public final void rollbackAll() {
        for (FileChange change : this.summarizedChanges.values()) {
            this.rollbackChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void rollbackChange(@NotNull FileChange change) {
        void label$iv;
        void $this$runAndFinishGeminiHistoryAction_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!((Boolean)change.getCanBeRolledBack().getValue()).booleanValue()) {
            return;
        }
        Document document2 = (Document)((Map)this.documents.getValue()).get(change.getFile());
        if (document2 == null) {
            return;
        }
        change.getRolledBack().setValue((Object)true);
        change.getCanBeRolledBack().setValue((Object)false);
        LocalHistory localHistory = LocalHistory.Companion.getInstance();
        String string = "Agent Mode - user rolled back change";
        AiCodeEditingActionListener.CodeEditingAction codeEditingAction$iv = AiCodeEditingActionListener.CodeEditingAction.AI_CODE_GENERATION;
        boolean $i$f$runAndFinishGeminiHistoryAction = false;
        AiCodeEditingActionListener.Companion.setCodeEditingAction(codeEditingAction$iv);
        LocalHistoryAction historyAction$iv = $this$runAndFinishGeminiHistoryAction_u24default$iv.startAction((String)label$iv, GeminiActivityPresentationProviderKt.getDEFAULT_GEMINI_ACTIVITY_ID());
        try {
            boolean bl = false;
            if (change.isNewFile()) {
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> AgentChangesSummaryController.rollbackChange$lambda$0$0(change, this));
            } else {
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> AgentChangesSummaryController.rollbackChange$lambda$0$1(document2, change));
            }
        }
        finally {
            historyAction$iv.finish();
        }
    }

    private static final void rollbackChange$lambda$0$0(FileChange $change, AgentChangesSummaryController this$0) {
        $change.getFile().delete((Object)this$0);
    }

    private static final void rollbackChange$lambda$0$1(Document $document, FileChange $change) {
        $document.setText((CharSequence)$change.getDiff().getBefore());
        FileDocumentManager.getInstance().saveDocument($document);
    }
}

