/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.bot.action;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\n\u00a8\u0006\u0011"}, d2={"Lcom/android/studio/ml/bot/action/CodeSelectionUtils;", "", "()V", "getCurrentElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditorFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSelectedTextOrNull", "", "getSelectionRange", "Lcom/intellij/openapi/util/TextRange;", "removeIndentFrom", "code", "indentWidth", "", "aiplugin.core.aicore"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCodeSelectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeSelectionUtils.kt\ncom/android/studio/ml/bot/action/CodeSelectionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,107:1\n827#2:108\n855#2,2:109\n1563#2:112\n1634#2,3:113\n1869#2,2:116\n1#3:111\n158#4,6:118\n*S KotlinDebug\n*F\n+ 1 CodeSelectionUtils.kt\ncom/android/studio/ml/bot/action/CodeSelectionUtils\n*L\n54#1:108\n54#1:109,2\n67#1:112\n67#1:113,3\n68#1:116,2\n80#1:118,6\n*E\n"})
public final class CodeSelectionUtils {
    @NotNull
    public static final CodeSelectionUtils INSTANCE = new CodeSelectionUtils();
    public static final int $stable;

    private CodeSelectionUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String removeIndentFrom(@NotNull String code) {
        StringBuilder stringBuilder;
        int minIndent;
        Object object;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        List lines = StringsKt.lines((CharSequence)code);
        if (lines.size() <= 1) {
            return ((Object)StringsKt.trim((CharSequence)code)).toString();
        }
        String firstLine = (String)CollectionsKt.first((List)lines);
        if (StringsKt.isBlank((CharSequence)firstLine) || this.indentWidth(firstLine) > 0) {
            return StringsKt.trimIndent((String)code);
        }
        Iterable $this$filterNot$iv = CollectionsKt.drop((Iterable)lines, (int)1);
        boolean $i$f$filterNot22 = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator $i$f$filterNot22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$filterNot22.hasNext()) {
            object = null;
        } else {
            Object it = (String)$i$f$filterNot22.next();
            boolean bl = false;
            it = INSTANCE.indentWidth((String)it);
            while ($i$f$filterNot22.hasNext()) {
                Object it2 = (String)$i$f$filterNot22.next();
                $i$a$-minOfOrNull-CodeSelectionUtils$removeIndentFrom$minIndent$2 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(INSTANCE.indentWidth((String)it2))) <= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        int n2 = minIndent = n != null ? n : 0;
        if (minIndent == 0) {
            return ((Object)StringsKt.trim((CharSequence)code)).toString();
        }
        StringBuilder $this$removeIndentFrom_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$removeIndentFrom_u24lambda_u242.append(firstLine).append('\n');
        int remainingLinesCount = lines.size() - 1;
        if (remainingLinesCount > 1) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable it2 = CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)lines, (int)1), (int)(remainingLinesCount - 1));
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(!StringsKt.isBlank((CharSequence)((CharSequence)it)) ? ((Object)StringsKt.trimEnd((CharSequence)StringsKt.drop((String)it, (int)minIndent))).toString() : "");
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                $this$removeIndentFrom_u24lambda_u242.append(it).append('\n');
            }
        }
        if (remainingLinesCount > 0) {
            String lastLine = ((Object)StringsKt.trimEnd((CharSequence)StringsKt.drop((String)((String)CollectionsKt.last((List)CollectionsKt.drop((Iterable)lines, (int)1))), (int)minIndent))).toString();
            $this$removeIndentFrom_u24lambda_u242.append(lastLine);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final int indentWidth(@NotNull String $this$indentWidth) {
        void var3_3;
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$indentWidth, (String)"<this>");
            CharSequence $this$indexOfFirst$iv = $this$indentWidth;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it == -1 ? $this$indentWidth.length() : var3_3;
    }

    @NotNull
    public final TextRange getSelectionRange(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!editor2.getSelectionModel().hasSelection()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return textRange;
        }
        return new TextRange(editor2.getSelectionModel().getSelectionStart(), editor2.getSelectionModel().getSelectionEnd());
    }

    @NlsSafe
    @Nullable
    public final String getSelectedTextOrNull(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!editor2.getSelectionModel().hasSelection(true)) {
            return null;
        }
        boolean isMultiCaret = editor2.getCaretModel().getCaretCount() > 1;
        String string = editor2.getSelectionModel().getSelectedText(true);
        if (string == null) {
            return null;
        }
        String selectedText = string;
        return isMultiCaret ? ((Object)StringsKt.trim((CharSequence)selectedText)).toString() : this.removeIndentFrom(selectedText);
    }

    @Nullable
    public final PsiElement getCurrentElement(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = this.getEditorFile(editor2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project3).findFile(file);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        PsiElement psiElement = psiFile3.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement == null) {
            psiElement = (PsiElement)psiFile3;
        }
        return psiElement;
    }

    @Nullable
    public final VirtualFile getEditorFile(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return FileDocumentManager.getInstance().getFile(editor2.getDocument());
    }
}

