/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.openai;

import com.android.studio.ml.backends.ChatApi;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.GenerationConfig;
import com.android.tools.idea.studiobot.Model;
import com.android.tools.idea.studiobot.ModelConfig;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/studio/ml/backends/openai/OpenAiModel;", "Lcom/android/tools/idea/studiobot/Model;", "modelConfig", "Lcom/android/tools/idea/studiobot/ModelConfig;", "modelId", "", "chatApiProvider", "Lkotlin/Function0;", "Lcom/android/studio/ml/backends/ChatApi;", "<init>", "(Lcom/android/tools/idea/studiobot/ModelConfig;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "chatApi", "getChatApi", "()Lcom/android/studio/ml/backends/ChatApi;", "chatApi$delegate", "Lkotlin/Lazy;", "config", "generateContent", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/studiobot/Content;", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "Lcom/android/tools/idea/studiobot/GenerationConfig;", "aiplugin.backends.third-party"})
public final class OpenAiModel
implements Model {
    @NotNull
    private final ModelConfig modelConfig;
    @NotNull
    private final String modelId;
    @NotNull
    private final Function0<ChatApi> chatApiProvider;
    @NotNull
    private final Lazy chatApi$delegate;

    public OpenAiModel(@NotNull ModelConfig modelConfig, @NotNull String modelId, @NotNull Function0<? extends ChatApi> chatApiProvider) {
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(chatApiProvider, (String)"chatApiProvider");
        this.modelConfig = modelConfig;
        this.modelId = modelId;
        this.chatApiProvider = chatApiProvider;
        this.chatApi$delegate = LazyKt.lazy(() -> OpenAiModel.chatApi_delegate$lambda$0(this));
    }

    @NotNull
    public final ChatApi getChatApi() {
        Lazy lazy = this.chatApi$delegate;
        return (ChatApi)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelConfig config() {
        return this.modelConfig;
    }

    @Override
    @RequiresBackgroundThread
    @NotNull
    public Flow<Content> generateContent(@NotNull Prompt prompt2, @NotNull GenerationConfig config2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return this.getChatApi().generateContent(this.modelId, prompt2, this.modelConfig, config2);
    }

    private static final ChatApi chatApi_delegate$lambda$0(OpenAiModel this$0) {
        return (ChatApi)this$0.chatApiProvider.invoke();
    }
}

