/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.backends.anthropic;

import com.android.studio.ml.backends.PromptsKt;
import com.android.studio.ml.backends.anthropic.AnthropicChatModelProviderKt;
import com.android.studio.ml.backends.anthropic.AnthropicModel;
import com.android.studio.ml.prompting.PromptUtilsKt;
import com.android.tools.idea.studiobot.Content;
import com.android.tools.idea.studiobot.GenerationConfig;
import com.android.tools.idea.studiobot.MimeType;
import com.android.tools.idea.studiobot.Model;
import com.android.tools.idea.studiobot.ModelConfig;
import com.android.tools.idea.studiobot.MutableTokenUsageMetadata;
import com.android.tools.idea.studiobot.TokenUsageMetadata;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.anthropic.client.AnthropicClientAsync;
import com.anthropic.core.JsonValue;
import com.anthropic.core.http.AsyncStreamResponse;
import com.anthropic.models.messages.Base64ImageSource;
import com.anthropic.models.messages.CitationsDelta;
import com.anthropic.models.messages.ContentBlockParam;
import com.anthropic.models.messages.ImageBlockParam;
import com.anthropic.models.messages.InputJsonDelta;
import com.anthropic.models.messages.MessageCreateParams;
import com.anthropic.models.messages.MessageDeltaUsage;
import com.anthropic.models.messages.MessageParam;
import com.anthropic.models.messages.RawContentBlockDelta;
import com.anthropic.models.messages.RawContentBlockDeltaEvent;
import com.anthropic.models.messages.RawContentBlockStartEvent;
import com.anthropic.models.messages.RawContentBlockStopEvent;
import com.anthropic.models.messages.RawMessageDeltaEvent;
import com.anthropic.models.messages.RawMessageStartEvent;
import com.anthropic.models.messages.RawMessageStopEvent;
import com.anthropic.models.messages.RawMessageStreamEvent;
import com.anthropic.models.messages.SignatureDelta;
import com.anthropic.models.messages.StopReason;
import com.anthropic.models.messages.TextBlockParam;
import com.anthropic.models.messages.TextDelta;
import com.anthropic.models.messages.ThinkingConfigDisabled;
import com.anthropic.models.messages.ThinkingDelta;
import com.anthropic.models.messages.Tool;
import com.anthropic.models.messages.ToolChoiceAny;
import com.anthropic.models.messages.ToolChoiceAuto;
import com.anthropic.models.messages.ToolChoiceNone;
import com.anthropic.models.messages.ToolResultBlockParam;
import com.anthropic.models.messages.ToolUseBlock;
import com.anthropic.models.messages.ToolUseBlockParam;
import com.anthropic.models.messages.Usage;
import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001/B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001cH\u0002J&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u00060"}, d2={"Lcom/android/studio/ml/backends/anthropic/AnthropicModel;", "Lcom/android/tools/idea/studiobot/Model;", "modelConfig", "Lcom/android/tools/idea/studiobot/ModelConfig;", "modelId", "", "clientProvider", "Lkotlin/Function0;", "Lcom/anthropic/client/AnthropicClientAsync;", "<init>", "(Lcom/android/tools/idea/studiobot/ModelConfig;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "client", "getClient", "()Lcom/anthropic/client/AnthropicClientAsync;", "client$delegate", "Lkotlin/Lazy;", "config", "generateContent", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/tools/idea/studiobot/Content;", "prompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "Lcom/android/tools/idea/studiobot/GenerationConfig;", "encodeMessage", "Lcom/anthropic/models/messages/MessageCreateParams$Builder;", "makeMessage", "Lcom/anthropic/models/messages/MessageParam$Content;", "messageChunks", "", "Lcom/android/tools/idea/studiobot/prompts/Prompt$Chunk;", "makeFunctionCallMessage", "message", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionCallMessage;", "makeFunctionResponseMessage", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionResponseMessage;", "makeContextMessage", "Lcom/android/tools/idea/studiobot/prompts/Prompt$ContextMessage;", "convertToInputSchema", "Lcom/anthropic/models/messages/Tool$InputSchema;", "parameters", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionParameter;", "convert", "", "", "type", "Lcom/android/tools/idea/studiobot/prompts/Prompt$FunctionParameterType;", "description", "ResponseAssembler", "aiplugin.backends.third-party"})
@SourceDebugExtension(value={"SMAP\nAnthropicModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicModel.kt\ncom/android/studio/ml/backends/anthropic/AnthropicModel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,442:1\n14#2:443\n1869#3,2:444\n1869#3,2:446\n1563#3:448\n1634#3,3:449\n1869#3,2:452\n1#4:454\n216#5,2:455\n*S KotlinDebug\n*F\n+ 1 AnthropicModel.kt\ncom/android/studio/ml/backends/anthropic/AnthropicModel\n*L\n97#1:443\n141#1:444,2\n154#1:446,2\n178#1:448\n178#1:449,3\n243#1:452,2\n270#1:455,2\n*E\n"})
public final class AnthropicModel
implements Model {
    @NotNull
    private final ModelConfig modelConfig;
    @NotNull
    private final String modelId;
    @NotNull
    private final Function0<AnthropicClientAsync> clientProvider;
    @NotNull
    private final Lazy client$delegate;

    public AnthropicModel(@NotNull ModelConfig modelConfig, @NotNull String modelId, @NotNull Function0<? extends AnthropicClientAsync> clientProvider) {
        Intrinsics.checkNotNullParameter((Object)modelConfig, (String)"modelConfig");
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        Intrinsics.checkNotNullParameter(clientProvider, (String)"clientProvider");
        this.modelConfig = modelConfig;
        this.modelId = modelId;
        this.clientProvider = clientProvider;
        this.client$delegate = LazyKt.lazy(() -> AnthropicModel.client_delegate$lambda$0(this));
    }

    @NotNull
    public final AnthropicClientAsync getClient() {
        Lazy lazy = this.client$delegate;
        return (AnthropicClientAsync)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelConfig config() {
        return this.modelConfig;
    }

    @Override
    @RequiresBackgroundThread
    @NotNull
    public Flow<Content> generateContent(@NotNull Prompt prompt2, @NotNull GenerationConfig config2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Integer n = config2.getMaxOutputTokens();
        MessageCreateParams params = this.encodeMessage(MessageCreateParams.Companion.builder().model(this.modelId).maxTokens((long)(n != null ? n.intValue() : this.modelConfig.getOutputTokenLimit())), prompt2).thinking(ThinkingConfigDisabled.Companion.builder().build()).build();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnthropicModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Sending prompt: " + params);
        AsyncStreamResponse streamResponse = this.getClient().messages().createStreaming(params);
        return FlowKt.flowOn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Content>, Continuation<? super Unit>, Object>((AsyncStreamResponse<RawMessageStreamEvent>)streamResponse, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AsyncStreamResponse<RawMessageStreamEvent> $streamResponse;
            {
                this.$streamResponse = $streamResponse;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Ref.ObjectRef responseError = new Ref.ObjectRef();
                        ResponseAssembler assembler = new ResponseAssembler();
                        AsyncStreamResponse.Handler<RawMessageStreamEvent> responseHandler2 = new AsyncStreamResponse.Handler<RawMessageStreamEvent>(assembler, (ProducerScope<? super Content>)$this$callbackFlow, (Ref.ObjectRef<Throwable>)responseError){
                            final /* synthetic */ ResponseAssembler $assembler;
                            final /* synthetic */ ProducerScope<Content> $$this$callbackFlow;
                            final /* synthetic */ Ref.ObjectRef<Throwable> $responseError;
                            {
                                this.$assembler = $assembler;
                                this.$$this$callbackFlow = $$this$callbackFlow;
                                this.$responseError = $responseError;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onNext(RawMessageStreamEvent value) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                Iterable iterable = (Iterable)value.accept((RawMessageStreamEvent.Visitor)this.$assembler);
                                ProducerScope<Content> producerScope = this.$$this$callbackFlow;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Content content2 = (Content)element$iv;
                                    boolean bl = false;
                                    ChannelsKt.trySendBlocking((SendChannel)((SendChannel)producerScope), (Object)content2);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onComplete(Optional<Throwable> error) {
                                void $this$filterTo$iv$iv;
                                Intrinsics.checkNotNullParameter(error, (String)"error");
                                Iterable $this$filter$iv = this.$assembler.getContentBlockAssemblers().values();
                                boolean $i$f$filter = false;
                                Iterable iterable = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    ResponseAssembler.ContentBlockVisitor it = (ResponseAssembler.ContentBlockVisitor)element$iv$iv;
                                    boolean bl = false;
                                    if (!(!it.getEmitted())) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                List pending = (List)destination$iv$iv;
                                this.$responseError.element = error.isPresent() ? error.get() : (!((Collection)pending).isEmpty() ? (Throwable)new IllegalStateException("Unfinished content blocks: " + pending) : null);
                                SendChannel.DefaultImpls.close$default((SendChannel)this.$$this$callbackFlow.getChannel(), null, (int)1, null);
                            }
                        };
                        this.$streamResponse.subscribe((AsyncStreamResponse.Handler)responseHandler2);
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, () -> generateContent.1.invokeSuspend$lambda$0(this.$streamResponse, responseError), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super Content> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(AsyncStreamResponse $streamResponse, Ref.ObjectRef $responseError) {
                $streamResponse.close();
                Throwable throwable = (Throwable)$responseError.element;
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                return Unit.INSTANCE;
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    @NotNull
    public final MessageCreateParams.Builder encodeMessage(@NotNull MessageCreateParams.Builder $this$encodeMessage, @NotNull Prompt prompt2) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        List messages2 = CollectionsKt.first(prompt2.getMessages()) instanceof Prompt.SystemMessage ? prompt2.getMessages() : CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new Prompt.SystemMessage(CollectionsKt.listOf((Object)new Prompt.TextChunk("\nThe assistant is embedded inside Android Studio, the IDE for developing\nAndroid applications.\n\nIt should give concise answers to very simple questions, but provide thorough responses\nto more complex and open ended questions. It adopts a tone used in the official\nAndroid developer documentation at developer.android.com.\n\nIt provides relevant code snippets where applicable. Unless otherwise requested by\nthe user, code snippets are offered in Kotlin and use the modern Jetpack libraries\nand patterns, following modern Android development practices.\n\nWhile the assistant is embedded inside the IDE, it cannot actually see the user's\ncode unless users explicitly share it with the assistant. The IDE provides settings\nthat allow the user to control whether source code is visible to the assistant.\nThe IDE also allows more fine grained privacy controls via the use of a .aiexclude\nfile.\n", CollectionsKt.emptyList(), null, 4, null)))), (Iterable)prompt2.getMessages());
        Iterable $this$forEach$iv = messages2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageCreateParams.Builder builder;
            Prompt.Message message = (Prompt.Message)element$iv;
            boolean bl = false;
            Prompt.Message message2 = message;
            if (message2 instanceof Prompt.SystemMessage) {
                builder = $this$encodeMessage.system(PromptsKt.chunksToString(((Prompt.SystemMessage)message).getChunks()));
                continue;
            }
            if (message2 instanceof Prompt.ModelMessage) {
                builder = $this$encodeMessage.addAssistantMessage(this.makeMessage(((Prompt.ModelMessage)message).getChunks()));
                continue;
            }
            if (message2 instanceof Prompt.FunctionCallMessage) {
                builder = $this$encodeMessage.addAssistantMessage(this.makeFunctionCallMessage((Prompt.FunctionCallMessage)message));
                continue;
            }
            if (message2 instanceof Prompt.MemoryMessage || message2 instanceof Prompt.RuleMessage || message2 instanceof Prompt.UserMessage) {
                builder = $this$encodeMessage.addUserMessage(this.makeMessage(message.getChunks()));
                continue;
            }
            if (message2 instanceof Prompt.FunctionResponseMessage) {
                builder = $this$encodeMessage.addUserMessage(this.makeFunctionResponseMessage((Prompt.FunctionResponseMessage)message));
                continue;
            }
            if (message2 instanceof Prompt.ContextMessage) {
                builder = $this$encodeMessage.addUserMessage(this.makeContextMessage((Prompt.ContextMessage)message));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!((Collection)prompt2.getFunctions()).isEmpty()) {
            $this$forEach$iv = prompt2.getFunctions();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Prompt.Function function = (Prompt.Function)element$iv;
                boolean bl = false;
                $this$encodeMessage.addTool(Tool.Companion.builder().name(function.getName()).description(function.getDescription()).inputSchema(this.convertToInputSchema(function.getParameters())).build());
            }
            switch (WhenMappings.$EnumSwitchMapping$0[prompt2.getFunctionCallingMode().ordinal()]) {
                case 1: {
                    MessageCreateParams.Builder builder = $this$encodeMessage.toolChoice(ToolChoiceAuto.Companion.builder().build());
                    break;
                }
                case 2: {
                    MessageCreateParams.Builder builder = $this$encodeMessage.toolChoice(ToolChoiceAny.Companion.builder().build());
                    break;
                }
                case 3: {
                    MessageCreateParams.Builder builder = $this$encodeMessage.toolChoice(ToolChoiceNone.Companion.builder().build());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return $this$encodeMessage;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MessageParam.Content makeMessage(List<? extends Prompt.Chunk> messageChunks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = messageChunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ContentBlockParam contentBlockParam;
            void chunk;
            Prompt.Chunk chunk2 = (Prompt.Chunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = chunk;
            if (var12_11 instanceof Prompt.TextChunk) {
                contentBlockParam = ContentBlockParam.Companion.ofText(TextBlockParam.Companion.builder().text(((Prompt.TextChunk)chunk).getText()).build());
            } else if (var12_11 instanceof Prompt.CodeChunk) {
                contentBlockParam = ContentBlockParam.Companion.ofText(TextBlockParam.Companion.builder().text(((Prompt.CodeChunk)chunk).getText()).build());
            } else {
                if (!(var12_11 instanceof Prompt.BlobChunk)) throw new NoWhenBranchMatchedException();
                if (!AnthropicChatModelProviderKt.getSupportedImageMimeTypes().contains(MimeType.box-impl(((Prompt.BlobChunk)chunk).getMimeType-i_3W7CY()))) throw new IllegalArgumentException("BlobChunk type not supported: " + MimeType.toString-impl(((Prompt.BlobChunk)chunk).getMimeType-i_3W7CY()));
                byte[] base64Data = Base64.getEncoder().encode(((Prompt.BlobChunk)chunk).getData());
                ImageBlockParam.Builder builder = ImageBlockParam.Companion.builder();
                Base64ImageSource.Builder builder2 = Base64ImageSource.Companion.builder();
                Intrinsics.checkNotNull((Object)base64Data);
                contentBlockParam = ContentBlockParam.Companion.ofImage(builder.source(builder2.data(new String(base64Data, Charsets.UTF_8)).mediaType(Base64ImageSource.MediaType.Companion.of(MimeType.toString-impl(((Prompt.BlobChunk)chunk).getMimeType-i_3W7CY()))).build()).build());
            }
            collection.add(contentBlockParam);
        }
        List chunks = (List)destination$iv$iv;
        return MessageParam.Content.Companion.ofBlockParams(chunks);
    }

    private final MessageParam.Content makeFunctionCallMessage(Prompt.FunctionCallMessage message) {
        ToolUseBlockParam toolUse = ToolUseBlockParam.Companion.builder().id(message.getName()).input(JsonValue.Companion.from(message.getArgs())).name(message.getName()).build();
        return MessageParam.Content.Companion.ofBlockParams(CollectionsKt.listOf((Object)ContentBlockParam.Companion.ofToolUse(toolUse)));
    }

    private final MessageParam.Content makeFunctionResponseMessage(Prompt.FunctionResponseMessage message) {
        ToolResultBlockParam toolUseResponse = ToolResultBlockParam.Companion.builder().toolUseId(message.getName()).content(message.getResponse()).build();
        return MessageParam.Content.Companion.ofBlockParams(CollectionsKt.listOf((Object)ContentBlockParam.Companion.ofToolResult(toolUseResponse)));
    }

    private final MessageParam.Content makeContextMessage(Prompt.ContextMessage message) {
        String contextString = CollectionsKt.joinToString$default((Iterable)message.getChunks(), (CharSequence)"\n", null, null, (int)0, null, AnthropicModel::makeContextMessage$lambda$0, (int)30, null) + "\n" + PromptsKt.fileContext(message.getFiles());
        return MessageParam.Content.Companion.ofString(((Object)StringsKt.trim((CharSequence)contextString)).toString());
    }

    private final Tool.InputSchema convertToInputSchema(List<Prompt.FunctionParameter> parameters) {
        List requiredArgs = new ArrayList();
        Map args = new LinkedHashMap();
        Iterable $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Prompt.FunctionParameter functionParameter = (Prompt.FunctionParameter)element$iv;
            boolean bl = false;
            String name = functionParameter.component1();
            Prompt.FunctionParameterType type2 = functionParameter.component2();
            String description = functionParameter.component3();
            boolean required = functionParameter.component4();
            args.put(name, this.convert(type2, description));
            if (!required) continue;
            requiredArgs.add(name);
        }
        return Tool.InputSchema.Companion.builder().properties(JsonValue.Companion.from((Object)args)).required(requiredArgs).build();
    }

    private final Map<String, Object> convert(Prompt.FunctionParameterType type2, String description) {
        Map result2 = new LinkedHashMap();
        String string = description;
        if (string != null) {
            String it = string;
            boolean bl = false;
            result2.put("description", description);
        }
        Prompt.FunctionParameterType functionParameterType = type2;
        if (functionParameterType instanceof Prompt.FunctionParameterType.Integer) {
            result2.put("type", "integer");
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Number) {
            result2.put("type", "number");
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.String) {
            result2.put("type", "string");
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Boolean) {
            result2.put("type", "boolean");
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Enum) {
            result2.put("type", "string");
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.List) {
            result2.put("type", "array");
            result2.put("items", this.convert(((Prompt.FunctionParameterType.List)type2).getElementType(), null));
        } else if (functionParameterType instanceof Prompt.FunctionParameterType.Object) {
            result2.put("type", "object");
            Map properties = new LinkedHashMap();
            Map<String, Prompt.FunctionParameterType> $this$forEach$iv = ((Prompt.FunctionParameterType.Object)type2).getFields();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Prompt.FunctionParameterType>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Prompt.FunctionParameterType> element$iv;
                Map.Entry<String, Prompt.FunctionParameterType> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                Prompt.FunctionParameterType value = entry.getValue();
                properties.put(key, this.convert(value, null));
            }
            result2.put("properties", properties);
            result2.put("required", ((Prompt.FunctionParameterType.Object)type2).getRequiredFields());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    private static final AnthropicClientAsync client_delegate$lambda$0(AnthropicModel this$0) {
        return (AnthropicClientAsync)this$0.clientProvider.invoke();
    }

    private static final CharSequence makeContextMessage$lambda$0(Prompt.Chunk it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = PromptUtilsKt.queryString(it);
        return string != null ? (CharSequence)string : (CharSequence)"";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u00060\u0019R\u00020\u00000\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006."}, d2={"Lcom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler;", "Lcom/anthropic/models/messages/RawMessageStreamEvent$Visitor;", "", "Lcom/android/tools/idea/studiobot/Content;", "<init>", "()V", "tokenUsage", "Lcom/android/tools/idea/studiobot/MutableTokenUsageMetadata;", "getTokenUsage", "()Lcom/android/tools/idea/studiobot/MutableTokenUsageMetadata;", "tokenUsageMetadata", "", "", "Lcom/android/tools/idea/studiobot/TokenUsageMetadata;", "getTokenUsageMetadata", "()Ljava/util/Map;", "stopReason", "Lcom/anthropic/models/messages/StopReason;", "getStopReason", "()Lcom/anthropic/models/messages/StopReason;", "setStopReason", "(Lcom/anthropic/models/messages/StopReason;)V", "contentBlockAssemblers", "", "", "Lcom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler$ContentBlockVisitor;", "getContentBlockAssemblers", "visitMessageStart", "messageStart", "Lcom/anthropic/models/messages/RawMessageStartEvent;", "visitMessageDelta", "messageDelta", "Lcom/anthropic/models/messages/RawMessageDeltaEvent;", "visitMessageStop", "messageStop", "Lcom/anthropic/models/messages/RawMessageStopEvent;", "visitContentBlockStart", "contentBlockStart", "Lcom/anthropic/models/messages/RawContentBlockStartEvent;", "visitContentBlockDelta", "contentBlockDelta", "Lcom/anthropic/models/messages/RawContentBlockDeltaEvent;", "visitContentBlockStop", "contentBlockStop", "Lcom/anthropic/models/messages/RawContentBlockStopEvent;", "ContentBlockVisitor", "aiplugin.backends.third-party"})
    @SourceDebugExtension(value={"SMAP\nAnthropicModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnthropicModel.kt\ncom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,442:1\n1#2:443\n14#3:444\n14#3:445\n14#3:446\n*S KotlinDebug\n*F\n+ 1 AnthropicModel.kt\ncom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler\n*L\n326#1:444\n338#1:445\n357#1:446\n*E\n"})
    public static final class ResponseAssembler
    implements RawMessageStreamEvent.Visitor<List<? extends Content>> {
        @NotNull
        private final MutableTokenUsageMetadata tokenUsage = new MutableTokenUsageMetadata();
        @NotNull
        private final Map<String, TokenUsageMetadata> tokenUsageMetadata = this.tokenUsage.toMetadataMap();
        @Nullable
        private StopReason stopReason;
        @NotNull
        private final Map<Long, ContentBlockVisitor> contentBlockAssemblers = new LinkedHashMap();

        @NotNull
        public final MutableTokenUsageMetadata getTokenUsage() {
            return this.tokenUsage;
        }

        @NotNull
        public final Map<String, TokenUsageMetadata> getTokenUsageMetadata() {
            return this.tokenUsageMetadata;
        }

        @Nullable
        public final StopReason getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(@Nullable StopReason stopReason) {
            this.stopReason = stopReason;
        }

        @NotNull
        public final Map<Long, ContentBlockVisitor> getContentBlockAssemblers() {
            return this.contentBlockAssemblers;
        }

        @NotNull
        public List<Content> visitMessageStart(@NotNull RawMessageStartEvent messageStart) {
            Intrinsics.checkNotNullParameter((Object)messageStart, (String)"messageStart");
            Usage usage = messageStart.message().usage();
            MutableTokenUsageMetadata.update$default(this.tokenUsage, usage.inputTokens(), usage.outputTokens(), 0L, 4, null);
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Content> visitMessageDelta(@NotNull RawMessageDeltaEvent messageDelta) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)messageDelta, (String)"messageDelta");
                MessageDeltaUsage usageDelta = messageDelta.usage();
                Long l2 = (Long)OptionalsKt.getOrNull((Optional)usageDelta.inputTokens());
                long input = l2 != null ? l2.longValue() : this.tokenUsage.getInputTokenCount();
                long output = this.tokenUsage.getOutputTokenCount() + usageDelta.outputTokens();
                MutableTokenUsageMetadata.update$default(this.tokenUsage, input, output, 0L, 4, null);
                StopReason stopReason = (StopReason)OptionalsKt.getOrNull((Optional)messageDelta.delta().stopReason());
                if (stopReason == null) break block0;
                StopReason it = stopReason;
                boolean bl = false;
                this.stopReason = it;
            }
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Content> visitMessageStop(@NotNull RawMessageStopEvent messageStop) {
            List list;
            Intrinsics.checkNotNullParameter((Object)messageStop, (String)"messageStop");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AnthropicModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Token usage stats: " + this.tokenUsage + ", stopping because " + this.stopReason);
            StopReason stopReason = this.stopReason;
            if (Intrinsics.areEqual((Object)stopReason, (Object)StopReason.END_TURN) || Intrinsics.areEqual((Object)stopReason, (Object)StopReason.STOP_SEQUENCE) || Intrinsics.areEqual((Object)stopReason, (Object)StopReason.TOOL_USE)) {
                list = CollectionsKt.emptyList();
            } else if (Intrinsics.areEqual((Object)stopReason, (Object)StopReason.MAX_TOKENS) || Intrinsics.areEqual((Object)stopReason, (Object)StopReason.REFUSAL) || Intrinsics.areEqual((Object)stopReason, (Object)StopReason.PAUSE_TURN)) {
                boolean $i$f$logger2 = false;
                Logger logger2 = Logger.getInstance(AnthropicModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("Stopping due to " + this.stopReason);
                list = CollectionsKt.emptyList();
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public List<Content> visitContentBlockStart(@NotNull RawContentBlockStartEvent contentBlockStart) {
            Intrinsics.checkNotNullParameter((Object)contentBlockStart, (String)"contentBlockStart");
            RawContentBlockStartEvent.ContentBlock block = contentBlockStart.contentBlock();
            this.contentBlockAssemblers.put(contentBlockStart.index(), new ContentBlockVisitor(block));
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<Content> visitContentBlockDelta(@NotNull RawContentBlockDeltaEvent contentBlockDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlockDelta, (String)"contentBlockDelta");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AnthropicModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("ContentBlockDelta: " + contentBlockDelta);
            ContentBlockVisitor contentBlockVisitor = this.contentBlockAssemblers.get(contentBlockDelta.index());
            if (contentBlockVisitor != null) {
                ContentBlockVisitor it = contentBlockVisitor;
                boolean bl = false;
                return (List)contentBlockDelta.delta().accept((RawContentBlockDelta.Visitor)it);
            }
            throw new IllegalStateException("No visitor for content block " + contentBlockDelta.index());
        }

        @NotNull
        public List<Content> visitContentBlockStop(@NotNull RawContentBlockStopEvent contentBlockStop) {
            Intrinsics.checkNotNullParameter((Object)contentBlockStop, (String)"contentBlockStop");
            Object object = this.contentBlockAssemblers.get(contentBlockStop.index());
            if (object == null || (object = ((ContentBlockVisitor)object).assemble()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object result2 = object;
            this.contentBlockAssemblers.remove(contentBlockStop.index());
            return result2;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler$ContentBlockVisitor;", "Lcom/anthropic/models/messages/RawContentBlockDelta$Visitor;", "", "Lcom/android/tools/idea/studiobot/Content;", "block", "Lcom/anthropic/models/messages/RawContentBlockStartEvent$ContentBlock;", "<init>", "(Lcom/android/studio/ml/backends/anthropic/AnthropicModel$ResponseAssembler;Lcom/anthropic/models/messages/RawContentBlockStartEvent$ContentBlock;)V", "fragments", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getFragments", "()Ljava/lang/StringBuilder;", "emitted", "", "getEmitted", "()Z", "setEmitted", "(Z)V", "assemble", "visitText", "text", "Lcom/anthropic/models/messages/TextDelta;", "visitThinking", "thinking", "Lcom/anthropic/models/messages/ThinkingDelta;", "visitSignature", "signature", "Lcom/anthropic/models/messages/SignatureDelta;", "visitInputJson", "inputJson", "Lcom/anthropic/models/messages/InputJsonDelta;", "visitCitations", "citations", "Lcom/anthropic/models/messages/CitationsDelta;", "unknown", "json", "Lcom/anthropic/core/JsonValue;", "aiplugin.backends.third-party"})
        public final class ContentBlockVisitor
        implements RawContentBlockDelta.Visitor<List<? extends Content>> {
            @NotNull
            private final RawContentBlockStartEvent.ContentBlock block;
            @NotNull
            private final StringBuilder fragments;
            private boolean emitted;

            public ContentBlockVisitor(RawContentBlockStartEvent.ContentBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                this.block = block;
                this.fragments = new StringBuilder();
            }

            @NotNull
            public final StringBuilder getFragments() {
                return this.fragments;
            }

            public final boolean getEmitted() {
                return this.emitted;
            }

            public final void setEmitted(boolean bl) {
                this.emitted = bl;
            }

            @NotNull
            public final List<Content> assemble() {
                if (this.emitted) {
                    return CollectionsKt.emptyList();
                }
                this.emitted = true;
                if (this.block.isToolUse()) {
                    Map map2;
                    ToolUseBlock call = this.block.asToolUse();
                    Type argumentsType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    String string = this.fragments.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String argsJson = string;
                    if (((CharSequence)argsJson).length() == 0) {
                        map2 = MapsKt.emptyMap();
                    } else {
                        Object object = new GsonBuilder().create().fromJson(argsJson, argumentsType2);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        map2 = (Map)object;
                    }
                    Map args = map2;
                    return CollectionsKt.listOf((Object)new Content.FunctionCall(call.name(), args, null, null, ResponseAssembler.this.getTokenUsageMetadata(), null, 44, null));
                }
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<Content> visitText(@NotNull TextDelta text2) {
                List list;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                if (this.block.isText()) {
                    CharSequence charSequence = text2.text();
                    Regex regex = new Regex("\\n\\n([a-z ,.:;])");
                    String string = "$1";
                    String content2 = regex.replace(charSequence, string);
                    list = CollectionsKt.listOf((Object)new Content.TextContent(content2, null, ResponseAssembler.this.getTokenUsageMetadata(), null, null, null, 58, null));
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }

            @NotNull
            public List<Content> visitThinking(@NotNull ThinkingDelta thinking) {
                Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                return CollectionsKt.listOf((Object)new Content.Thought(thinking.thinking(), ResponseAssembler.this.getTokenUsageMetadata()));
            }

            @NotNull
            public List<Content> visitSignature(@NotNull SignatureDelta signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<Content> visitInputJson(@NotNull InputJsonDelta inputJson) {
                Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
                if (this.block.isToolUse() || this.block.isServerToolUse()) {
                    this.fragments.append(inputJson.partialJson());
                }
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<Content> visitCitations(@NotNull CitationsDelta citations2) {
                Intrinsics.checkNotNullParameter((Object)citations2, (String)"citations");
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<Content> unknown(@Nullable JsonValue json) {
                return CollectionsKt.emptyList();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Prompt.FunctionCallingMode.values().length];
            try {
                nArray[Prompt.FunctionCallingMode.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Prompt.FunctionCallingMode.ANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Prompt.FunctionCallingMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

