/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.studio.ml.VersionLookup;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.HttpConnectionUtils;
import com.intellij.util.text.EditDistance;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0099\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005*\u00013\b\u0017\u0018\u00002\u00020\u0001:\u0004DEFGB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0014\u0010\u0019\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010\u001c\u001a\u00020\u001d*\u00020\u000e2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010#\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u001b2\u0006\u0010'\u001a\u00020\u000eH\u0002J.\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%H\u0014J\u0012\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020%H\u0014J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002010/H\u0014J\r\u00102\u001a\u000203H\u0002\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020\u0007H\u0014J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u0002002\u0006\u0010&\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0017H\u0014J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0014H\u0014J\f\u0010\u0019\u001a\u00020\u0007*\u00020;H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010\u001b2\u0006\u0010=\u001a\u00020\u0007H\u0014J\n\u0010>\u001a\u0004\u0018\u00010\u001bH\u0014J\n\u0010?\u001a\u0004\u0018\u00010\u001bH\u0014J\u001c\u0010@\u001a\u0004\u0018\u00010\u00072\u0006\u0010A\u001a\u00020\u00072\b\b\u0002\u0010B\u001a\u00020CH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0011j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/android/studio/ml/VersionLookup;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lookupVersions", "", "artifactName", "doLookupVersions", "originalName", "cleanup", "getWellKnownArtifact", "", "Lcom/android/studio/ml/VersionLookup$Artifact;", "name", "artifacts", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "artifactKeys", "", "mavenArtifact", "isValidGroupIdString", "", "s", "describe", "versions", "Lcom/android/studio/ml/VersionLookup$Versions;", "append", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "version", "type", "attachBomContents", "module", "Lcom/android/ide/common/gradle/Module;", "prefix", "artifact", "collectBomVersions", "", "Lcom/android/studio/ml/VersionLookup$BomItem;", "artifactId", "getVersionsFromMavenCentral", "getVersionsFromGmaven", "getSdkManager", "Lkotlin/Pair;", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "Lcom/android/repository/api/RepoManager;", "getSdkLogger", "com/android/studio/ml/VersionLookup$getSdkLogger$1", "()Lcom/android/studio/ml/VersionLookup$getSdkLogger$1;", "getVersionFromSdkManager", "getRemotePackagesForPrefix", "Lcom/android/repository/api/RemotePackage;", "sdkHandler", "preview", "getRemotePlatformVersions", "Lcom/android/sdklib/repository/meta/DetailsTypes$PlatformDetailsType;", "getGradlePlugin", "pluginId", "getStudioVersions", "getVersionFromGradleOrg", "readUrlDataAsString", "query", "timeout", "", "Artifact", "Versions", "BomItem", "VersionSource", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVersionLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionLookup.kt\ncom/android/studio/ml/VersionLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,796:1\n1#2:797\n1#2:825\n1855#3,2:798\n1104#3,3:803\n1069#3,2:806\n158#3,6:828\n188#4,3:800\n1761#5,3:808\n295#5,2:811\n295#5,2:813\n1617#5,9:815\n1869#5:824\n1870#5:826\n1626#5:827\n*S KotlinDebug\n*F\n+ 1 VersionLookup.kt\ncom/android/studio/ml/VersionLookup\n*L\n696#1:825\n80#1:798,2\n416#1:803,3\n429#1:806,2\n565#1:828,6\n206#1:800,3\n479#1:808,3\n662#1:811,2\n663#1:813,2\n696#1:815,9\n696#1:824\n696#1:826\n696#1:827\n*E\n"})
public class VersionLookup {
    @NotNull
    private final Project project;
    @NotNull
    private final LinkedHashMap<String, Artifact> artifacts;
    @NotNull
    private final List<String> artifactKeys;
    public static final int $stable = 8;

    public VersionLookup(@NotNull Project project2) {
        Artifact artifact;
        Artifact artifact2;
        Artifact artifact3;
        Artifact material3;
        Artifact artifact4;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.artifacts = new LinkedHashMap(100);
        Artifact adb = new Artifact("ADB (android debug bridge)", VersionSource.SDK_MANAGER, "platform-tools", false, 8, null);
        Artifact androidSdk = new Artifact("Android SDK", VersionSource.SDK_MANAGER, "platforms", false, 8, null);
        Artifact avdManager = new Artifact("AVD manager", VersionSource.SDK_MANAGER, "cmdline-tools", false, 8, null);
        Artifact buildTools = new Artifact("Android Build Tools", VersionSource.SDK_MANAGER, "build-tools", false, 8, null);
        Artifact emulator = new Artifact("the Android Emulator", VersionSource.SDK_MANAGER, "emulator", false, 8, null);
        Artifact ndk = new Artifact("the NDK", VersionSource.SDK_MANAGER, "ndk", false, 8, null);
        Artifact platformTools = new Artifact("Platform tools", VersionSource.SDK_MANAGER, "platform-tools", false, 8, null);
        Artifact cmdlineTools = new Artifact("SDK manager", VersionSource.SDK_MANAGER, "cmdline-tools", false, 8, null);
        VersionLookup._init_$add(this, "adb", adb);
        VersionLookup._init_$add$1(this, "android", "android sdk", "android platform", androidSdk);
        VersionLookup._init_$add(this, "avdmanager", avdManager);
        VersionLookup._init_$add(this, "build tools", buildTools);
        VersionLookup._init_$add(this, "emulator", emulator);
        VersionLookup._init_$add$0(this, "ndk", "android ndk", ndk);
        VersionLookup._init_$add(this, "platformtools", platformTools);
        VersionLookup._init_$add(this, "sdkmanager", cmdlineTools);
        Artifact agp = new Artifact("the Android Gradle Plugin", VersionSource.GMAVEN, "com.android.tools.build:gradle", true);
        Artifact firebase = new Artifact("com.google.firebase:firebase-bom", VersionSource.GMAVEN, null, false, 12, null);
        Artifact analytics = new Artifact("com.google.firebase:firebase-analytics", VersionSource.GMAVEN, null, false, 12, null);
        Artifact compose = new Artifact("Jetpack Compose", VersionSource.GMAVEN, "androidx.compose:compose-bom", false, 8, null);
        Artifact composeNav = new Artifact("Compose Navigation", VersionSource.GMAVEN, "androidx.navigation:navigation-compose", false, 8, null);
        Artifact composeCompiler = new Artifact("Compose Compiler", VersionSource.GMAVEN, "androidx.compose.compiler:compiler", false, 8, null);
        Artifact crashlytics = new Artifact("com.google.firebase:firebase-crashlytics", VersionSource.GMAVEN, null, false, 8, null);
        Artifact dataStore = new Artifact("androidx.datastore:datastore", VersionSource.GMAVEN, null, false, 12, null);
        Artifact prefDataStore = new Artifact("androidx.datastore:datastore-preferences", VersionSource.GMAVEN, null, false, 12, null);
        Artifact desugarLibs = new Artifact("com.android.tools:desugar_jdk_libs", VersionSource.GMAVEN, null, false, 12, null);
        Artifact espresso = new Artifact("Espresso", VersionSource.GMAVEN, "androidx.test.espresso:espresso-core", false, 8, null);
        Artifact fragment = new Artifact("androidx.fragment:fragment", VersionSource.GMAVEN, null, false, 12, null);
        Artifact hilt = new Artifact("com.google.dagger:hilt-android", VersionSource.GMAVEN, null, false, 12, null);
        Artifact junitExt = new Artifact("androidx.test.ext:junit", VersionSource.GMAVEN, null, false, 12, null);
        Artifact lint = new Artifact("Android Lint", VersionSource.GMAVEN, "com.android.tools.build:gradle", true);
        Artifact lintApi = new Artifact("com.android.tools.lint:lint-api", VersionSource.GMAVEN, null, false, 12, null);
        Artifact liveData = new Artifact("androidx.lifecycle:lifecycle-livedata-core", VersionSource.GMAVEN, null, false, 12, null);
        Artifact $this$_init__u24lambda_u243 = artifact4 = (material3 = new Artifact("Material 3", VersionSource.GMAVEN, "androidx.compose.material3:material3", false, 8, null));
        boolean bl = false;
        $this$_init__u24lambda_u243.setNext(new Artifact("com.google.android.material:material", VersionSource.GMAVEN, null, false, 12, null));
        Artifact material = artifact4;
        Artifact $this$_init__u24lambda_u244 = $this$_init__u24lambda_u243 = new Artifact("androidx.navigation:navigation-fragment", VersionSource.GMAVEN, null, false, 12, null);
        boolean bl2 = false;
        $this$_init__u24lambda_u244.setNext(composeNav);
        Artifact navigation = $this$_init__u24lambda_u243;
        Artifact recycler = new Artifact("AndroidX RecyclerView", VersionSource.GMAVEN, "androidx.recyclerview:recyclerview", false, 8, null);
        Artifact room = new Artifact("androidx.room:room-runtime", VersionSource.GMAVEN, null, false, 12, null);
        Artifact viewModel = new Artifact("androidx.lifecycle:lifecycle-viewmodel", VersionSource.GMAVEN, null, false, 12, null);
        Artifact windowSizeClass = new Artifact("androidx.compose.material3:material3-window-size-class", VersionSource.GMAVEN, null, false, 12, null);
        Artifact workManager = new Artifact("androidx.work:work-runtime", VersionSource.GMAVEN, null, false, 12, null);
        VersionLookup._init_$add(this, "agp", agp);
        VersionLookup._init_$add$1(this, "analytics", "firebase", "firebase bom", firebase);
        VersionLookup._init_$add(this, "firebase analytics", analytics);
        VersionLookup._init_$add$2(this, "compose", "compose bom", "jetpack compose", "jetpack compose bom", compose);
        VersionLookup._init_$add(this, "compose ui", compose);
        VersionLookup._init_$add$0(this, "compose navigation", "navigation compose", composeNav);
        VersionLookup._init_$add(this, "compose compiler", composeCompiler);
        VersionLookup._init_$add$0(this, "crashlytics", "firebase crashlytics", crashlytics);
        VersionLookup._init_$add$0(this, "proto datastore", "datastore", dataStore);
        VersionLookup._init_$add(this, "preferences datastore", prefDataStore);
        VersionLookup._init_$add(this, "desugar", desugarLibs);
        VersionLookup._init_$add(this, "espresso", espresso);
        VersionLookup._init_$add(this, "fragment", fragment);
        VersionLookup._init_$add(this, "hilt", hilt);
        VersionLookup._init_$add(this, "junit ext", junitExt);
        VersionLookup._init_$add(this, "lint", lint);
        VersionLookup._init_$add(this, "lint api", lintApi);
        VersionLookup._init_$add(this, "livedata", liveData);
        VersionLookup._init_$add(this, "material", material);
        VersionLookup._init_$add$0(this, "material3", "m3", material3);
        VersionLookup._init_$add(this, "navigation", navigation);
        VersionLookup._init_$add(this, "recyclerview", recycler);
        VersionLookup._init_$add(this, "room", room);
        VersionLookup._init_$add(this, "viewmodel", viewModel);
        VersionLookup._init_$add(this, "windowsizeclass", windowSizeClass);
        VersionLookup._init_$add(this, "workmanager", workManager);
        Artifact glide = new Artifact("com.github.bumptech.glide:glide", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact coil = new Artifact("io.coil-kt:coil", VersionSource.MAVEN_CENTRAL, null, false, 12, null);
        Artifact $this$_init__u24lambda_u245 = artifact3 = new Artifact("Kotlin Coroutines", VersionSource.MAVEN_CENTRAL, "org.jetbrains.kotlinx:kotlinx-coroutines-bom", false, 8, null);
        boolean bl3 = false;
        new Artifact("org.jetbrains.kotlinx:kotlinx-coroutines-android", VersionSource.MAVEN_CENTRAL, null, false, 12, null);
        Artifact coroutines = artifact3;
        Artifact gson = new Artifact("com.google.code.gson:gson", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact jsoup = new Artifact("org.jsoup:jsoup", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact junitBom = new Artifact("JUnit BOM", VersionSource.MAVEN_CENTRAL, "org.junit:junit-bom", false, 8, null);
        Artifact $this$_init__u24lambda_u246 = artifact2 = new Artifact("JUnit", VersionSource.MAVEN_CENTRAL, "junit:junit", false, 8, null);
        boolean bl4 = false;
        $this$_init__u24lambda_u246.setNext(junitBom);
        Artifact junit = artifact2;
        Artifact junit5 = new Artifact("JUnit5", VersionSource.MAVEN_CENTRAL, "org.junit.jupiter:junit-jupiter-engine", false, 8, null);
        Artifact kgp = new Artifact("the Kotlin Gradle Plugin", VersionSource.MAVEN_CENTRAL, "org.jetbrains.kotlin:kotlin-gradle-plugin", false, 8, null);
        Artifact kotlin = new Artifact("Kotlin", VersionSource.MAVEN_CENTRAL, "org.jetbrains.kotlin:kotlin-bom", true);
        Artifact ksp = new Artifact("KSP (Kotlin Symbol Processing))", VersionSource.GRADLE_PLUGIN, "com.google.devtools.ksp", false, 8, null);
        Artifact ktor = new Artifact("io.ktor:ktor-bom", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact mockito = new Artifact("org.mockito:mockito-core", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact okhttp = new Artifact("com.squareup.okhttp3:okhttp-bom", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact okio = new Artifact("com.squareup.okio:okio-bom", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact picasso = new Artifact("com.squareup.picasso:picasso", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact retrofit = new Artifact("com.squareup.retrofit2:retrofit", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact roboelectric = new Artifact("org.robolectric:robolectric", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact rxjava = new Artifact("io.reactivex:rxjava", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact timber = new Artifact("com.jakewharton.timber:timber", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact bouncycastle = new Artifact("org.bouncycastle:bcpkix-jdk15to18", VersionSource.MAVEN_CENTRAL, null, false, 8, null);
        Artifact ktfmt = new Artifact("Ktfmt Gradle plugin", VersionSource.GRADLE_PLUGIN, "com.ncorti.ktfmt.gradle", false, 8, null);
        Artifact protobuf = new Artifact("Protobuf", VersionSource.GRADLE_PLUGIN, "com.google.protobuf", false, 8, null);
        Artifact gms = new Artifact("GMS", VersionSource.GRADLE_PLUGIN, "com.google.gms.google-services", false, 8, null);
        VersionLookup._init_$add(this, "glide", glide);
        VersionLookup._init_$add(this, "coil", coil);
        VersionLookup._init_$add$2(this, "coroutines", "coroutines bom", "kotlin coroutines", "kotlin coroutines bom", coroutines);
        VersionLookup._init_$add(this, "gson", gson);
        VersionLookup._init_$add(this, "jsoup", jsoup);
        VersionLookup._init_$add(this, "junit", junit);
        VersionLookup._init_$add(this, "junit bom", junitBom);
        VersionLookup._init_$add(this, "junit5", junit5);
        VersionLookup._init_$add(this, "kgp", kgp);
        VersionLookup._init_$add(this, "koin", new Artifact("io.insert-koin:koin-android", VersionSource.MAVEN_CENTRAL, null, false, 12, null));
        VersionLookup._init_$add$2(this, "kotlin", "kotlin language", "kotlin compiler", "kotlin bom", kotlin);
        VersionLookup._init_$add$0(this, "ksp", "kotlin ksp", ksp);
        VersionLookup._init_$add$0(this, "ktor", "ktor bom", ktor);
        VersionLookup._init_$add(this, "mockito", mockito);
        VersionLookup._init_$add$0(this, "okhttp", "okhttp bom", okhttp);
        VersionLookup._init_$add$0(this, "okio", "okio bom", okio);
        VersionLookup._init_$add(this, "picasso", picasso);
        VersionLookup._init_$add(this, "retrofit", retrofit);
        VersionLookup._init_$add(this, "roboelectric", roboelectric);
        VersionLookup._init_$add(this, "rxjava", rxjava);
        VersionLookup._init_$add$0(this, "timber", "timber logging", timber);
        VersionLookup._init_$add(this, "ktfmt", ktfmt);
        VersionLookup._init_$add(this, "protobuf", protobuf);
        VersionLookup._init_$add$0(this, "gms", "google services", gms);
        VersionLookup._init_$add(this, "bouncycastle", bouncycastle);
        Artifact $this$_init__u24lambda_u247 = artifact = new Artifact("Android Studio", VersionSource.DL_GOOGLE_COM, "android-studio", false, 8, null);
        boolean bl5 = false;
        $this$_init__u24lambda_u247.setNext(agp);
        Artifact studio = artifact;
        VersionLookup._init_$add$1(this, "studio", "android studio", "this ide", studio);
        VersionLookup._init_$add$1(this, "gemini", "studio bot", "this software", studio);
        Artifact gradle = new Artifact("Gradle Build tool", VersionSource.GRADLE_ORG, null, false, 8, null);
        VersionLookup._init_$add$0(this, "gradle", "gradlew", gradle);
        Set<String> set = this.artifacts.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        this.artifactKeys = CollectionsKt.toList((Iterable)set);
    }

    @Nullable
    public final String lookupVersions(@NotNull String artifactName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        StringBuilder sb = new StringBuilder();
        Object object2 = artifactName;
        Regex regex = new Regex("(\\band\\b|\\bor\\b|,)");
        int n = 0;
        List names2 = regex.split((CharSequence)object2, n);
        for (String name : names2) {
            String lookup;
            if (this.doLookupVersions(((Object)StringsKt.trim((CharSequence)name)).toString()) == null) continue;
            if (((CharSequence)sb).length() > 0) {
                sb.append("  \n\n");
            }
            sb.append(lookup);
        }
        object2 = sb.toString();
        if (StringsKt.isBlank((CharSequence)object2)) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        return (String)object;
    }

    private final String doLookupVersions(String originalName) {
        boolean $this$none$iv2;
        block13: {
            boolean bl;
            CharSequence $this$none$iv2 = originalName;
            boolean $i$f$none = false;
            for (int j = 0; j < $this$none$iv2.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$none$iv2.charAt(j);
                boolean bl2 = false;
                if (!Character.isUpperCase(it)) continue;
                bl = false;
                break block13;
            }
            bl = $this$none$iv2 = true;
        }
        if (_Assertions.ENABLED && !$this$none$iv2) {
            String $i$f$none = "Assertion failed";
            throw new AssertionError((Object)$i$f$none);
        }
        String artifactName = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)originalName)).toString(), (CharSequence)" library"), (CharSequence)" artifact"), (CharSequence)" plugin");
        if (Intrinsics.areEqual((Object)artifactName, (Object)"androidx")) {
            return "There isn't a single AndroidX library. AndroidX uses semantic versioning, and different libraries typically have different versions. Try asking about a specific AndroidX library, such as `androidx.annotation:annotation`.";
        }
        Map<String, Artifact> map2 = this.getWellKnownArtifact(artifactName);
        if (map2.isEmpty()) {
            boolean bl = false;
            v1 = this.mavenArtifact(artifactName);
        } else {
            v1 = map2 = map2;
        }
        if (map2.isEmpty()) {
            boolean bl = false;
            return null;
        }
        Map<String, Artifact> libraries = map2;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Artifact> it : libraries.entrySet()) {
            Artifact library;
            String key = it.getKey();
            boolean first = true;
            for (Artifact curr = library = it.getValue(); curr != null; curr = curr.getNext()) {
                Versions version = this.lookupVersions(curr);
                if (version != null) {
                    if (((CharSequence)sb).length() > 0) {
                        sb.append("  \n");
                    }
                    if (first && !Intrinsics.areEqual((Object)this.cleanup(key), (Object)this.cleanup(artifactName))) {
                        if (((CharSequence)sb).length() > 0) {
                            sb.append("\n");
                        }
                        sb.append("\"" + artifactName + "\": Did you mean \"" + key + "\"?  \n");
                    }
                    sb.append(this.describe(curr, version));
                }
                first = false;
            }
        }
        CharSequence charSequence = sb.toString();
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            return null;
        }
        return (String)charSequence;
    }

    private final String cleanup(String $this$cleanup) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$cleanup, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    private final Map<String, Artifact> getWellKnownArtifact(String name) {
        Artifact match;
        Artifact artifact = this.artifacts.get(name);
        if (artifact == null && (artifact = this.artifacts.get(StringsKt.replace$default((String)name, (String)"-", (String)" ", (boolean)false, (int)4, null))) == null) {
            artifact = this.artifacts.get(StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null));
        }
        if ((match = artifact) != null) {
            Artifact it = match;
            boolean bl = false;
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)name, (Object)it));
        }
        int maxDistance = name.length() >= 4 ? 2 : 1;
        LinkedHashMap matches = new LinkedHashMap();
        for (Map.Entry entry : ((Map)this.artifacts).entrySet()) {
            boolean bl;
            Artifact artifact2;
            String matchWith;
            block7: {
                matchWith = (String)entry.getKey();
                artifact2 = (Artifact)entry.getValue();
                int distance = EditDistance.optimalAlignment((CharSequence)name, (CharSequence)matchWith, (boolean)true, (int)maxDistance);
                if (distance > maxDistance) continue;
                if (distance < maxDistance) {
                    matches.clear();
                    maxDistance = distance;
                }
                Map $this$any$iv = matches;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(it.getValue() == artifact2)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            ((Map)matches).put(matchWith, artifact2);
        }
        return matches;
    }

    private final Map<String, Artifact> mavenArtifact(String artifactName) {
        Component gradleModule;
        String library;
        Component component2;
        if (!StringsKt.contains$default((CharSequence)artifactName, (char)':', (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)artifactName, (String)"kotlin-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)artifactName, (String)"kotlinx-", (boolean)false, (int)2, null)) {
                return this.mavenArtifact("org.jetbrains.kotlin:" + artifactName);
            }
            if (StringsKt.startsWith$default((String)artifactName, (String)"firebase-", (boolean)false, (int)2, null)) {
                return this.mavenArtifact("com.google.firebase:" + artifactName);
            }
            if (StringsKt.startsWith$default((String)artifactName, (String)"google-api-services-", (boolean)false, (int)2, null)) {
                return this.mavenArtifact("com.google.apis:" + artifactName);
            }
        }
        if ((component2 = Component.Companion.tryParse(library = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)artifactName)).toString(), (char)' ', (char)':', (boolean)false, (int)4, null))) == null || (component2 = component2.getModule()) == null) {
            component2 = Module.Companion.tryParse(library);
        }
        if ((gradleModule = component2) == null) {
            CharSequence $this$count$iv = library;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == '.')) continue;
                ++count$iv;
            }
            if (count$iv >= 2 && this.isValidGroupIdString(library)) {
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)library, (Object)new Artifact(library, VersionSource.GRADLE_PLUGIN, library, false, 8, null)));
            }
            return MapsKt.emptyMap();
        }
        String coordinate = gradleModule.toString();
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)library, (Object)new Artifact(coordinate, VersionSource.GMAVEN_OR_MAVEN_CENTRAL, coordinate, false, 8, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidGroupIdString(String s) {
        if (StringsKt.isBlank((CharSequence)s)) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = s;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl2 = false;
            if (!(Character.isLetter(it) && Character.isLowerCase(it) || Character.isDigit(it) || it == '_' || it == '-')) {
                if (it != '.') return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final String describe(Artifact $this$describe, Versions versions) {
        boolean hasPreview;
        StringBuilder sb = new StringBuilder();
        String preview = versions.getPreview();
        boolean bl = hasPreview = preview != null && !Intrinsics.areEqual((Object)preview, (Object)versions.getStable());
        if (versions.getStable() != null) {
            this.append($this$describe, sb, versions.getStable(), hasPreview ? "stable" : null);
        }
        if (hasPreview) {
            if (((CharSequence)sb).length() > 0) {
                sb.append("  \n");
            }
            String string = preview;
            Intrinsics.checkNotNull((Object)string);
            this.append($this$describe, sb, string, "preview");
        }
        if (!((Collection)versions.getBom()).isEmpty()) {
            sb.append("  \nThe bill of materials points to:\n");
            sb.append(CollectionsKt.joinToString$default((Iterable)versions.getBom(), (CharSequence)"\n", null, null, (int)0, null, VersionLookup::describe$lambda$0, (int)30, null));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void append(Artifact $this$append, StringBuilder sb, String version, String type2) {
        sb.append("The latest ");
        if (type2 != null) {
            sb.append(type2).append(' ');
        }
        sb.append("version of ");
        sb.append($this$append.getDescription());
        if (!$this$append.getHideCoordinate() && !Intrinsics.areEqual((Object)$this$append.getCoordinate(), (Object)$this$append.getDescription()) && StringsKt.contains$default((CharSequence)$this$append.getCoordinate(), (char)':', (boolean)false, (int)2, null)) {
            sb.append(" (").append($this$append.getCoordinate()).append(")");
        }
        sb.append(" is ");
        sb.append(version);
        sb.append('.');
    }

    private final Versions attachBomContents(Versions $this$attachBomContents, Module module2, String prefix) {
        List<BomItem> extraVersions;
        String artifactId;
        if ($this$attachBomContents.getStable() != null && StringsKt.endsWith$default((String)(artifactId = module2.getName()), (String)"-bom", (boolean)false, (int)2, null) && !((Collection)(extraVersions = this.collectBomVersions(module2, artifactId, $this$attachBomContents.getStable(), prefix))).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = extraVersions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BomItem it = (BomItem)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getVersion(), (Object)$this$attachBomContents.getStable()))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Versions($this$attachBomContents.getStable(), $this$attachBomContents.getPreview(), extraVersions);
            }
        }
        return $this$attachBomContents;
    }

    private final Versions lookupVersions(Artifact artifact) {
        Versions versions;
        Module module2 = Module.Companion.tryParse(artifact.getCoordinate());
        if (module2 != null) {
            VersionSource source = artifact.getSource();
            if (source == VersionSource.GMAVEN || artifact.getSource() == VersionSource.GMAVEN_OR_MAVEN_CENTRAL) {
                Versions versions2;
                Versions versions3 = this.getVersionsFromGmaven(module2);
                Versions versions4 = versions2 = versions3 != null ? this.attachBomContents(versions3, module2, "https://dl.google.com/android/maven2") : null;
                if (versions2 != null) {
                    return versions2;
                }
            }
            if (artifact.getSource() == VersionSource.MAVEN_CENTRAL || artifact.getSource() == VersionSource.GMAVEN_OR_MAVEN_CENTRAL) {
                versions = this.getVersionsFromMavenCentral(module2);
                return versions != null ? this.attachBomContents(versions, module2, "https://repo1.maven.org/maven2") : null;
            }
        }
        if (artifact.getSource() == VersionSource.DL_GOOGLE_COM && Intrinsics.areEqual((Object)artifact.getCoordinate(), (Object)"android-studio")) {
            return this.getStudioVersions();
        }
        if (artifact.getSource() == VersionSource.SDK_MANAGER) {
            return this.getVersionFromSdkManager(artifact.getCoordinate());
        }
        if (artifact.getSource() == VersionSource.GRADLE_ORG) {
            return this.getVersionFromGradleOrg();
        }
        if (artifact.getSource() == VersionSource.GRADLE_PLUGIN) {
            String id = artifact.getCoordinate();
            if ((StringsKt.startsWith$default((String)id, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)id, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)id, (String)"com.google.", (boolean)false, (int)2, null)) && (versions = this.getVersionsFromGmaven(new Module(id, id + ".gradle.plugin"))) != null) {
                Versions it = versions;
                boolean bl = false;
                return it;
            }
            return this.getGradlePlugin(artifact.getCoordinate());
        }
        return null;
    }

    private final List<BomItem> collectBomVersions(Module module2, String artifactId, String version, String prefix) {
        List extraVersions;
        block17: {
            Document document2;
            extraVersions = new ArrayList();
            String groupPath = StringsKt.replace$default((String)module2.getGroup(), (char)'.', (char)'/', (boolean)false, (int)4, null);
            String url = prefix + "/" + groupPath + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom";
            String xml = VersionLookup.readUrlDataAsString$default(this, url, 0, 2, null);
            if (xml == null || (document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)false)) == null) break block17;
            Map properties = new LinkedHashMap();
            properties.put("project.version", version);
            properties.put("project.groupId", module2.getGroup());
            properties.put("project.artifactId", module2.getName());
            NodeList propertiesElements = document2.getElementsByTagName("properties");
            int n = propertiesElements.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Node node = propertiesElements.item(i2);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element propertiesElement = (Element)node;
                Iterator iterator = DomExtensions.iterator((Element)propertiesElement);
                while (iterator.hasNext()) {
                    Element property = (Element)iterator.next();
                    properties.put(property.getTagName(), property.getTextContent());
                }
            }
            NodeList dependencies = document2.getElementsByTagName("dependency");
            int n2 = dependencies.getLength();
            for (int i3 = 0; i3 < n2; ++i3) {
                Node node = dependencies.item(i3);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element dependency = (Element)node;
                String dependencyGroup = null;
                String dependencyArtifact = null;
                Iterator iterator = DomExtensions.iterator((Element)dependency);
                while (iterator.hasNext()) {
                    Element child = (Element)iterator.next();
                    String string = child.getTagName();
                    if (string == null) continue;
                    int n3 = -1;
                    switch (string.hashCode()) {
                        case 293428218: {
                            if (string.equals("groupId")) {
                                n3 = 1;
                            }
                            break;
                        }
                        case 240640653: {
                            if (string.equals("artifactId")) {
                                n3 = 2;
                            }
                            break;
                        }
                        case 351608024: {
                            if (string.equals("version")) {
                                n3 = 3;
                            }
                            break;
                        }
                    }
                    switch (n3) {
                        case 1: {
                            String string2 = child.getTextContent();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextContent(...)");
                            dependencyGroup = VersionLookup.collectBomVersions$evaluate(properties, string2);
                            break;
                        }
                        case 2: {
                            String string3 = child.getTextContent();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTextContent(...)");
                            dependencyArtifact = VersionLookup.collectBomVersions$evaluate(properties, string3);
                            break;
                        }
                        case 3: {
                            String string4 = child.getTextContent();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTextContent(...)");
                            String versionString = VersionLookup.collectBomVersions$evaluate(properties, string4);
                            if (dependencyGroup == null || dependencyArtifact == null) break;
                            extraVersions.add(new BomItem(dependencyGroup + ":" + dependencyArtifact, versionString));
                        }
                    }
                }
            }
        }
        return extraVersions;
    }

    @Nullable
    protected Versions getVersionsFromMavenCentral(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        LintIdeClient client2 = LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)this.project, null, (int)2, null);
        Dependency dependency = new Dependency(module2.getGroup(), module2.getName(), RichVersion.Companion.parse("+"), null, null, 24, null);
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group2 = string;
        GradleDetector.Companion.AvailableVersions availableVersions = GradleDetector.Companion.getMavenVersions$default((GradleDetector.Companion)GradleDetector.Companion, (LintClient)((LintClient)client2), (String)group2, (String)dependency.getName(), null, null, (boolean)false, null, (boolean)false, (int)0, (int)448, null);
        if (availableVersions == null) {
            return null;
        }
        GradleDetector.Companion.AvailableVersions availableVersions2 = availableVersions;
        Version version = availableVersions2.getLatestStable();
        return new Versions(version != null ? version.toString() : null, availableVersions2.getLatestPreview().toString(), null, 4, null);
    }

    @Nullable
    protected Versions getVersionsFromGmaven(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        GoogleMavenRepository repository2 = new GradleDetector().getGoogleMavenRepository((LintClient)LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)this.project, null, (int)2, null));
        Dependency d = new Dependency(module2.getGroup(), module2.getName(), RichVersion.Companion.parse("+"), null, null, 24, null);
        Version stable = repository2.findVersion(d, null, false);
        Version preview = repository2.findVersion(d, null, true);
        if (stable != null || preview != null) {
            Version version = stable;
            Version version2 = preview;
            return new Versions(version != null ? version.toString() : null, version2 != null ? version2.toString() : null, null, 4, null);
        }
        return null;
    }

    @NotNull
    protected Pair<AndroidSdkHandler, RepoManager> getSdkManager() {
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        getSdkLogger.1 logger = this.getSdkLogger();
        RepoManager sdkManager = sdkHandler.getRepoManager((ProgressIndicator)logger);
        sdkManager.loadSynchronously(TimeUnit.HOURS.toMillis(1L), (ProgressIndicator)logger, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        return new Pair((Object)sdkHandler, (Object)sdkManager);
    }

    private final getSdkLogger.1 getSdkLogger() {
        return new ProgressIndicatorAdapter(){};
    }

    @Nullable
    protected Versions getVersionFromSdkManager(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String stable = null;
        String preview = null;
        if (Intrinsics.areEqual((Object)prefix, (Object)"platforms")) {
            Object v2;
            DetailsTypes.PlatformDetailsType stableDetails;
            block6: {
                Object v1;
                List versions;
                block5: {
                    Comparator comparator = new Comparator(){

                        public final int compare(T a, T b) {
                            DetailsTypes.PlatformDetailsType it = (DetailsTypes.PlatformDetailsType)b;
                            boolean bl = false;
                            Comparable comparable = (Comparable)it.getAndroidVersion();
                            it = (DetailsTypes.PlatformDetailsType)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getAndroidVersion()));
                        }
                    };
                    versions = CollectionsKt.sortedWith((Iterable)this.getRemotePlatformVersions(), (Comparator)new Comparator(comparator){
                        final /* synthetic */ Comparator $this_thenByDescending;
                        {
                            this.$this_thenByDescending = $receiver;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenByDescending.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                DetailsTypes.PlatformDetailsType it = (DetailsTypes.PlatformDetailsType)b;
                                boolean bl = false;
                                Integer n2 = it.getExtensionLevel();
                                it = (DetailsTypes.PlatformDetailsType)a;
                                Comparable comparable = n2 != null ? (Comparable)n2 : (Comparable)Integer.valueOf(0);
                                bl = false;
                                Integer n3 = it.getExtensionLevel();
                                n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(n3 != null ? (Comparable)n3 : (Comparable)Integer.valueOf(0)));
                            }
                            return n;
                        }
                    });
                    Iterable $this$firstOrNull$iv = versions;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DetailsTypes.PlatformDetailsType it = (DetailsTypes.PlatformDetailsType)element$iv;
                        boolean bl = false;
                        CharSequence charSequence = it.getCodename();
                        boolean bl2 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
                        if (!bl2) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                stableDetails = v1;
                Iterable $this$firstOrNull$iv = versions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DetailsTypes.PlatformDetailsType it = (DetailsTypes.PlatformDetailsType)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getCodename();
                    if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            DetailsTypes.PlatformDetailsType previewDetails = v2;
            DetailsTypes.PlatformDetailsType platformDetailsType = stableDetails;
            stable = platformDetailsType != null ? this.describe(platformDetailsType) : null;
            preview = previewDetails != null && stableDetails != null && previewDetails.getApiLevel() >= stableDetails.getApiLevel() ? this.describe(previewDetails) : null;
        } else {
            AndroidSdkHandler sdkHandler = (AndroidSdkHandler)this.getSdkManager().component1();
            RemotePackage remotePackage = this.getRemotePackagesForPrefix(sdkHandler, prefix, false);
            stable = remotePackage != null && (remotePackage = remotePackage.getVersion()) != null ? remotePackage.toString() : null;
            RemotePackage remotePackage2 = this.getRemotePackagesForPrefix(sdkHandler, prefix, true);
            String string = remotePackage2 != null && (remotePackage2 = remotePackage2.getVersion()) != null ? remotePackage2.toString() : (preview = null);
        }
        if (stable != null || preview != null) {
            return new Versions(stable, preview, null, 4, null);
        }
        return null;
    }

    @Nullable
    protected RemotePackage getRemotePackagesForPrefix(@NotNull AndroidSdkHandler sdkHandler, @NotNull String prefix, boolean preview) {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return sdkHandler.getLatestRemotePackageForPrefix(prefix, null, preview, (ProgressIndicator)this.getSdkLogger());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<DetailsTypes.PlatformDetailsType> getRemotePlatformVersions() {
        void $this$mapNotNullTo$iv$iv;
        RepoManager sdkManager = (RepoManager)this.getSdkManager().component2();
        Collection packages = sdkManager.getPackages().getRemotePackages().values();
        Iterable $this$mapNotNull$iv = packages;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DetailsTypes.PlatformDetailsType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RemotePackage it = (RemotePackage)element$iv$iv;
            boolean bl2 = false;
            TypeDetails typeDetails = it.getTypeDetails();
            if ((typeDetails instanceof DetailsTypes.PlatformDetailsType ? (DetailsTypes.PlatformDetailsType)typeDetails : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String describe(DetailsTypes.PlatformDetailsType $this$describe) {
        String string = StringKt.nullize((String)$this$describe.getCodename(), (boolean)true);
        if (string == null) {
            Object object;
            DetailsTypes.PlatformDetailsType $this$describe_u24lambda_u241 = $this$describe;
            boolean bl = false;
            String version = $this$describe_u24lambda_u241.getApiLevelString();
            if ($this$describe_u24lambda_u241.getExtensionLevel() != null) {
                Intrinsics.checkNotNull((Object)version);
                object = StringsKt.removeSuffix((String)version, (CharSequence)"x") + " extension " + $this$describe_u24lambda_u241.getExtensionLevel();
            } else {
                object = version;
            }
            string = object;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        }
        return string;
    }

    @Nullable
    protected Versions getGradlePlugin(@NotNull String pluginId) {
        Document document2;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        String pluginPath = StringsKt.replace$default((String)pluginId, (String)".", (String)"/", (boolean)false, (int)4, null);
        String url = "https://plugins.gradle.org/m2/" + pluginPath + "/" + pluginId + ".gradle.plugin/maven-metadata.xml";
        String string = VersionLookup.readUrlDataAsString$default(this, url, 0, 2, null);
        if (string == null) {
            return null;
        }
        String updates = string;
        if (!StringsKt.startsWith$default((String)updates, (String)"{", (boolean)false, (int)2, null) && (document2 = XmlUtils.parseDocumentSilently((String)updates, (boolean)false)) != null) {
            NodeList versioningList = document2.getElementsByTagName("versioning");
            String preview = null;
            String stable = null;
            int n = versioningList.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Node node = versioningList.item(i2);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element versioning = (Element)node;
                Iterator iterator = DomExtensions.iterator((Element)versioning);
                while (iterator.hasNext()) {
                    Element child = (Element)iterator.next();
                    String string2 = child.getTagName();
                    if (Intrinsics.areEqual((Object)string2, (Object)"latest")) {
                        preview = child.getTextContent();
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string2, (Object)"release")) continue;
                    stable = child.getTextContent();
                }
            }
            if (preview != null || stable != null) {
                return new Versions(preview, stable, null, 4, null);
            }
        }
        return null;
    }

    @Nullable
    protected Versions getStudioVersions() {
        Document document2;
        String updates = VersionLookup.readUrlDataAsString$default(this, "https://dl.google.com/android/studio/patches/updates.xml", 0, 2, null);
        if (updates != null && (document2 = XmlUtils.parseDocumentSilently((String)updates, (boolean)false)) != null) {
            NodeList builds = document2.getElementsByTagName("build");
            String stable = null;
            String preview = null;
            int n = builds.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Element parent;
                Node node = builds.item(i2);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element build = (Element)node;
                Node node2 = build.getParentNode();
                if ((node2 instanceof Element ? (Element)node2 : null) == null) continue;
                parent = parent;
                String version = build.getAttribute("version");
                Intrinsics.checkNotNull((Object)version);
                if (!(((CharSequence)version).length() > 0)) continue;
                String status2 = parent.getAttribute("status");
                if (Intrinsics.areEqual((Object)status2, (Object)"eap")) {
                    preview = version;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)status2, (Object)"release")) continue;
                stable = version;
            }
            if (stable != null || preview != null) {
                return new Versions(stable, preview, null, 4, null);
            }
        }
        return null;
    }

    @Nullable
    protected Versions getVersionFromGradleOrg() {
        LintIdeClient client2 = LintIdeSupport.createClient$default((LintIdeSupport)LintIdeSupport.Companion.get(), (Project)this.project, null, (int)2, null);
        GradleDetector.Companion.AvailableVersions availableVersions = GradleDetector.Companion.getGradleVersion$default((GradleDetector.Companion)GradleDetector.Companion, (LintClient)((LintClient)client2), null, null, (boolean)false, (int)0, (int)30, null);
        if (availableVersions == null) {
            return null;
        }
        GradleDetector.Companion.AvailableVersions availableVersions2 = availableVersions;
        Version stable = availableVersions2.getLatestStable();
        Version preview = availableVersions2.getLatestPreview();
        return new Versions(String.valueOf(stable), Intrinsics.areEqual((Object)preview, (Object)stable) ? null : preview.toString(), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String readUrlDataAsString(@NotNull String query, int timeout) {
        Object object;
        URLConnection connection;
        block9: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            URL url = new URL(query);
            String string = url.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            connection = HttpConnectionUtils.openConnection((String)string);
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            if (connection.getInputStream() != null) break block9;
            String string2 = null;
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return string2;
        }
        try {
            InputStream inputStream;
            InputStream inputStream2 = inputStream;
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            object = byArray;
            Charset charset = Charsets.UTF_8;
            object = new String((byte[])object, charset);
        }
        catch (IOException iOException) {
            String string;
            try {
                string = null;
            }
            catch (Throwable throwable) {
                block10: {
                    HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
                    if (httpURLConnection == null) break block10;
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return string;
        }
        HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return object;
    }

    public static /* synthetic */ String readUrlDataAsString$default(VersionLookup versionLookup, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readUrlDataAsString");
        }
        if ((n2 & 2) != 0) {
            n = 4000;
        }
        return versionLookup.readUrlDataAsString(string, n);
    }

    private static final void _init_$add(VersionLookup this$0, String key, Artifact artifact) {
        ((Map)this$0.artifacts).put(key, artifact);
    }

    private static final void _init_$add$0(VersionLookup this$0, String key, String alias, Artifact artifact) {
        VersionLookup._init_$add(this$0, key, artifact);
        VersionLookup._init_$add(this$0, alias, artifact);
    }

    private static final void _init_$add$1(VersionLookup this$0, String key, String alias1, String alias2, Artifact artifact) {
        VersionLookup._init_$add$0(this$0, key, alias1, artifact);
        VersionLookup._init_$add(this$0, alias2, artifact);
    }

    private static final void _init_$add$2(VersionLookup this$0, String key, String alias1, String alias2, String alias3, Artifact artifact) {
        VersionLookup._init_$add$0(this$0, key, alias1, artifact);
        VersionLookup._init_$add$0(this$0, alias2, alias3, artifact);
    }

    private static final CharSequence describe$lambda$0(BomItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "* " + it.getCoordinate() + ": " + it.getVersion();
    }

    /*
     * WARNING - void declaration
     */
    private static final String collectBomVersions$evaluate(Map<String, String> properties, String expression) {
        String string;
        int start2 = StringsKt.indexOf$default((CharSequence)expression, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (start2 == -1) {
            return expression;
        }
        int end = 0;
        if (StringsKt.startsWith$default((String)expression, (String)"${", (int)start2, (boolean)false, (int)4, null)) {
            end = StringsKt.indexOf$default((CharSequence)expression, (char)'}', (int)(start2 + 2), (boolean)false, (int)4, null) + 1;
            String string2 = expression.substring(start2 + 2, end - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            int n;
            block5: {
                void $this$indexOfFirst$iv;
                CharSequence charSequence = expression;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!Character.isJavaIdentifierPart(it))) continue;
                    n = index$iv;
                    break block5;
                }
                n = -1;
            }
            int it = n;
            boolean bl = false;
            end = it == -1 ? it : expression.length();
            String string3 = expression.substring(start2 + 1, end);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String key = string;
        String string4 = properties.get(key);
        if (string4 == null) {
            string4 = key;
        }
        String substitution = string4;
        String string5 = StringsKt.take((String)expression, (int)start2);
        String string6 = expression.substring(end);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        return VersionLookup.collectBomVersions$evaluate(properties, string5 + substitution + string6);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/studio/ml/VersionLookup$Artifact;", "", "description", "", "source", "Lcom/android/studio/ml/VersionLookup$VersionSource;", "coordinate", "hideCoordinate", "", "<init>", "(Ljava/lang/String;Lcom/android/studio/ml/VersionLookup$VersionSource;Ljava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getSource", "()Lcom/android/studio/ml/VersionLookup$VersionSource;", "getHideCoordinate", "()Z", "getCoordinate", "next", "getNext", "()Lcom/android/studio/ml/VersionLookup$Artifact;", "setNext", "(Lcom/android/studio/ml/VersionLookup$Artifact;)V", "aiplugin.android"})
    private static final class Artifact {
        @NotNull
        private final String description;
        @NotNull
        private final VersionSource source;
        private final boolean hideCoordinate;
        @NotNull
        private final String coordinate;
        @Nullable
        private Artifact next;

        public Artifact(@NotNull String description, @NotNull VersionSource source, @Nullable String coordinate, boolean hideCoordinate) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            this.description = description;
            this.source = source;
            this.hideCoordinate = hideCoordinate;
            String string = coordinate;
            if (string == null) {
                string = this.description;
            }
            this.coordinate = string;
        }

        public /* synthetic */ Artifact(String string, VersionSource versionSource, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = string;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            this(string, versionSource, string2, bl);
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final VersionSource getSource() {
            return this.source;
        }

        public final boolean getHideCoordinate() {
            return this.hideCoordinate;
        }

        @NotNull
        public final String getCoordinate() {
            return this.coordinate;
        }

        @Nullable
        public final Artifact getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Artifact artifact) {
            this.next = artifact;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/studio/ml/VersionLookup$BomItem;", "", "coordinate", "", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCoordinate", "()Ljava/lang/String;", "getVersion", "aiplugin.android"})
    protected static final class BomItem {
        @NotNull
        private final String coordinate;
        @NotNull
        private final String version;

        public BomItem(@NotNull String coordinate, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.coordinate = coordinate;
            this.version = version;
        }

        @NotNull
        public final String getCoordinate() {
            return this.coordinate;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/studio/ml/VersionLookup$VersionSource;", "", "<init>", "(Ljava/lang/String;I)V", "GMAVEN", "MAVEN_CENTRAL", "GMAVEN_OR_MAVEN_CENTRAL", "DL_GOOGLE_COM", "SDK_MANAGER", "GRADLE_ORG", "GRADLE_PLUGIN", "aiplugin.android"})
    private static final class VersionSource
    extends Enum<VersionSource> {
        public static final /* enum */ VersionSource GMAVEN = new VersionSource();
        public static final /* enum */ VersionSource MAVEN_CENTRAL = new VersionSource();
        public static final /* enum */ VersionSource GMAVEN_OR_MAVEN_CENTRAL = new VersionSource();
        public static final /* enum */ VersionSource DL_GOOGLE_COM = new VersionSource();
        public static final /* enum */ VersionSource SDK_MANAGER = new VersionSource();
        public static final /* enum */ VersionSource GRADLE_ORG = new VersionSource();
        public static final /* enum */ VersionSource GRADLE_PLUGIN = new VersionSource();
        private static final /* synthetic */ VersionSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VersionSource[] values() {
            return (VersionSource[])$VALUES.clone();
        }

        public static VersionSource valueOf(String value) {
            return Enum.valueOf(VersionSource.class, value);
        }

        @NotNull
        public static EnumEntries<VersionSource> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = versionSourceArray = new VersionSource[]{VersionSource.GMAVEN, VersionSource.MAVEN_CENTRAL, VersionSource.GMAVEN_OR_MAVEN_CENTRAL, VersionSource.DL_GOOGLE_COM, VersionSource.SDK_MANAGER, VersionSource.GRADLE_ORG, VersionSource.GRADLE_PLUGIN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/studio/ml/VersionLookup$Versions;", "", "stable", "", "preview", "bom", "", "Lcom/android/studio/ml/VersionLookup$BomItem;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getStable", "()Ljava/lang/String;", "getPreview", "getBom", "()Ljava/util/List;", "aiplugin.android"})
    protected static final class Versions {
        @Nullable
        private final String stable;
        @Nullable
        private final String preview;
        @NotNull
        private final List<BomItem> bom;

        public Versions(@Nullable String stable, @Nullable String preview, @NotNull List<BomItem> bom) {
            Intrinsics.checkNotNullParameter(bom, (String)"bom");
            this.stable = stable;
            this.preview = preview;
            this.bom = bom;
        }

        public /* synthetic */ Versions(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, list);
        }

        @Nullable
        public final String getStable() {
            return this.stable;
        }

        @Nullable
        public final String getPreview() {
            return this.preview;
        }

        @NotNull
        public final List<BomItem> getBom() {
            return this.bom;
        }
    }
}

