/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ChatModelProvider;
import com.android.studio.ml.ChatModelProviderState;
import com.android.studio.ml.GeminiUserInfo;
import com.android.studio.ml.GeminiUserInfoProvider;
import com.android.studio.ml.Position;
import com.android.studio.ml.StudioPushNotificationTooltipCoordinateRegistry;
import com.android.studio.ml.StudioServerPushNotificationService;
import com.android.studio.ml.bot.ResponseMode;
import com.android.studio.ml.bot.configuration.StudioBotAppSettings;
import com.android.studio.ml.templates.modelproviders.ModelProviderConfigurable;
import com.android.studio.ml.templates.settings.PromptTemplatesConfigurable;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.StudioPushNotification;
import com.android.tools.idea.serverflags.protos.StudioPushNotificationList;
import com.google.protobuf.Message;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.GotItTooltip;
import java.awt.Component;
import java.awt.Point;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0017\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ=\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ.\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001d\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0002J'\u0010'\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010)H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/studio/ml/StudioServerPushNotificationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "schedule", "", "showNotifications", "clock", "Lkotlinx/datetime/Clock;", "showNotifications$aiplugin_android", "canShowNotification", "", "notificationIdentifier", "", "pointCoordinates", "Ljava/awt/Point;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "notificationDetails", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification;", "canShowNotification$aiplugin_android", "showNotification", "showGotItTooltip", "gotItTooltipSpec", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$GotItTooltipSpec;", "setGotItTooltipAction", "spec", "tooltip", "Lcom/intellij/ui/GotItTooltip;", "setGotItTooltipAction$aiplugin_android", "showBalloonNotification", "notificationSpec", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$NotificationSpec;", "areAllRequirementsFulfilled", "requirements", "", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$Requirement;", "areAllRequirementsFulfilled$aiplugin_android", "isAlreadyRendered", "isAlreadyRendered$aiplugin_android", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStudioServerPushNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioServerPushNotificationService.kt\ncom/android/studio/ml/StudioServerPushNotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n1869#2,2:457\n1869#2,2:459\n*S KotlinDebug\n*F\n+ 1 StudioServerPushNotificationService.kt\ncom/android/studio/ml/StudioServerPushNotificationService\n*L\n256#1:457,2\n287#1:459,2\n*E\n"})
public final class StudioServerPushNotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    public static final int $stable = 8;
    @TestOnly
    @Nullable
    private static Logger logForTesting;
    @NotNull
    private static final String STUDIO_BOT_NOTIFICATION_GROUP_ID = "Studio Bot Push Notifications";
    private static final long NOTIFICATION_DELAY_MINUTES = 2L;
    @NotNull
    private static final String STUDIO_BOT_NOTIFICATIONS_FLAGS_DIR_NAME = "studio_flags/studiobot_push_notifications";
    @NotNull
    private static final String STUDIO_BOT_NOTIFICATION_LIST_FLAG_NAME = "notification_flag_list";
    @NotNull
    private static final Map<StudioPushNotification.GotItTooltipSpec.PlacementDetails.ToolWindow, String> TOOLTIP_ID_MAP;
    @NotNull
    private static final Map<StudioPushNotification.NotificationSpec.PushNoficationType, NotificationType> NOTIFICATION_TYPE_MAP;
    @NotNull
    private static final Map<StudioPushNotification.GotItTooltipSpec.PlacementDetails.Position, Position> POSITION_MAP;
    @NotNull
    private static final Map<StudioPushNotification.Requirement.ModelProviderType, Function0<Boolean>> MODEL_PROVIDER_CONDITIONS;

    public StudioServerPushNotificationService(@NotNull Project project2, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.project = project2;
        this.scope = scope2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void schedule() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StudioServerPushNotificationService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)TimeUnit.MINUTES.toMillis(2L), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        StudioServerPushNotificationService.showNotifications$aiplugin_android$default(this.this$0, null, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void showNotifications$aiplugin_android(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        ServerFlagService serverFlagService = ServerFlagService.Companion.getInstance();
        StudioPushNotificationList studioPushNotificationList = StudioPushNotificationList.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)studioPushNotificationList, (String)"getDefaultInstance(...)");
        StudioPushNotificationList flagList = (StudioPushNotificationList)serverFlagService.getProtoOrNull("studio_flags/studiobot_push_notifications/notification_flag_list", (Message)studioPushNotificationList);
        if (flagList == null) {
            StudioServerPushNotificationService.Companion.getLogger().debug("Unable to extract the flag list.");
            return;
        }
        StudioPushNotification emptyStudioPushNotification = StudioPushNotification.getDefaultInstance();
        for (String notification : flagList.getNotificationsList()) {
            ToolWindow toolWindow;
            ServerFlagService serverFlagService2 = ServerFlagService.Companion.getInstance();
            String string = "studio_flags/studiobot_push_notifications/" + notification;
            Intrinsics.checkNotNull((Object)emptyStudioPushNotification);
            StudioPushNotification notificationDetails = (StudioPushNotification)serverFlagService2.getProtoOrNull(string, (Message)emptyStudioPushNotification);
            if (notificationDetails == null) {
                StudioServerPushNotificationService.Companion.getLogger().debug("Unable to find server side flag for notification: " + notification);
                continue;
            }
            String notificationIdentifier = Companion.getNotificationIdentifier$aiplugin_android(notificationDetails);
            CharSequence charSequence = notificationIdentifier;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                StudioServerPushNotificationService.Companion.getLogger().warn("Notification identifier is null");
                continue;
            }
            Point pointCoordinates = Companion.getPointCoordinates$aiplugin_android(notificationDetails, this.project);
            if (!this.canShowNotification$aiplugin_android(clock, notificationIdentifier, pointCoordinates, toolWindow = Companion.getToolWindow$aiplugin_android(notificationDetails, this.project), notificationDetails)) continue;
            this.showNotification(notificationIdentifier, pointCoordinates, toolWindow, notificationDetails);
            StudioBotAppSettings.Companion.getInstance().markNotificationAsShown(notificationIdentifier);
            return;
        }
    }

    public static /* synthetic */ void showNotifications$aiplugin_android$default(StudioServerPushNotificationService studioServerPushNotificationService, Clock clock, int n, Object object) {
        if ((n & 1) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        studioServerPushNotificationService.showNotifications$aiplugin_android(clock);
    }

    public final boolean canShowNotification$aiplugin_android(@NotNull Clock clock, @NotNull String notificationIdentifier, @Nullable Point pointCoordinates, @Nullable ToolWindow toolWindow, @Nullable StudioPushNotification notificationDetails) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)notificationIdentifier, (String)"notificationIdentifier");
        if (this.isAlreadyRendered$aiplugin_android(notificationIdentifier)) {
            return false;
        }
        StudioPushNotification studioPushNotification = notificationDetails;
        if (!this.areAllRequirementsFulfilled$aiplugin_android(clock, studioPushNotification != null ? studioPushNotification.getRequirementsList() : null)) {
            return false;
        }
        StudioPushNotification studioPushNotification2 = notificationDetails;
        boolean bl = studioPushNotification2 != null ? studioPushNotification2.hasGotItTooltipSpec() : false;
        if (bl) {
            if (pointCoordinates == null) {
                StudioServerPushNotificationService.Companion.getLogger().warn("Coordinates are null.");
                return false;
            }
            if (toolWindow == null) {
                StudioServerPushNotificationService.Companion.getLogger().warn("Unable to find tool-window with ID " + Companion.getToolWindowId$aiplugin_android(notificationDetails));
                return false;
            }
        } else {
            StudioPushNotification studioPushNotification3 = notificationDetails;
            boolean bl2 = studioPushNotification3 != null ? studioPushNotification3.hasNotificationSpec() : false;
            if (bl2) {
                StudioPushNotification.NotificationSpec $this$canShowNotification_u24lambda_u240 = notificationDetails.getNotificationSpec();
                boolean bl3 = false;
                CharSequence charSequence = $this$canShowNotification_u24lambda_u240.getTitle();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    StudioServerPushNotificationService.Companion.getLogger().warn("Notification title is null/blank.");
                    return false;
                }
                charSequence = $this$canShowNotification_u24lambda_u240.getDescription();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    StudioServerPushNotificationService.Companion.getLogger().warn("Notification description is null/blank.");
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean canShowNotification$aiplugin_android$default(StudioServerPushNotificationService studioServerPushNotificationService, Clock clock, String string, Point point, ToolWindow toolWindow, StudioPushNotification studioPushNotification, int n, Object object) {
        if ((n & 1) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        return studioServerPushNotificationService.canShowNotification$aiplugin_android(clock, string, point, toolWindow, studioPushNotification);
    }

    private final void showNotification(String notificationIdentifier, Point pointCoordinates, ToolWindow toolWindow, StudioPushNotification notificationDetails) {
        StudioPushNotification studioPushNotification = notificationDetails;
        boolean bl = studioPushNotification != null ? studioPushNotification.hasGotItTooltipSpec() : false;
        if (bl) {
            StudioPushNotification.GotItTooltipSpec gotItTooltipSpec = notificationDetails.getGotItTooltipSpec();
            Intrinsics.checkNotNullExpressionValue((Object)gotItTooltipSpec, (String)"getGotItTooltipSpec(...)");
            this.showGotItTooltip(notificationIdentifier, pointCoordinates, toolWindow, gotItTooltipSpec);
        } else {
            StudioPushNotification studioPushNotification2 = notificationDetails;
            boolean bl2 = studioPushNotification2 != null ? studioPushNotification2.hasNotificationSpec() : false;
            if (bl2) {
                StudioPushNotification.NotificationSpec notificationSpec = notificationDetails.getNotificationSpec();
                Intrinsics.checkNotNullExpressionValue((Object)notificationSpec, (String)"getNotificationSpec(...)");
                this.showBalloonNotification(notificationSpec);
            }
        }
    }

    private final void showGotItTooltip(String notificationIdentifier, Point pointCoordinates, ToolWindow toolWindow, StudioPushNotification.GotItTooltipSpec gotItTooltipSpec) {
        if (toolWindow == null || pointCoordinates == null) {
            return;
        }
        String string = gotItTooltipSpec.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        GotItTooltip gotItTooltip = new GotItTooltip(notificationIdentifier, string, null, 4, null).withPosition(Balloon.Position.above);
        String string2 = gotItTooltipSpec.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        GotItTooltip tooltip2 = gotItTooltip.withHeader(string2);
        this.setGotItTooltipAction$aiplugin_android(gotItTooltipSpec, tooltip2);
        Disposer.register((Disposable)toolWindow.getDisposable(), (Disposable)((Disposable)tooltip2));
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tooltip2, toolWindow, pointCoordinates, null){
            int label;
            final /* synthetic */ GotItTooltip $tooltip;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ Point $pointCoordinates;
            {
                this.$tooltip = $tooltip;
                this.$toolWindow = $toolWindow;
                this.$pointCoordinates = $pointCoordinates;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JComponent jComponent = this.$toolWindow.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                        this.$tooltip.show(jComponent, (arg_0, arg_1) -> showGotItTooltip.1.invokeSuspend$lambda$0(this.$pointCoordinates, arg_0, arg_1));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Point invokeSuspend$lambda$0(Point $pointCoordinates, Component component2, Balloon balloon2) {
                return new Point($pointCoordinates.x, $pointCoordinates.y);
            }
        }), (int)2, null);
    }

    public final void setGotItTooltipAction$aiplugin_android(@NotNull StudioPushNotification.GotItTooltipSpec spec, @NotNull GotItTooltip tooltip2) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)tooltip2, (String)"tooltip");
        StudioPushNotification.GotItTooltipSpec $this$setGotItTooltipAction_u24lambda_u240 = spec;
        boolean bl = false;
        CharSequence charSequence = $this$setGotItTooltipAction_u24lambda_u240.getAction().getTitle();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            StudioServerPushNotificationService.Companion.getLogger().warn("Skipping action because action title is missing.");
            return;
        }
        if ($this$setGotItTooltipAction_u24lambda_u240.getAction().hasBrowseAction()) {
            try {
                String string = $this$setGotItTooltipAction_u24lambda_u240.getAction().getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
                URL uRL = new URI($this$setGotItTooltipAction_u24lambda_u240.getAction().getBrowseAction().getUrl()).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                tooltip2.withBrowserLink(string, uRL);
                return;
            }
            catch (Exception exp) {
                StudioServerPushNotificationService.Companion.getLogger().warn("Unable to set the browser action", (Throwable)exp);
            }
        } else if ($this$setGotItTooltipAction_u24lambda_u240.getAction().hasOpenuiAction()) {
            if ($this$setGotItTooltipAction_u24lambda_u240.getAction().getOpenuiAction().getUiScreen() != StudioPushNotification.Actions.OpenUiAction.UiScreen.UI_SCREEN_UNKNOWN) {
                String string = $this$setGotItTooltipAction_u24lambda_u240.getAction().getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
                tooltip2.withLink(string, () -> StudioServerPushNotificationService.setGotItTooltipAction$lambda$0$0(tooltip2, $this$setGotItTooltipAction_u24lambda_u240, this));
            } else {
                StudioServerPushNotificationService.Companion.getLogger().warn("Unable to set the open ui action as the [UiScreen] is set to `UI_SCREEN_UNKNOWN`");
            }
        }
    }

    private final void showBalloonNotification(StudioPushNotification.NotificationSpec notificationSpec) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(STUDIO_BOT_NOTIFICATION_GROUP_ID);
        String string = notificationSpec.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        String string2 = notificationSpec.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        Notification notification = notificationGroup.createNotification(string, string2, Companion.getNotificationType$aiplugin_android(notificationSpec));
        List list = notificationSpec.getActionsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActionsList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StudioPushNotification.Actions action = (StudioPushNotification.Actions)element$iv;
            boolean bl = false;
            CharSequence charSequence = action.getTitle();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                StudioServerPushNotificationService.Companion.getLogger().warn("Skipping action because action title is missing.");
                continue;
            }
            if (action.hasBrowseAction()) {
                charSequence = action.getTitle();
                notification.addAction((AnAction)new NotificationAction(action, (String)charSequence){
                    final /* synthetic */ StudioPushNotification.Actions $action;
                    {
                        this.$action = $action;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(AnActionEvent e, Notification notification) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                        BrowserUtil.browse((String)this.$action.getBrowseAction().getUrl());
                        notification.expire();
                    }
                });
                continue;
            }
            if (!action.hasOpenuiAction()) continue;
            charSequence = action.getTitle();
            notification.addAction((AnAction)new NotificationAction(action, this, (String)charSequence){
                final /* synthetic */ StudioPushNotification.Actions $action;
                final /* synthetic */ StudioServerPushNotificationService this$0;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    StudioPushNotification.Actions.OpenUiAction.UiScreen uiScreen = this.$action.getOpenuiAction().getUiScreen();
                    Intrinsics.checkNotNullExpressionValue((Object)uiScreen, (String)"getUiScreen(...)");
                    com.android.studio.ml.StudioServerPushNotificationService$Companion.access$executeOpenUiActions(StudioServerPushNotificationService.Companion, uiScreen, this.this$0.getProject());
                    notification.expire();
                }
            });
        }
        notification.notify(this.project);
    }

    public final boolean areAllRequirementsFulfilled$aiplugin_android(@NotNull Clock clock, @Nullable List<StudioPushNotification.Requirement> requirements) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            List<StudioPushNotification.Requirement> list = requirements;
            if (list == null) break block5;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StudioPushNotification.Requirement requirement = (StudioPushNotification.Requirement)element$iv;
                boolean bl = false;
                if (requirement.hasModelProviderType()) {
                    if (MODEL_PROVIDER_CONDITIONS.get(requirement.getModelProviderType()) != null) {
                        Function0<Boolean> it;
                        boolean bl2 = false;
                        if (!((Boolean)it.invoke()).booleanValue()) {
                            StudioServerPushNotificationService.Companion.getLogger().debug("User doesn't have any " + requirement.getModelProviderType() + " provider configured");
                            return false;
                        }
                    }
                }
                if (!requirement.hasDateCondition()) continue;
                StudioPushNotification.Requirement.DateCondition dateCondition = requirement.getDateCondition();
                if ((dateCondition != null ? dateCondition.getShownAfter() : null) == null || clock.now().compareTo(Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)requirement.getDateCondition().getShownAfter().getSeconds(), (long)0L, (int)2, null)) >= 0) {
                    StudioPushNotification.Requirement.DateCondition dateCondition2 = requirement.getDateCondition();
                    if ((dateCondition2 != null ? dateCondition2.getShownBefore() : null) == null || clock.now().compareTo(Instant.Companion.fromEpochSeconds$default((Instant.Companion)Instant.Companion, (long)requirement.getDateCondition().getShownBefore().getSeconds(), (long)0L, (int)2, null)) <= 0) continue;
                }
                StudioServerPushNotificationService.Companion.getLogger().debug("Current timestamp must be between " + requirement.getDateCondition().getShownBefore() + " and " + requirement.getDateCondition().getShownAfter() + " for the notification to be shown.");
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean areAllRequirementsFulfilled$aiplugin_android$default(StudioServerPushNotificationService studioServerPushNotificationService, Clock clock, List list, int n, Object object) {
        if ((n & 1) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        return studioServerPushNotificationService.areAllRequirementsFulfilled$aiplugin_android(clock, list);
    }

    public final boolean isAlreadyRendered$aiplugin_android(@NotNull String notificationIdentifier) {
        Intrinsics.checkNotNullParameter((Object)notificationIdentifier, (String)"notificationIdentifier");
        StudioBotAppSettings studioBotSettings = StudioBotAppSettings.Companion.getInstance();
        if (studioBotSettings.isNotificationShown(notificationIdentifier)) {
            StudioServerPushNotificationService.Companion.getLogger().debug("Push notification with id: " + notificationIdentifier + " already shown once.");
            return true;
        }
        return false;
    }

    private static final Unit setGotItTooltipAction$lambda$0$0(GotItTooltip $tooltip, StudioPushNotification.GotItTooltipSpec $this_with, StudioServerPushNotificationService this$0) {
        $tooltip.hidePopup();
        StudioPushNotification.Actions.OpenUiAction.UiScreen uiScreen = $this_with.getAction().getOpenuiAction().getUiScreen();
        Intrinsics.checkNotNullExpressionValue((Object)uiScreen, (String)"getUiScreen(...)");
        StudioServerPushNotificationService.Companion.executeOpenUiActions(uiScreen, this$0.project);
        return Unit.INSTANCE;
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$0() {
        return false;
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$1() {
        return GeminiUserInfo.Companion.isFree((GeminiUserInfo)GeminiUserInfoProvider.Companion.current().getUserInfo().getValue());
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$2() {
        return GeminiUserInfo.Companion.isBusiness((GeminiUserInfo)GeminiUserInfoProvider.Companion.current().getUserInfo().getValue());
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$3() {
        return StudioServerPushNotificationService.Companion.checkIfWeHaveModelsFromGivenProvider("Google AI Studio");
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$4() {
        return StudioServerPushNotificationService.Companion.checkIfWeHaveModelsFromGivenProvider("Local");
    }

    private static final boolean MODEL_PROVIDER_CONDITIONS$lambda$5() {
        return StudioServerPushNotificationService.Companion.checkIfWeHaveModelsFromGivenProvider("anthropic") || StudioServerPushNotificationService.Companion.checkIfWeHaveModelsFromGivenProvider("openai");
    }

    static {
        TOOLTIP_ID_MAP = MapsKt.mapOf((Pair)TuplesKt.to((Object)StudioPushNotification.GotItTooltipSpec.PlacementDetails.ToolWindow.STUDIO_BOT_WINDOW, (Object)"StudioBot"));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StudioPushNotification.NotificationSpec.PushNoficationType.PUSH_NOTIFICATION_TYPE_UNKNOWN, (Object)NotificationType.INFORMATION), TuplesKt.to((Object)StudioPushNotification.NotificationSpec.PushNoficationType.INFORMATION, (Object)NotificationType.INFORMATION), TuplesKt.to((Object)StudioPushNotification.NotificationSpec.PushNoficationType.WARNING, (Object)NotificationType.WARNING), TuplesKt.to((Object)StudioPushNotification.NotificationSpec.PushNoficationType.ERROR, (Object)NotificationType.ERROR)};
        NOTIFICATION_TYPE_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)StudioPushNotification.GotItTooltipSpec.PlacementDetails.Position.POSITION_UNKNOWN, (Object)((Object)Position.POSITION_UNKNOWN)), TuplesKt.to((Object)StudioPushNotification.GotItTooltipSpec.PlacementDetails.Position.MODEL_PICKER, (Object)((Object)Position.MODEL_PICKER))};
        POSITION_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.MODEL_PROVIDER_TYPE_UNKNOWN, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$0), TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.FREE_TIER, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$1), TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.BUSINESS_TIER, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$2), TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.AI_STUDIO, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$3), TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.LOCAL_MODEL, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$4), TuplesKt.to((Object)StudioPushNotification.Requirement.ModelProviderType.REMOTE_MODEL, StudioServerPushNotificationService::MODEL_PROVIDER_CONDITIONS$lambda$5)};
        MODEL_PROVIDER_CONDITIONS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\rH\u0002J\u0013\u0010'\u001a\u0004\u0018\u00010\r*\u00020(H\u0000\u00a2\u0006\u0002\b)J\u001b\u0010*\u001a\u0004\u0018\u00010+*\u00020(2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b,J\u0013\u0010-\u001a\u0004\u0018\u00010\r*\u00020(H\u0000\u00a2\u0006\u0002\b.J\u001b\u0010/\u001a\u0004\u0018\u000100*\u00020(2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b1J\u0011\u00102\u001a\u00020\u0017*\u000203H\u0000\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u0002062\u0006\u0010#\u001a\u00020$R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/studio/ml/StudioServerPushNotificationService$Companion;", "", "<init>", "()V", "logForTesting", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogForTesting", "()Lcom/intellij/openapi/diagnostic/Logger;", "setLogForTesting", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "logger", "getLogger", "STUDIO_BOT_NOTIFICATION_GROUP_ID", "", "NOTIFICATION_DELAY_MINUTES", "", "STUDIO_BOT_NOTIFICATIONS_FLAGS_DIR_NAME", "STUDIO_BOT_NOTIFICATION_LIST_FLAG_NAME", "TOOLTIP_ID_MAP", "", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$GotItTooltipSpec$PlacementDetails$ToolWindow;", "NOTIFICATION_TYPE_MAP", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$NotificationSpec$PushNoficationType;", "Lcom/intellij/notification/NotificationType;", "POSITION_MAP", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$GotItTooltipSpec$PlacementDetails$Position;", "Lcom/android/studio/ml/Position;", "MODEL_PROVIDER_CONDITIONS", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$Requirement$ModelProviderType;", "Lkotlin/Function0;", "", "executeOpenUiActions", "", "uiScreen", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$Actions$OpenUiAction$UiScreen;", "project", "Lcom/intellij/openapi/project/Project;", "checkIfWeHaveModelsFromGivenProvider", "providerName", "getNotificationIdentifier", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification;", "getNotificationIdentifier$aiplugin_android", "getPointCoordinates", "Ljava/awt/Point;", "getPointCoordinates$aiplugin_android", "getToolWindowId", "getToolWindowId$aiplugin_android", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow$aiplugin_android", "getNotificationType", "Lcom/android/tools/idea/serverflags/protos/StudioPushNotification$NotificationSpec;", "getNotificationType$aiplugin_android", "getInstance", "Lcom/android/studio/ml/StudioServerPushNotificationService;", "aiplugin.android"})
    @SourceDebugExtension(value={"SMAP\nStudioServerPushNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StudioServerPushNotificationService.kt\ncom/android/studio/ml/StudioServerPushNotificationService$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,456:1\n24#2:457\n1#3:458\n30#4,2:459\n*S KotlinDebug\n*F\n+ 1 StudioServerPushNotificationService.kt\ncom/android/studio/ml/StudioServerPushNotificationService$Companion\n*L\n332#1:457\n453#1:459,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Logger getLogForTesting() {
            return logForTesting;
        }

        public final void setLogForTesting(@Nullable Logger logger) {
            logForTesting = logger;
        }

        private final Logger getLogger() {
            Logger logger = this.getLogForTesting();
            if (logger == null) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                logger = logger2;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            }
            return logger;
        }

        private final void executeOpenUiActions(StudioPushNotification.Actions.OpenUiAction.UiScreen uiScreen, Project project2) {
            switch (WhenMappings.$EnumSwitchMapping$0[uiScreen.ordinal()]) {
                case 1: {
                    ToolWindow toolWindow;
                    ToolWindow toolWindow2;
                    ToolWindow toolWindow3 = toolWindow2 = ToolWindowManager.Companion.getInstance(project2).getToolWindow("StudioBot");
                    if (toolWindow3 != null) {
                        toolWindow3.show();
                    }
                    if (!Intrinsics.areEqual((toolWindow = toolWindow2) != null && (toolWindow = toolWindow.getContentManager()) != null && (toolWindow = toolWindow.getSelectedContent()) != null ? toolWindow.getDisplayName() : null, (Object)ResponseMode.Chat.getDisplayName())) break;
                    toolWindow2.getContentManager().selectPreviousContent();
                    break;
                }
                case 2: {
                    ModelProviderConfigurable.Companion.openSettings$default(ModelProviderConfigurable.Companion, project2, null, 2, null);
                    break;
                }
                case 3: {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, PromptTemplatesConfigurable.class);
                }
            }
        }

        private final boolean checkIfWeHaveModelsFromGivenProvider(String providerName) {
            StateFlow<ChatModelProviderState> stateFlow;
            ChatModelProviderState provider;
            Object v0;
            block1: {
                Iterable iterable = ChatModelProvider.Companion.getAllProviders();
                for (Object t : iterable) {
                    ChatModelProvider it = (ChatModelProvider)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)providerName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            ChatModelProviderState chatModelProviderState = provider = (stateFlow = (StateFlow<ChatModelProviderState>)v0) != null && (stateFlow = stateFlow.getState()) != null ? (ChatModelProviderState)stateFlow.getValue() : null;
            Object object = provider instanceof ChatModelProviderState.Available ? (ChatModelProviderState.Available)provider : null;
            return object != null && (object = ((ChatModelProviderState.Available)object).getConfigs()) != null ? !((Collection)object).isEmpty() : false;
        }

        @Nullable
        public final String getNotificationIdentifier$aiplugin_android(@NotNull StudioPushNotification $this$getNotificationIdentifier) {
            Intrinsics.checkNotNullParameter((Object)$this$getNotificationIdentifier, (String)"<this>");
            return $this$getNotificationIdentifier.hasGotItTooltipSpec() ? $this$getNotificationIdentifier.getGotItTooltipSpec().getId() : ($this$getNotificationIdentifier.hasNotificationSpec() ? $this$getNotificationIdentifier.getNotificationSpec().getId() : null);
        }

        @Nullable
        public final Point getPointCoordinates$aiplugin_android(@NotNull StudioPushNotification $this$getPointCoordinates, @NotNull Project project2) {
            StudioPushNotification.GotItTooltipSpec gotItTooltipSpec;
            Intrinsics.checkNotNullParameter((Object)$this$getPointCoordinates, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Map map2 = POSITION_MAP;
            return StudioPushNotificationTooltipCoordinateRegistry.Companion.getInstance(project2).getCoordinates((Position)((Object)map2.get((gotItTooltipSpec = $this$getPointCoordinates.getGotItTooltipSpec()) != null && (gotItTooltipSpec = gotItTooltipSpec.getPlacementDetails()) != null ? gotItTooltipSpec.getPosition() : null)));
        }

        @Nullable
        public final String getToolWindowId$aiplugin_android(@NotNull StudioPushNotification $this$getToolWindowId) {
            Intrinsics.checkNotNullParameter((Object)$this$getToolWindowId, (String)"<this>");
            Map map2 = TOOLTIP_ID_MAP;
            StudioPushNotification.GotItTooltipSpec gotItTooltipSpec = $this$getToolWindowId.getGotItTooltipSpec();
            return (String)map2.get(gotItTooltipSpec != null && (gotItTooltipSpec = gotItTooltipSpec.getPlacementDetails()) != null ? gotItTooltipSpec.getToolWindow() : null);
        }

        @Nullable
        public final ToolWindow getToolWindow$aiplugin_android(@NotNull StudioPushNotification $this$getToolWindow, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)$this$getToolWindow, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            String string = this.getToolWindowId$aiplugin_android($this$getToolWindow);
            if (string == null) {
                return null;
            }
            String toolWindowId = string;
            return ToolWindowManager.Companion.getInstance(project2).getToolWindow(toolWindowId);
        }

        @NotNull
        public final NotificationType getNotificationType$aiplugin_android(@NotNull StudioPushNotification.NotificationSpec $this$getNotificationType) {
            Intrinsics.checkNotNullParameter((Object)$this$getNotificationType, (String)"<this>");
            NotificationType notificationType = (NotificationType)NOTIFICATION_TYPE_MAP.get($this$getNotificationType.getPushNotificationType());
            if (notificationType == null) {
                notificationType = NotificationType.INFORMATION;
            }
            return notificationType;
        }

        @NotNull
        public final StudioServerPushNotificationService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<StudioServerPushNotificationService> serviceClass$iv = StudioServerPushNotificationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (StudioServerPushNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StudioPushNotification.Actions.OpenUiAction.UiScreen.values().length];
                try {
                    nArray[StudioPushNotification.Actions.OpenUiAction.UiScreen.AGENT_WINDOW.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StudioPushNotification.Actions.OpenUiAction.UiScreen.MODEL_PROVIDER_SETTINGS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StudioPushNotification.Actions.OpenUiAction.UiScreen.PROMPT_LIBRARY_SETTINGS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

