/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.tables;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.feature.listlinks.OrderDirection;
import com.google.urlassistant.ui.models.BaseOverviewModel;
import com.google.urlassistant.ui.models.BaseTableColumnConfig;
import com.google.urlassistant.ui.models.SortInfo;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/urlassistant/ui/tables/HeaderCellRenderer;", "T", "Lcom/google/urlassistant/ui/models/BaseTableColumnConfig;", "Ljavax/swing/table/TableCellRenderer;", "tableHeader", "Ljavax/swing/table/JTableHeader;", "model", "Lcom/google/urlassistant/ui/models/BaseOverviewModel;", "<init>", "(Ljavax/swing/table/JTableHeader;Lcom/google/urlassistant/ui/models/BaseOverviewModel;)V", "defaultHeaderRenderer", "kotlin.jvm.PlatformType", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "url-assistant"})
public final class HeaderCellRenderer<T extends BaseTableColumnConfig>
implements TableCellRenderer {
    @NotNull
    private final JTableHeader tableHeader;
    @NotNull
    private final BaseOverviewModel<T> model;
    private final TableCellRenderer defaultHeaderRenderer;

    public HeaderCellRenderer(@NotNull JTableHeader tableHeader, @NotNull BaseOverviewModel<T> model2) {
        Intrinsics.checkNotNullParameter((Object)tableHeader, (String)"tableHeader");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        this.tableHeader = tableHeader;
        this.model = model2;
        this.defaultHeaderRenderer = this.tableHeader.getDefaultRenderer();
        this.model.addSortListener((Function0<Unit>)((Function0)() -> HeaderCellRenderer._init_$lambda$0(this)));
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Component component = this.defaultHeaderRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
        Component delegate = component;
        if (!(delegate instanceof JLabel)) {
            return delegate;
        }
        SortInfo sortInfo = this.model.getSortInfo();
        if (sortInfo != null && sortInfo.getColumnIndex() == table.convertColumnIndexToModel(column)) {
            JLabel jLabel = (JLabel)delegate;
            jLabel.setIcon(switch (WhenMappings.$EnumSwitchMapping$0[sortInfo.getDirection().ordinal()]) {
                case 1 -> UIManager.getIcon("Table.ascendingSortIcon");
                case 2 -> UIManager.getIcon("Table.descendingSortIcon");
                default -> throw new NoWhenBranchMatchedException();
            });
            ((JLabel)delegate).setHorizontalTextPosition(10);
        }
        return delegate;
    }

    private static final Unit _init_$lambda$0(HeaderCellRenderer this$0) {
        this$0.tableHeader.repaint();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrderDirection.values().length];
            try {
                nArray[OrderDirection.ASCEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrderDirection.DESCEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

