/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.db.DalApisConsentStore;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.ui.models.AppLinkColumnConfig;
import com.google.urlassistant.ui.models.BaseOverviewTableModel;
import com.google.urlassistant.ui.models.BaseTableColumnOption;
import com.intellij.openapi.project.Project;
import java.awt.EventQueue;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "Lcom/google/urlassistant/ui/models/BaseOverviewTableModel;", "Lcom/google/urlassistant/ui/models/AppLinkColumnConfig;", "linkInfos", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "value", "getLinkInfos", "()Ljava/util/List;", "setLinkInfos", "(Ljava/util/List;)V", "getRowCount", "", "getValueAt", "", "rowIndex", "columnIndex", "url-assistant"})
public final class AppLinkOverviewTableModel
extends BaseOverviewTableModel<AppLinkColumnConfig> {
    @NotNull
    private List<LinkInfo> linkInfos;

    public AppLinkOverviewTableModel(@NotNull List<LinkInfo> linkInfos, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(linkInfos, (String)"linkInfos");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((List)AppLinkColumnConfig.getEntries());
        BaseTableColumnOption baseTableColumnOption = this.getColumnOptionsMap().get(AppLinkColumnConfig.WEB_CHECKS);
        if (baseTableColumnOption != null) {
            baseTableColumnOption.setSelected(DalApisConsentStore.Companion.getInstance(project).getCanGetResults());
        }
        this.linkInfos = linkInfos;
    }

    @NotNull
    public final List<LinkInfo> getLinkInfos() {
        return this.linkInfos;
    }

    public final void setLinkInfos(@NotNull List<LinkInfo> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.linkInfos = value;
        EventQueue.invokeLater(() -> AppLinkOverviewTableModel._set_linkInfos_$lambda$0(this));
    }

    @Override
    public int getRowCount() {
        return this.linkInfos.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LinkInfo linkInfo = (LinkInfo)CollectionsKt.getOrNull(this.linkInfos, (int)rowIndex);
        if (linkInfo == null) {
            return null;
        }
        LinkInfo link = linkInfo;
        AppLinkColumnConfig appLinkColumnConfig = (AppLinkColumnConfig)this.getColumnConfig$url_assistant(columnIndex);
        if (appLinkColumnConfig == null) {
            return null;
        }
        AppLinkColumnConfig columnConfig = appLinkColumnConfig;
        return columnConfig.getGetLinkValue().invoke((Object)link);
    }

    private static final void _set_linkInfos_$lambda$0(AppLinkOverviewTableModel this$0) {
        this$0.fireTableDataChanged();
    }
}

