/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLink;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.UrlAssistColors;
import com.google.urlassistant.UrlAssistantTableRenderer;
import com.google.urlassistant.UrlPrefix;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.AddUrlDialog;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.facet.Facet;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.StyleContext;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@UiThread
public class UrlAssistantWindow
extends JPanel
implements UrlAssistantWindowBase {
    private final JBTable myJTable;
    private JBScrollPane myRootScrollPane;
    private JPanel myRootPanel;
    private JPanel myToolbarPanel;
    private JPanel myLowerPanel;
    private JPanel myUpperPanel;
    private JPanel myContentPanel;
    private JPanel myManifestJPanel;
    private JBTextField myTestUrlTextField;
    private JTextPane myCheckMappingResultTextPane;
    private JButton myOpenAndroidManifestButton;
    private JTextPane myPanelDescriptionLabel;
    private JBLabel myPreviewTitleLabel;
    private JTextPane myPreviewInstructionTextPane;
    private JBLabel mySmallTitleLabel;
    private JButton myAddAsTestUrlButton;
    private JBLabel myTestUrlAddedLabel;
    private JPanel myTestUrlPanel;
    private DeepLinksTableModel myTableModel;
    private final Project myProject;
    private XmlFile myManifestPsiFile;
    private ActivityData myCheckMappingResultActivity;
    @VisibleForTesting
    Editor myEditor;
    private final CardLayout myLowerPanelCardLayout;
    private final UrlAssistantTableRenderer myRenderer;
    private int myRefactorAnswer = -1;
    private boolean myShowOrder = false;
    private boolean myIsSelected = false;
    public static final int COLUMN_URL = 0;
    public static final int COLUMN_PATH = 1;
    public static final int COLUMN_ACTIVITY = 2;
    public static final int COLUMN_ORDER = 3;
    public static final String PORT = "port";
    public static final String MIMETYPE = "mimeType";
    private static final int TABLE_HEADER_HEIGHT = 22;
    private static final int TABLE_ROW_HEIGHT = 24;
    private static final String[] COLUMN_NAMES_WITH_ORDER = new String[]{"Host", "Path values", "Activity", "Order"};
    private static final String[] COLUMN_NAMES = new String[]{"Host", "Path values", "Activity"};
    private boolean isDisposed = false;

    private static Logger getLog() {
        return Logger.getInstance(UrlAssistantWindow.class);
    }

    public UrlAssistantWindow(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super(new BorderLayout());
        this.setupUI();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myRenderer = new UrlAssistantTableRenderer();
        this.myShowOrder = Order.isSupportedFor(this.myProject);
        this.setUpListeners();
        this.myJTable = new JBTable();
        this.setUpTable();
        this.myLowerPanel.setVisible(false);
        this.myRootPanel.setBackground(this.myContentPanel.getBackground());
        this.myPanelDescriptionLabel.setBackground(this.myContentPanel.getBackground());
        this.myCheckMappingResultTextPane.setBackground(this.myContentPanel.getBackground());
        this.myPreviewInstructionTextPane.setBackground(this.myContentPanel.getBackground());
        this.myPanelDescriptionLabel.setText(UrlAssistantBundle.message("url.assistant.panel.description", new Object[0]));
        this.myPreviewInstructionTextPane.setText(UrlAssistantBundle.message("url.assistant.preview.instruction", new Object[0]));
        this.myTestUrlTextField.getEmptyText().setText(UrlAssistantBundle.message("check.url.mapping.instruction", new Object[0]));
        this.myLowerPanelCardLayout = (CardLayout)this.myLowerPanel.getLayout();
        this.myLowerPanelCardLayout.last(this.myLowerPanel);
        this.mySmallTitleLabel.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.myRootScrollPane = new JBScrollPane((Component)this.myRootPanel);
        this.add((Component)this.myRootScrollPane);
        this.myContentPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    @NotNull
    public JBTable getTable() {
        return this.myJTable;
    }

    private void setUpListeners() {
        this.myTestUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String resultMessage;
                try {
                    UrlAssistantWindow.this.myCheckMappingResultActivity = UrlAssistUtils.findAssociatedActivity(UrlAssistantWindow.this.myTableModel.getDeepLinkData(), UrlAssistantWindow.this.myTestUrlTextField.getText());
                    resultMessage = UrlAssistantWindow.this.myCheckMappingResultActivity == null ? UrlAssistantBundle.message("check.url.mapping.fail", new Object[0]) : UrlAssistantBundle.message("check.url.mapping.result", UrlAssistantWindow.this.myCheckMappingResultActivity.getActivityAndModuleName());
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_CHECK_MAPPING_BUTTON, AppLinksAssistantEvent.EventState.OPENED, UrlAssistantWindow.this.myProject);
                }
                catch (MalformedURLException e) {
                    UrlAssistantWindow.this.myCheckMappingResultActivity = null;
                    resultMessage = UrlAssistantWindow.this.myTestUrlTextField.getText().isEmpty() ? "" : UrlAssistantBundle.message("check.url.mapping.malformed", new Object[0]);
                }
                UrlAssistantWindow.this.myTestUrlPanel.setVisible(UrlAssistantWindow.this.myCheckMappingResultActivity != null);
                if (UrlAssistantWindow.this.myCheckMappingResultActivity != null) {
                    if (ManifestUtils.isTestUrlAdded(UrlAssistantWindow.this.myCheckMappingResultActivity, UrlAssistantWindow.this.myTestUrlTextField.getText())) {
                        UrlAssistantWindow.this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.test.url.added", new Object[0]));
                        UrlAssistantWindow.this.myTestUrlAddedLabel.setForeground((Color)JBColor.GRAY);
                        ((CardLayout)UrlAssistantWindow.this.myTestUrlPanel.getLayout()).show(UrlAssistantWindow.this.myTestUrlPanel, "labelCard");
                    } else {
                        ((CardLayout)UrlAssistantWindow.this.myTestUrlPanel.getLayout()).show(UrlAssistantWindow.this.myTestUrlPanel, "buttonCard");
                    }
                }
                UrlAssistantWindow.this.myCheckMappingResultTextPane.setText(resultMessage);
            }
        });
        this.myAddAsTestUrlButton.addActionListener(e -> WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            XmlTag validationTag = ManifestUtils.addTestUrl(this.myCheckMappingResultActivity, this.myTestUrlTextField.getText());
            if (validationTag != null) {
                this.createEditorAndShowManifestIfNeeded(this.myCheckMappingResultActivity);
                this.updateAndroidManifestPreview(this.myCheckMappingResultActivity.getModule());
                this.setXmlTagSelected(validationTag);
                this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.test.url.added", new Object[0]));
                this.myTestUrlAddedLabel.setForeground((Color)JBColor.GRAY);
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
            } else {
                this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.add.test.url.fail", new Object[0]));
                this.myTestUrlAddedLabel.setForeground((Color)JBColor.RED);
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            }
            ((CardLayout)this.myTestUrlPanel.getLayout()).next(this.myTestUrlPanel);
        }));
        this.myCheckMappingResultTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                UrlAssistUtils.openActivityFile(this.myProject, this.myCheckMappingResultActivity);
            }
        });
        this.myOpenAndroidManifestButton.addActionListener(e -> {
            if (this.myManifestPsiFile != null) {
                UrlAssistUtils.openVirtualFile(this.myProject, this.myManifestPsiFile.getVirtualFile());
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_OPEN_ANDROID_MANIFEST_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            }
        });
    }

    public void updateAndroidManifestPreview(@NotNull Module module) {
        XmlFile androidManifestFile = ManifestUtils.getAndroidManifestPsi(module);
        if (androidManifestFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)androidManifestFile);
            if (this.myEditor != null) {
                this.myEditor.getDocument().setText((CharSequence)androidManifestFile.getText());
            }
        });
    }

    private void setRendererAndColumnWidth() {
        this.myJTable.getColumnModel().getColumn(1).setCellRenderer(this.myRenderer);
        this.myJTable.getColumnModel().getColumn(0).setCellRenderer(this.myRenderer);
        this.myJTable.getColumnModel().getColumn(2).setCellRenderer(this.myRenderer);
        if (this.myShowOrder) {
            this.myJTable.getColumnModel().getColumn(3).setCellRenderer(this.myRenderer);
            this.myJTable.getColumnModel().getColumn(0).setPreferredWidth(300);
            this.myJTable.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.myJTable.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.myJTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        }
    }

    private void setUpTable() {
        this.myTableModel = new DeepLinksTableModel(this.myShowOrder);
        this.myJTable.setModel((TableModel)this.myTableModel);
        this.myJTable.setRowHeight(24);
        this.myJTable.setFillsViewportHeight(true);
        this.myJTable.setShowGrid(false);
        this.myJTable.setSelectionMode(2);
        this.myJTable.setIntercellSpacing(new Dimension(0, 0));
        this.setRendererAndColumnWidth();
        this.myTableModel.addTableModelListener(e -> {
            this.myPreviewTitleLabel.setText(this.myJTable.isEmpty() ? " " : UrlAssistantBundle.message("url.assistant.preview.title", new Object[0]));
            this.myLowerPanel.setVisible(!this.myJTable.isEmpty());
        });
        this.myJTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.handleTableSelection();
            }
        });
        this.myJTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int clickedRow;
                boolean isFromKeyboard = e.getButton() == 0;
                JTable table = (JTable)e.getSource();
                Point p = e.getPoint();
                int n = !isFromKeyboard ? table.rowAtPoint(p) : (clickedRow = UrlAssistantWindow.this.myJTable.getSelectedRowCount() == 1 ? UrlAssistantWindow.this.myJTable.getSelectedRow() : -1);
                if (!isFromKeyboard && e.getClickCount() == 1) {
                    if (clickedRow == -1) {
                        UrlAssistantWindow.this.deselectAllRows();
                        UrlAssistantWindow.this.myLowerPanelCardLayout.last(UrlAssistantWindow.this.myLowerPanel);
                    } else if (e.isPopupTrigger()) {
                        UrlAssistantWindow.this.myJTable.setRowSelectionInterval(clickedRow, clickedRow);
                    }
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    UrlAssistantWindow.this.openEditDialog(clickedRow);
                }
                if (e.isPopupTrigger() && clickedRow >= 0) {
                    JBPopupMenu popup = new JBPopupMenu();
                    JBMenuItem createUrlItem = new JBMenuItem(UrlAssistantBundle.message("add.url.from.this.url", new Object[0]));
                    JBMenuItem editRunConfigItem = new JBMenuItem(UrlAssistantBundle.message("url.assistant.edit.run.configuration", new Object[0]));
                    popup.add((JMenuItem)createUrlItem);
                    createUrlItem.addActionListener(e1 -> {
                        final Order order = UrlAssistantWindow.this.myShowOrder ? (Order)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 3) : Order.DEFAULT_INSTANCE;
                        final UrlPrefix urlPrefix = (UrlPrefix)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 0);
                        final PathData pathData = (PathData)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 1);
                        Futures.addCallback(ManifestUtils.getActivityListFuture(UrlAssistantWindow.this.myProject, UrlAssistantWindow.this), (FutureCallback)new FutureCallback<List<Activity>>(){

                            public void onSuccess(List<Activity> activities) {
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    AddUrlDialog dialog = new AddUrlDialog(UrlAssistantWindow.this.myProject, UrlAssistantWindow.this, activities);
                                    dialog.setValue(order, urlPrefix, pathData, null, -1);
                                    UrlAssistantWindow.this.showAndTrack(dialog);
                                });
                            }

                            public void onFailure(@NotNull Throwable t) {
                                if (!(t instanceof CancellationException)) {
                                    UrlAssistantWindow.getLog().error(t);
                                }
                            }
                        }, (Executor)SameThreadExecutor.INSTANCE);
                    });
                    popup.add((JMenuItem)editRunConfigItem);
                    editRunConfigItem.addActionListener(e12 -> {
                        if (UrlAssistantWindow.this.myProject.isDisposed()) {
                            return;
                        }
                        EditConfigurationsDialog dialog = new EditConfigurationsDialog(UrlAssistantWindow.this.myProject);
                        dialog.show();
                    });
                    popup.setBorder((Border)new BevelBorder(0));
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        if (SystemInfo.isMac) {
            this.myJTable.getInputMap().put(KeyStroke.getKeyStroke("BACK_SPACE"), "Delete URL");
        }
        this.myJTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "Delete URL");
        this.myJTable.getActionMap().put("Delete URL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UrlAssistantWindow.this.deleteSelectedUrl();
            }
        });
        JTableHeader header = this.myJTable.getTableHeader();
        header.setDefaultRenderer(new HeaderRenderer());
        header.setResizingAllowed(true);
        header.setReorderingAllowed(false);
        header.setBackground((Color)JBColor.WHITE);
        header.setPreferredSize(new Dimension(0, 22));
        this.createToolbarButtons();
    }

    public void handleTableSelection() {
        if (this.myJTable.getSelectedRowCount() > 1 || this.myJTable.getSelectedRow() < 0) {
            this.myLowerPanelCardLayout.last(this.myLowerPanel);
            return;
        }
        this.createEditorAndShowManifestIfNeeded((ActivityData)this.myJTable.getValueAt(this.myJTable.getSelectedRow(), 2));
    }

    private void createEditorAndShowManifestIfNeeded(@NotNull ActivityData activityData) {
        this.myLowerPanel.setVisible(true);
        this.myLowerPanelCardLayout.first(this.myLowerPanel);
        XmlFile newManifestFile = ManifestUtils.getAndroidManifestPsi(activityData.getModule());
        if (newManifestFile != null) {
            if (this.myEditor == null || this.myEditor.isDisposed()) {
                EditorFactory editorFactory = EditorFactory.getInstance();
                this.myEditor = editorFactory.createEditor(editorFactory.createDocument((CharSequence)""), this.myProject, (FileType)XmlFileType.INSTANCE, true);
                this.myEditor.getSettings().setLineNumbersShown(false);
                this.myEditor.getSettings().setLineMarkerAreaShown(false);
                this.myEditor.getSettings().setRightMarginShown(false);
                this.myEditor.getSettings().setLineCursorWidth(0);
                this.myManifestJPanel.add((Component)this.myEditor.getComponent(), "Center");
            }
            if (this.myManifestPsiFile == null || !this.myManifestPsiFile.equals((Object)newManifestFile) || !this.myEditor.getDocument().getText().equals(this.myManifestPsiFile.getText())) {
                this.myManifestPsiFile = newManifestFile;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myEditor.getDocument().setText((CharSequence)this.myManifestPsiFile.getText());
                    this.myManifestJPanel.validate();
                });
            }
            if (activityData.getIntentFilterTag() != null) {
                this.setXmlTagSelected(activityData.getIntentFilterTag());
            }
        }
    }

    private void setXmlTagSelected(@NotNull XmlTag xmlTag) {
        int startOffset = xmlTag.getTextOffset();
        this.myEditor.getSelectionModel().setSelection(startOffset, startOffset + xmlTag.getTextLength());
        this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(startOffset), ScrollType.CENTER_UP);
    }

    private void deselectAllRows() {
        if (this.myJTable.getRowCount() > 0) {
            this.myJTable.getSelectionModel().removeSelectionInterval(0, this.myJTable.getRowCount() - 1);
        }
        this.myLowerPanelCardLayout.last(this.myLowerPanel);
    }

    private void openEditDialog() {
        this.openEditDialog(this.myJTable.getSelectedRow());
    }

    private void openEditDialog(final int selectedRow) {
        if (selectedRow < 0) {
            return;
        }
        Futures.addCallback(ManifestUtils.getActivityListFuture(this.myProject, this), (FutureCallback)new FutureCallback<List<Activity>>(){

            public void onSuccess(List<Activity> activities) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    AddUrlDialog dialog = new AddUrlDialog(UrlAssistantWindow.this.myProject, UrlAssistantWindow.this, activities);
                    dialog.setValue(UrlAssistantWindow.this.myTableModel.getRowAt(selectedRow), selectedRow);
                    dialog.show();
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_EDIT_DIALOG, AppLinksAssistantEvent.EventState.OPENED, UrlAssistantWindow.this.myProject);
                });
            }

            public void onFailure(@NotNull Throwable t) {
                if (!(t instanceof CancellationException)) {
                    UrlAssistantWindow.getLog().error(t);
                }
            }
        }, (Executor)SameThreadExecutor.INSTANCE);
    }

    private void showAndTrack(@NotNull DialogWrapper dialog) {
        dialog.show();
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
    }

    private void createToolbarButtons() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myJTable).disableUpDownActions();
        decorator.setToolbarPosition(ActionToolbarPosition.BOTTOM);
        decorator.setRemoveAction(anActionButton -> this.deleteSelectedUrl());
        decorator.setAddAction(anActionButton -> Futures.addCallback(ManifestUtils.getActivityListFuture(this.myProject, this), (FutureCallback)new FutureCallback<List<Activity>>(){

            public void onSuccess(List<Activity> activities) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    AddUrlDialog dialog = new AddUrlDialog(UrlAssistantWindow.this.myProject, UrlAssistantWindow.this, activities);
                    UrlAssistantWindow.this.showAndTrack(dialog);
                });
            }

            public void onFailure(@NotNull Throwable t) {
                if (!(t instanceof CancellationException)) {
                    UrlAssistantWindow.getLog().error(t);
                }
            }
        }, (Executor)SameThreadExecutor.INSTANCE));
        decorator.setEditAction(anActionButton -> this.openEditDialog());
        this.myToolbarPanel.add(decorator.createPanel());
    }

    @VisibleForTesting
    public void deleteSelectedUrl() {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            int[] selectedRows = this.getTable().getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.removeIntentFilter(selectedRows[i]);
                this.removeRowFromTable(selectedRows[i]);
            }
        });
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_DELETE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
    }

    private void removeIntentFilter(int selectedRow) {
        ActivityData activityData = this.myTableModel.getRowAt(selectedRow).getActivityData();
        if (activityData.getIntentFilterTag() != null) {
            activityData.getIntentFilterTag().delete();
        }
        this.updateAndroidManifestPreview(activityData.getModule());
    }

    private void removeRowFromTable(int selectedRow) {
        this.myTableModel.removeRow(selectedRow);
        this.deselectAllRows();
    }

    @NotNull
    public DeepLinksTableModel getTableModel() {
        return this.myTableModel;
    }

    public void showDeepLinksFromManifest() {
        this.myTableModel.setColumnCount(this.myShowOrder ? COLUMN_NAMES_WITH_ORDER.length : COLUMN_NAMES.length);
        this.setRendererAndColumnWidth();
        final int[] selectedRows = this.myJTable.getSelectedRows();
        this.myTableModel.clear();
        final DeepLinks deepLinks = new DeepLinks();
        ArrayList<ListenableFuture<DeepLinks>> deeplinksFutures = new ArrayList<ListenableFuture<DeepLinks>>();
        for (Module module : ProjectSystemUtil.getAndroidFacets((Project)this.myProject).stream().map(Facet::getModule).toList()) {
            deeplinksFutures.add(DeepLinkUtils.getDeeplinksFuture(module, this, this));
        }
        Futures.addCallback((ListenableFuture)Futures.successfulAsList(deeplinksFutures), (FutureCallback)new FutureCallback<List<DeepLinks>>(){

            public void onSuccess(List<DeepLinks> result) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (DeepLinks dls : result) {
                        deepLinks.addDeepLinks((Collection<DeepLink>)dls.getDeepLinkList());
                    }
                    UrlAssistantWindow.this.myTableModel.setDeepLinksData(deepLinks);
                    UrlAssistantWindow.this.myManifestPsiFile = null;
                    for (Object selectedRow : (Object)selectedRows) {
                        if (selectedRow < 0 || selectedRow >= UrlAssistantWindow.this.myJTable.getRowCount()) continue;
                        UrlAssistantWindow.this.myJTable.addRowSelectionInterval((int)selectedRow, (int)selectedRow);
                    }
                    UrlAssistantWindow.this.handleTableSelection();
                });
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)SameThreadExecutor.INSTANCE);
    }

    public boolean refactorIntentFilters(@NotNull Order order, @NotNull ActivityData activityData, @NotNull XmlTag activityTag, @NotNull List<UrlPrefix> urlList, @NotNull Set<PathData> pathDataSet, @NotNull List<DeepLink> deepLinkList) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myRefactorAnswer != 0 && !this.myIsSelected) {
            this.myRefactorAnswer = Messages.showYesNoDialog((String)UrlAssistantBundle.message("manifest.need.refactor", new Object[0]), (String)UrlAssistantBundle.message("manifest.need.refactor.title", new Object[0]), null);
        }
        if (this.myRefactorAnswer == 1) {
            return false;
        }
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> urlList.forEach(urlPrefix -> pathDataSet.forEach(pathData -> deepLinkList.add(new DeepLink(order, new ActivityData(activityData.getModule(), activityData.getActivityName(), UrlAssistUtils.createDeepLinkIntentFilter(order, activityTag, urlPrefix, pathData), null), (UrlPrefix)urlPrefix, (PathData)pathData)))));
        return true;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void selectNotify() {
        if (!this.myIsSelected) {
            this.myShowOrder = Order.isSupportedFor(this.myProject);
            this.showDeepLinksFromManifest();
            this.myIsSelected = true;
        }
    }

    @Override
    public void deselectNotify() {
        this.myIsSelected = false;
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myTableModel.clear();
            this.myManifestJPanel.removeAll();
        }
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.setAutoscrolls(false);
        this.myRootPanel.setBackground(new Color(-1513240));
        this.myRootPanel.setFocusCycleRoot(false);
        this.myRootPanel.setFocusTraversalPolicyProvider(false);
        this.myRootPanel.setFocusable(true);
        this.myRootPanel.setMinimumSize(new Dimension(900, 870));
        this.myRootPanel.setPreferredSize(new Dimension(900, 870));
        this.myRootPanel.setRequestFocusEnabled(true);
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(20, 30, 0, 30), -1, -1));
        this.myContentPanel.setFocusCycleRoot(true);
        this.myContentPanel.setFocusTraversalPolicyProvider(true);
        this.myContentPanel.setFocusable(true);
        this.myRootPanel.add((Component)this.myContentPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null, 0, false));
        this.myUpperPanel = new JPanel();
        this.myUpperPanel.setLayout((LayoutManager)new GridLayoutManager(15, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myUpperPanel.setFocusable(true);
        this.myContentPanel.add((Component)this.myUpperPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setFocusable(false);
        Font jBLabel1Font = this.getFont(null, -1, 14, jBLabel1.getFont());
        if (jBLabel1Font != null) {
            jBLabel1.setFont(jBLabel1Font);
        }
        jBLabel1.setText("URL Mapping");
        this.myUpperPanel.add((Component)jBLabel1, new GridConstraints(7, 0, 1, 3, 8, 0, 1, 0, null, null, null, 0, false));
        this.myToolbarPanel = new JPanel();
        this.myToolbarPanel.setLayout(new BorderLayout(0, 0));
        this.myToolbarPanel.setBackground(new Color(-1513240));
        this.myToolbarPanel.setFocusable(false);
        this.myUpperPanel.add((Component)this.myToolbarPanel, new GridConstraints(9, 0, 1, 3, 0, 3, 5, 0, new Dimension(-1, 150), new Dimension(-1, 230), null, 0, false));
        this.myPanelDescriptionLabel = new JTextPane();
        this.myPanelDescriptionLabel.setBackground(new Color(-1513240));
        this.myPanelDescriptionLabel.setContentType("text/html");
        this.myPanelDescriptionLabel.setEditable(false);
        this.myPanelDescriptionLabel.setFocusCycleRoot(false);
        this.myPanelDescriptionLabel.setFocusable(false);
        Font myPanelDescriptionLabelFont = UIManager.getFont("Label.font");
        if (myPanelDescriptionLabelFont != null) {
            this.myPanelDescriptionLabel.setFont(myPanelDescriptionLabelFont);
        }
        this.myPanelDescriptionLabel.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myPanelDescriptionLabel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myPanelDescriptionLabel.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.FALSE);
        this.myPanelDescriptionLabel.putClientProperty("html.disable", Boolean.TRUE);
        this.myUpperPanel.add((Component)this.myPanelDescriptionLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 1, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setFocusable(false);
        Font jBLabel2Font = this.getFont(null, -1, 14, jBLabel2.getFont());
        if (jBLabel2Font != null) {
            jBLabel2.setFont(jBLabel2Font);
        }
        jBLabel2.setText("Check URL Mapping");
        this.myUpperPanel.add((Component)jBLabel2, new GridConstraints(11, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTestUrlTextField = new JBTextField();
        this.myTestUrlTextField.setToolTipText("Please input your URL here including the scheme");
        this.myUpperPanel.add((Component)this.myTestUrlTextField, new GridConstraints(12, 0, 1, 3, 0, 1, 5, 3, new Dimension(200, -1), null, null, 0, false));
        this.myCheckMappingResultTextPane = new JTextPane();
        this.myCheckMappingResultTextPane.setAlignmentX(0.5f);
        this.myCheckMappingResultTextPane.setAlignmentY(0.0f);
        this.myCheckMappingResultTextPane.setBackground(new Color(-1513240));
        this.myCheckMappingResultTextPane.setContentType("text/html");
        this.myCheckMappingResultTextPane.setEditable(false);
        this.myCheckMappingResultTextPane.setFocusCycleRoot(false);
        this.myCheckMappingResultTextPane.setFocusable(false);
        Font myCheckMappingResultTextPaneFont = UIManager.getFont("Label.font");
        if (myCheckMappingResultTextPaneFont != null) {
            this.myCheckMappingResultTextPane.setFont(myCheckMappingResultTextPaneFont);
        }
        this.myCheckMappingResultTextPane.setMargin(new Insets(0, 0, 0, 0));
        this.myCheckMappingResultTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myUpperPanel.add((Component)this.myCheckMappingResultTextPane, new GridConstraints(13, 0, 1, 3, 0, 3, 4, 1, new Dimension(-1, 15), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myUpperPanel.add((Component)spacer1, new GridConstraints(6, 0, 1, 3, 0, 3, 1, 4, null, new Dimension(-1, 15), new Dimension(-1, 15), 0, false));
        Spacer spacer2 = new Spacer();
        this.myUpperPanel.add((Component)spacer2, new GridConstraints(10, 0, 1, 3, 0, 3, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15), 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setFocusable(false);
        jBLabel3.setIcon((Icon)new ImageIcon(this.getClass().getResource("/url_assistant/step_one.png")));
        jBLabel3.setIconTextGap(6);
        this.myUpperPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 2, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myUpperPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.mySmallTitleLabel = new JBLabel();
        this.mySmallTitleLabel.setAlignmentX(1.0f);
        this.mySmallTitleLabel.setAlignmentY(0.0f);
        this.mySmallTitleLabel.setFocusable(false);
        Font mySmallTitleLabelFont = this.getFont(null, -1, 12, this.mySmallTitleLabel.getFont());
        if (mySmallTitleLabelFont != null) {
            this.mySmallTitleLabel.setFont(mySmallTitleLabelFont);
        }
        this.mySmallTitleLabel.setForeground(new Color(-11513776));
        this.mySmallTitleLabel.setText("Android App Links Support");
        this.mySmallTitleLabel.setVerticalAlignment(3);
        this.mySmallTitleLabel.setVerticalTextPosition(3);
        this.myUpperPanel.add((Component)this.mySmallTitleLabel, new GridConstraints(0, 1, 1, 1, 10, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setAlignmentY(0.0f);
        jBLabel4.setFocusable(false);
        Font jBLabel4Font = this.getFont(null, -1, 22, jBLabel4.getFont());
        if (jBLabel4Font != null) {
            jBLabel4.setFont(jBLabel4Font);
        }
        jBLabel4.setText("URL-to-Activity mappings");
        jBLabel4.setVerticalAlignment(1);
        jBLabel4.setVerticalTextPosition(1);
        this.myUpperPanel.add((Component)jBLabel4, new GridConstraints(1, 1, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator1 = new JSeparator();
        Font separator1Font = this.getFont(null, 1, -1, separator1.getFont());
        if (separator1Font != null) {
            separator1.setFont(separator1Font);
        }
        this.myUpperPanel.add((Component)separator1, new GridConstraints(5, 0, 1, 3, 0, 1, 4, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myUpperPanel.add((Component)spacer4, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null, 0, false));
        Spacer spacer5 = new Spacer();
        this.myUpperPanel.add((Component)spacer5, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myUpperPanel.add((Component)spacer6, new GridConstraints(8, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 2), null, 0, false));
        this.myTestUrlPanel = new JPanel();
        this.myTestUrlPanel.setLayout(new CardLayout(0, 0));
        this.myTestUrlPanel.setVisible(false);
        this.myUpperPanel.add((Component)this.myTestUrlPanel, new GridConstraints(14, 0, 1, 3, 9, 0, 3, 1, null, null, null, 0, false));
        this.myTestUrlAddedLabel = new JBLabel();
        this.myTestUrlAddedLabel.setFocusable(false);
        this.myTestUrlAddedLabel.setForeground(new Color(-11513776));
        this.myTestUrlAddedLabel.setText("The URL was already added as a test URL.");
        this.myTestUrlPanel.add((Component)this.myTestUrlAddedLabel, "labelCard");
        this.myAddAsTestUrlButton = new JButton();
        this.myAddAsTestUrlButton.setMaximumSize(new Dimension(30, 31));
        this.myAddAsTestUrlButton.setMinimumSize(new Dimension(30, 31));
        this.myAddAsTestUrlButton.setPreferredSize(new Dimension(30, 31));
        this.myAddAsTestUrlButton.setText("Add as a test URL");
        this.myAddAsTestUrlButton.setVisible(false);
        this.myTestUrlPanel.add((Component)this.myAddAsTestUrlButton, "buttonCard");
        this.myPreviewTitleLabel = new JBLabel();
        this.myPreviewTitleLabel.setFocusable(false);
        Font myPreviewTitleLabelFont = this.getFont(null, -1, 14, this.myPreviewTitleLabel.getFont());
        if (myPreviewTitleLabelFont != null) {
            this.myPreviewTitleLabel.setFont(myPreviewTitleLabelFont);
        }
        this.myPreviewTitleLabel.setText("");
        this.myContentPanel.add((Component)this.myPreviewTitleLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myLowerPanel = new JPanel();
        this.myLowerPanel.setLayout(new CardLayout(0, 0));
        this.myContentPanel.add((Component)this.myLowerPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myLowerPanel.add((Component)panel1, "Card1");
        this.myManifestJPanel = new JPanel();
        this.myManifestJPanel.setLayout(new BorderLayout(0, 0));
        this.myManifestJPanel.setFocusable(false);
        this.myManifestJPanel.setToolTipText("This is the preview of the AndroidManifest file");
        panel1.add((Component)this.myManifestJPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 230), new Dimension(-1, 230), null, 0, false));
        this.myOpenAndroidManifestButton = new JButton();
        this.myOpenAndroidManifestButton.setDoubleBuffered(true);
        this.myOpenAndroidManifestButton.setText("Open AndroidManifest.xml");
        panel1.add((Component)this.myOpenAndroidManifestButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel2.setFocusable(false);
        this.myLowerPanel.add((Component)panel2, "Card2");
        this.myPreviewInstructionTextPane = new JTextPane();
        this.myPreviewInstructionTextPane.setContentType("text/html");
        this.myPreviewInstructionTextPane.setEditable(false);
        this.myPreviewInstructionTextPane.setFocusCycleRoot(false);
        this.myPreviewInstructionTextPane.setFocusable(false);
        Font myPreviewInstructionTextPaneFont = UIManager.getFont("Label.font");
        if (myPreviewInstructionTextPaneFont != null) {
            this.myPreviewInstructionTextPane.setFont(myPreviewInstructionTextPaneFont);
        }
        this.myPreviewInstructionTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myPreviewInstructionTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        panel2.add((Component)this.myPreviewInstructionTextPane, new GridConstraints(0, 0, 1, 1, 1, 1, 5, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myContentPanel.add((Component)spacer7, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null, 0, false));
        Spacer spacer8 = new Spacer();
        this.myContentPanel.add((Component)spacer8, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 7), new Dimension(-1, 7), 0, false));
        this.myOpenAndroidManifestButton.setNextFocusableComponent((Component)this.myTestUrlTextField);
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    protected static class DeepLinksTableModel
    extends DefaultTableModel {
        private DeepLinks myDeepLinksData = new DeepLinks();

        public DeepLinksTableModel(boolean showOrder) {
            super(showOrder ? COLUMN_NAMES_WITH_ORDER : COLUMN_NAMES, 0);
        }

        @Override
        public Object getValueAt(int row, int column) {
            DeepLink data = (DeepLink)this.myDeepLinksData.getDeepLinkList().get(row);
            switch (column) {
                case 0: {
                    return data.getUrl();
                }
                case 1: {
                    return data.getPath();
                }
                case 2: {
                    return data.getActivityData();
                }
                case 3: {
                    return data.getOrder();
                }
            }
            throw new ArrayIndexOutOfBoundsException("column:" + column + "is invalid.");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowCount() {
            if (this.myDeepLinksData == null) {
                return 0;
            }
            return this.myDeepLinksData.getDeepLinkList().size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @NotNull
        public DeepLink getRowAt(int row) {
            return (DeepLink)this.myDeepLinksData.getDeepLinkList().get(row);
        }

        public int addRow(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData path, @NotNull ActivityData activity, boolean supportOrder) {
            int index = this.myDeepLinksData.addLink(order, url, path, activity, supportOrder);
            this.fireTableDataChanged();
            return index;
        }

        @Override
        public void removeRow(int row) {
            this.myDeepLinksData.removeLinkAt(row);
            this.fireTableRowsDeleted(row, row);
        }

        public int updateRow(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData path, @NotNull ActivityData activity, boolean supportOrder, int row) {
            int index = this.myDeepLinksData.updateLink(order, url, path, activity, supportOrder, row);
            this.fireTableDataChanged();
            return index;
        }

        public void setDeepLinksData(@NotNull DeepLinks deepLinks) {
            this.myDeepLinksData = deepLinks;
            this.fireTableDataChanged();
        }

        public void clear() {
            this.myDeepLinksData.clear();
            this.fireTableDataChanged();
        }

        @NotNull
        public ImmutableList<DeepLink> getDeepLinkData() {
            return this.myDeepLinksData.getDeepLinkList();
        }
    }

    private static class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final int LEFT_MARGIN = 6;

        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value.toString());
            JBEmptyBorder margin = JBUI.Borders.emptyLeft((int)6);
            this.setBorder(new CompoundBorder(null, (Border)margin));
            return this;
        }
    }
}

