/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLink;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.logcat.AppLinksExecutionListener;
import com.google.urlassistant.logcat.AppLinksLogLineListener;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.containers.DisposableWrapperList;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import kotlin.Pair;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@UiThread
public class AppLinkTestingWindow
implements UrlAssistantWindowBase {
    private final Project myProject;
    private DeepLinks myDeepLinksData;
    private Module myModule = null;
    private JPanel myRootPanel;
    private JButton myLaunchTestButton;
    private JBTextField myUrlField;
    @VisibleForTesting
    JLabel myShortResultLabel;
    private JComboBox<Module> myModuleBox;
    private boolean isDisposed = false;
    private final ItemListener moduleItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (AppLinkTestingWindow.this.myModuleBox.getItemCount() > 0 && e.getStateChange() == 1) {
                String firstUrlString;
                AppLinkTestingWindow.this.myModule = (Module)AppLinkTestingWindow.this.myModuleBox.getSelectedItem();
                Optional<DeepLink> firstDeepLink = AppLinkTestingWindow.this.myDeepLinksData.getDeepLinkList().stream().filter(dl -> dl.getActivityData().getModule().equals((Object)AppLinkTestingWindow.this.myModule)).findFirst();
                String string = firstUrlString = firstDeepLink.isPresent() ? firstDeepLink.get().getUrl().toString() : "";
                if (!AppLinkTestingWindow.this.isDisposed && AppLinkTestingWindow.this.myUrlField.getText().isEmpty() && StringUtil.isNotEmpty((String)firstUrlString)) {
                    AppLinkTestingWindow.this.myUrlField.setText(firstUrlString);
                }
                Futures.addCallback(ManifestUtils.getAllActivities(new Module[]{AppLinkTestingWindow.this.myModule}, false, false, AppLinkTestingWindow.this), (FutureCallback)new FutureCallback<List<ActivityData>>(){

                    public void onSuccess(List<ActivityData> result) {
                        Object selectedItem = AppLinkTestingWindow.this.myActivitySelectionComboBoxModel.getSelectedItem();
                        if (selectedItem instanceof ActivitySelection) {
                            AppLinkTestingWindow.this.setupActivitySelectionComboBox(result, (ActivitySelection)selectedItem);
                        } else {
                            AppLinkTestingWindow.this.setupActivitySelectionComboBox(result, null);
                        }
                    }

                    public void onFailure(Throwable t) {
                        AppLinkTestingWindow.this.handleFailedFutureThrowable(t);
                    }
                }, (Executor)EdtExecutorService.getInstance());
            }
        }
    };
    private final DefaultComboBoxModel<Module> myComboBoxModel = new DefaultComboBoxModel();
    private final DisposableWrapperList<ModelUpdateListener> listeners = new DisposableWrapperList();
    private JBLabel myTitleLabel;
    private JTextPane myDescriptionTextPane;
    private JBLabel mySmallTitleLabel;
    private final DefaultComboBoxModel<ActivitySelection> myActivitySelectionComboBoxModel = new DefaultComboBoxModel();
    private JComboBox<ActivitySelection> myActivitySelectionComboBox;
    private static final JBColor GRAY_TEXT_COLOR = new JBColor((Color)Gray._80, (Color)Gray._156);
    private AppLinksLogLineListener myLogLineListener;
    private boolean myIsWindowActivated = false;
    @VisibleForTesting
    ActivityData myActivityData;

    private static Logger getLog() {
        return Logger.getInstance(AppLinkTestingWindow.class);
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    @Override
    public void dispose() {
        try {
            this.isDisposed = true;
            UrlAssistantWindowBase.super.dispose();
            if (this.myLogLineListener != null) {
                this.myLogLineListener.stopListening();
            }
            this.myLogLineListener = null;
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable t) {
            AppLinkTestingWindow.getLog().error(t);
        }
    }

    public AppLinkTestingWindow(@NotNull Project project, @NotNull Disposable parentDisposable) {
        this.setupUI();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        Color backgroundColor = this.myRootPanel.getBackground();
        this.myDescriptionTextPane.setText(UrlAssistantBundle.message("test.url.launch.url.description.text", new Object[0]));
        this.myDescriptionTextPane.setBackground(backgroundColor);
        this.myShortResultLabel.setBackground(backgroundColor);
        this.myShortResultLabel.setVisible(false);
        this.mySmallTitleLabel.setForeground((Color)GRAY_TEXT_COLOR);
        this.myUrlField.getEmptyText().setText(UrlAssistantBundle.message("test.url.launch.url.field.hint", new Object[0]));
        this.myModuleBox.addItemListener(this.moduleItemListener);
        this.myModuleBox.setModel(this.myComboBoxModel);
        this.myModuleBox.setEditable(false);
        this.myModuleBox.setVisible(false);
        if (this.myLogLineListener != null) {
            this.myLogLineListener.stopListening();
        } else {
            this.myLogLineListener = new AppLinksLogLineListener(this);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new AppLinksExecutionListener(this));
        }
        this.addActionHandler();
        this.myRootPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myActivitySelectionComboBox.setModel(this.myActivitySelectionComboBoxModel);
    }

    private void reloadDeepLinksData() {
        this.myComboBoxModel.removeAllElements();
        final Module lastSelectedModule = this.myModule;
        this.myDeepLinksData = new DeepLinks();
        ArrayList<ListenableFuture<@Nullable Pair<Module, DeepLinks>>> futures = new ArrayList<ListenableFuture<Pair<Module, DeepLinks>>>();
        ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>(ProjectSystemUtil.getAndroidFacets((Project)this.myProject));
        facets.sort(Comparator.comparing(facet -> facet.getModule().getName()));
        for (AndroidFacet facet2 : facets) {
            futures.add(DeepLinkUtils.getModuleWithActivityAndDeeplinksFuture(facet2.getModule(), null, this));
        }
        Futures.addCallback((ListenableFuture)Futures.successfulAsList(futures), (FutureCallback)new FutureCallback<List<Pair<Module, DeepLinks>>>(){

            public void onSuccess(List<@Nullable Pair<Module, DeepLinks>> result) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AppLinkTestingWindow.this.isDisposed) {
                        return;
                    }
                    for (Pair moduleWithDeepLinks : result) {
                        if (moduleWithDeepLinks == null) continue;
                        Module module = (Module)moduleWithDeepLinks.getFirst();
                        DeepLinks deepLinks = (DeepLinks)moduleWithDeepLinks.getSecond();
                        if (module != null) {
                            AppLinkTestingWindow.this.myComboBoxModel.addElement(module);
                        }
                        if (deepLinks == null) continue;
                        AppLinkTestingWindow.this.myDeepLinksData.addDeepLinks((Collection<DeepLink>)deepLinks.getDeepLinkList());
                    }
                    AppLinkTestingWindow.this.setupModuleComboBox(lastSelectedModule);
                });
            }

            public void onFailure(Throwable t) {
                AppLinkTestingWindow.this.handleFailedFutureThrowable(t);
            }
        }, (Executor)SameThreadExecutor.INSTANCE);
    }

    private void setupModuleComboBox(@Nullable Module lastSelectedModule) {
        int appModuleCnt = this.myComboBoxModel.getSize();
        this.myModuleBox.setVisible(false);
        this.myModuleBox.setSelectedItem(null);
        if (appModuleCnt == 0) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.no.app.module.found", new Object[0]), false);
            this.myModule = null;
        } else if (appModuleCnt == 1) {
            this.myModuleBox.setSelectedItem(this.myComboBoxModel.getElementAt(0));
        } else {
            this.myModuleBox.setVisible(true);
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_MODULE_SELECTION, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            if (lastSelectedModule == null) {
                this.myModuleBox.setSelectedItem(this.myComboBoxModel.getElementAt(0));
            } else {
                this.myModuleBox.setSelectedItem(lastSelectedModule);
            }
        }
    }

    private void setupActivitySelectionComboBox(List<ActivityData> activities, @Nullable ActivitySelection lastSelectedActivity) {
        this.myActivitySelectionComboBoxModel.removeAllElements();
        this.myActivitySelectionComboBoxModel.addElement(new AutomaticallyDeterminedActivity());
        for (ActivityData activity : activities) {
            String activityName = activity.getActivityName();
            PsiClass activityClass = activity.getActivityClass();
            if (activityClass != null && activityClass.getQualifiedName() != null) {
                activityName = activityClass.getQualifiedName();
            }
            ManuallySelectedActivity manualActivitySelection = new ManuallySelectedActivity(activityName);
            this.myActivitySelectionComboBoxModel.addElement(manualActivitySelection);
            if (lastSelectedActivity == null || !activityName.equals(lastSelectedActivity.toString()) && !activity.getActivityName().equals(lastSelectedActivity.toString())) continue;
            this.myActivitySelectionComboBoxModel.setSelectedItem(manualActivitySelection);
        }
        this.listeners.forEach(ModelUpdateListener::onChange);
    }

    private void addActionHandler() {
        this.myLaunchTestButton.addActionListener(e -> this.launchAppViaAppLinks(this.myUrlField.getText()));
        this.myUrlField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AppLinkTestingWindow.this.myLaunchTestButton.doClick();
                } else {
                    AppLinkTestingWindow.this.myShortResultLabel.setVisible(false);
                }
            }
        });
    }

    @VisibleForTesting
    boolean isQualifiedAppLinkUrl(@Nullable String url) {
        if (StringUtil.isEmpty((String)url)) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.launch.url.empty.url.error.message", new Object[0]), false);
            return false;
        }
        if (this.myModuleBox.isVisible()) {
            this.myModule = (Module)this.myModuleBox.getSelectedItem();
        }
        if (this.myModule == null) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.launch.url.null.module.error.message", new Object[0]), false);
            return false;
        }
        if (!this.shouldAutomaticallyDetermineActivity()) {
            if (UrlAssistUtils.isUrlValid(url)) {
                this.setShortResultLabel(UrlAssistantBundle.message("test.url.activity.manually.selected", this.myActivitySelectionComboBoxModel.getSelectedItem()), true);
                return true;
            }
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.malformed.url.error", new Object[0]), false);
            return false;
        }
        try {
            this.myActivityData = UrlAssistUtils.findAssociatedActivity(this.myDeepLinksData.getDeepLinkList(), url);
            if (this.myActivityData == null) {
                this.setShortResultLabel(UrlAssistantBundle.message("check.url.mapping.fail", new Object[0]), false);
                return false;
            }
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.check.url.mapping.result", this.myActivityData.getActivityAndModuleName()), true);
        }
        catch (MalformedURLException e) {
            this.setShortResultLabel(UrlAssistantBundle.message("test.url.malformed.url.error", new Object[0]), false);
            return false;
        }
        return true;
    }

    void launchAppViaAppLinks(@Nullable String url) {
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
        if (url == null || !this.isQualifiedAppLinkUrl(url)) {
            AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.FAILED, this.myProject);
            return;
        }
        Object activityComboBoxSelectedItem = this.myActivitySelectionComboBoxModel.getSelectedItem();
        String activityComboBoxSelection = activityComboBoxSelectedItem == null ? "" : activityComboBoxSelectedItem.toString();
        String activityToLaunch = this.shouldAutomaticallyDetermineActivity() ? this.myActivityData.getActivityName() : activityComboBoxSelection;
        this.myLogLineListener.startListening(this.myModule, activityToLaunch);
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        Object activitySpecification = this.shouldAutomaticallyDetermineActivity() ? "" : " (" + activityComboBoxSelection + ")";
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("URL " + url + (String)activitySpecification, AndroidRunConfigurationType.getInstance().getFactory());
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        if (this.shouldAutomaticallyDetermineActivity()) {
            configuration.setLaunchUrl(url);
        } else {
            configuration.setLaunchUrlToActivity(url, activityComboBoxSelection);
        }
        configuration.setModule(this.myModule);
        settings.storeInLocalWorkspace();
        runManager.addConfiguration(settings);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (com.intellij.execution.Executor)DefaultRunExecutor.getRunExecutorInstance());
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL_RUN_TEST_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
    }

    private boolean shouldAutomaticallyDetermineActivity() {
        Object selection = this.myActivitySelectionComboBoxModel.getSelectedItem();
        return selection == null || selection instanceof AutomaticallyDeterminedActivity;
    }

    public void setShortResultLabel(@NotNull String message, boolean success) {
        this.myShortResultLabel.setText(message);
        this.myShortResultLabel.setIcon(success ? StudioIcons.Common.SUCCESS : StudioIcons.Common.ERROR);
        this.myShortResultLabel.setVisible(true);
    }

    @Nullable
    @TestOnly
    Module getCurrentModule() {
        return this.myModule;
    }

    @Nullable
    @TestOnly
    Module getUserSelectedModule() {
        return (Module)this.myComboBoxModel.getSelectedItem();
    }

    @Nullable
    @TestOnly
    Module getModuleAt(int index) {
        return this.myComboBoxModel.getElementAt(index);
    }

    @TestOnly
    void setUserSelectedModule(@NotNull Module module) {
        this.myComboBoxModel.setSelectedItem(module);
    }

    @TestOnly
    int getModulesCount() {
        return this.myComboBoxModel.getSize();
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void selectNotify() {
        if (!this.myIsWindowActivated & !this.isDisposed) {
            this.reloadDeepLinksData();
            this.myIsWindowActivated = true;
        }
    }

    @Override
    public void deselectNotify() {
        this.myIsWindowActivated = false;
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this.getPanel();
    }

    public void addModelUpdateListener(Disposable parentDisposable, ModelUpdateListener listener) {
        this.listeners.add((Object)listener, parentDisposable);
    }

    @Nullable
    public AppLinksLogLineListener getListener() {
        return this.myLogLineListener;
    }

    private void handleFailedFutureThrowable(Throwable t) {
        if (!this.isDisposed && !(t instanceof CancellationException)) {
            AppLinkTestingWindow.getLog().error(t);
        }
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(12, 3, new Insets(20, 30, 0, 30), -1, -1));
        this.myRootPanel.setFocusCycleRoot(true);
        this.myRootPanel.setMinimumSize(new Dimension(-1, 297));
        this.myRootPanel.setPreferredSize(new Dimension(-1, 297));
        Spacer spacer1 = new Spacer();
        this.myRootPanel.add((Component)spacer1, new GridConstraints(2, 1, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.myShortResultLabel = new JLabel();
        this.myShortResultLabel.setFocusable(false);
        this.myRootPanel.add((Component)this.myShortResultLabel, new GridConstraints(10, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootPanel.add((Component)spacer2, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myRootPanel.add((Component)spacer3, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.myDescriptionTextPane = new JTextPane();
        this.myDescriptionTextPane.setContentType("text/html");
        this.myDescriptionTextPane.setEditable(false);
        this.myDescriptionTextPane.setEnabled(true);
        this.myDescriptionTextPane.setFocusCycleRoot(false);
        this.myDescriptionTextPane.setFocusable(false);
        Font myDescriptionTextPaneFont = UIManager.getFont("Label.font");
        if (myDescriptionTextPaneFont != null) {
            this.myDescriptionTextPane.setFont(myDescriptionTextPaneFont);
        }
        this.myDescriptionTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        this.myDescriptionTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myRootPanel.add((Component)this.myDescriptionTextPane, new GridConstraints(3, 0, 1, 3, 0, 1, 1, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myRootPanel.add((Component)spacer4, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.mySmallTitleLabel = new JBLabel();
        this.mySmallTitleLabel.setFocusable(false);
        Font mySmallTitleLabelFont = this.getFont(null, -1, 12, this.mySmallTitleLabel.getFont());
        if (mySmallTitleLabelFont != null) {
            this.mySmallTitleLabel.setFont(mySmallTitleLabelFont);
        }
        this.mySmallTitleLabel.setText("App Links Assistant");
        this.myRootPanel.add((Component)this.mySmallTitleLabel, new GridConstraints(0, 1, 1, 1, 10, 0, 0, 0, null, null, null, 0, false));
        this.myTitleLabel = new JBLabel();
        this.myTitleLabel.setFocusable(false);
        Font myTitleLabelFont = this.getFont(null, 0, 22, this.myTitleLabel.getFont());
        if (myTitleLabelFont != null) {
            this.myTitleLabel.setFont(myTitleLabelFont);
        }
        this.myTitleLabel.setText("Test on Device or Emulator");
        this.myRootPanel.add((Component)this.myTitleLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 4, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setFocusable(false);
        jBLabel1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/url_assistant/step_four.png")));
        this.myRootPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 2, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myLaunchTestButton = new JButton();
        this.myLaunchTestButton.setText("Run Test");
        this.myRootPanel.add((Component)this.myLaunchTestButton, new GridConstraints(9, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myModuleBox = new JComboBox();
        this.myModuleBox.setEnabled(true);
        this.myRootPanel.add(this.myModuleBox, new GridConstraints(5, 0, 1, 3, 8, 1, 2, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)panel1, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myUrlField = new JBTextField();
        this.myUrlField.setToolTipText("");
        panel1.add((Component)this.myUrlField, new GridConstraints(1, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setFocusable(false);
        Font jBLabel2Font = this.getFont(null, -1, 14, jBLabel2.getFont());
        if (jBLabel2Font != null) {
            jBLabel2.setFont(jBLabel2Font);
        }
        jBLabel2.setText("URL");
        panel1.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 0, 0, null, null, null, 0, false));
        this.myActivitySelectionComboBox = new JComboBox();
        panel1.add(this.myActivitySelectionComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText(UrlAssistantBundle.message("test.url.activity", new Object[0]));
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private static class AutomaticallyDeterminedActivity
    implements ActivitySelection {
        private AutomaticallyDeterminedActivity() {
        }

        @Override
        public String getAdbCommand() {
            return "";
        }

        public boolean equals(Object o) {
            return o == null || this.getClass() == o.getClass();
        }

        public int hashCode() {
            return UrlAssistantBundle.message("test.url.activity.determine.automatically", new Object[0]).hashCode();
        }

        public String toString() {
            return UrlAssistantBundle.message("test.url.activity.determine.automatically", new Object[0]);
        }
    }

    private static class ManuallySelectedActivity
    implements ActivitySelection {
        private final String name;

        ManuallySelectedActivity(String name) {
            this.name = name;
        }

        @Override
        public String getAdbCommand() {
            return "";
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManuallySelectedActivity activity = (ManuallySelectedActivity)o;
            return Objects.equals(this.name, activity.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static interface ActivitySelection {
        public String getAdbCommand();
    }

    static interface ModelUpdateListener {
        public void onChange();
    }
}

