/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.grpc;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.netty.GrpcSslContexts;
import com.android.tools.idea.io.grpc.netty.NettyChannelBuilder;
import com.android.tools.idea.io.netty.handler.ssl.SslContext;
import com.google.urlassistant.datalayer.grpc.FakeManagedChannelForTests;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b*\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "channelDelegate", "Lkotlin/Lazy;", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "channel", "getChannel$delegate", "(Lcom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService;)Ljava/lang/Object;", "getChannel", "()Lcom/android/tools/idea/io/grpc/ManagedChannel;", "createGrpcChannel", "dispose", "", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nDeeplinkAssistantChannelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeeplinkAssistantChannelService.kt\ncom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,96:1\n73#2:97\n*S KotlinDebug\n*F\n+ 1 DeeplinkAssistantChannelService.kt\ncom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService\n*L\n41#1:97\n*E\n"})
public final class DeeplinkAssistantChannelService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<ManagedChannel> channelDelegate = LazyKt.lazy(() -> DeeplinkAssistantChannelService.channelDelegate$lambda$0(this));
    @NotNull
    private static final Logger LOG;
    private static final String address;
    @VisibleForTesting
    @Nullable
    private static ManagedChannel channelForTests;

    @NotNull
    public final ManagedChannel getChannel() {
        Lazy<ManagedChannel> lazy = this.channelDelegate;
        return (ManagedChannel)lazy.getValue();
    }

    private static Object getChannel$delegate(DeeplinkAssistantChannelService deeplinkAssistantChannelService) {
        return deeplinkAssistantChannelService.channelDelegate;
    }

    private final ManagedChannel createGrpcChannel() {
        NettyChannelBuilder nettyChannelBuilder;
        SslContext sslContext = GrpcSslContexts.forClient().trustManager((TrustManager)ConfirmingTrustManager.createForStorage((String)CertificateManager.DEFAULT_PATH, (String)"changeit")).build();
        NettyChannelBuilder $this$createGrpcChannel_u24lambda_u240 = nettyChannelBuilder = NettyChannelBuilder.forTarget((String)address).sslContext(sslContext);
        boolean bl = false;
        $this$createGrpcChannel_u24lambda_u240.useTransportSecurity();
        $this$createGrpcChannel_u24lambda_u240.maxInboundMessageSize(0x100000);
        ManagedChannel newChannel = nettyChannelBuilder.build();
        LOG.info("Connected to deeplink assistant gRPC server at " + address);
        Intrinsics.checkNotNull((Object)newChannel);
        return newChannel;
    }

    public void dispose() {
        try {
            if (this.channelDelegate.isInitialized()) {
                this.getChannel().shutdownNow();
                this.getChannel().awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            LOG.info(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    private static final ManagedChannel channelDelegate$lambda$0(DeeplinkAssistantChannelService this$0) {
        ManagedChannel managedChannel;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            managedChannel = channelForTests;
            if (managedChannel == null) {
                managedChannel = new FakeManagedChannelForTests();
            }
        } else {
            managedChannel = this$0.createGrpcChannel();
        }
        return managedChannel;
    }

    static {
        Logger logger = Logger.getInstance(DeeplinkAssistantChannelService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        address = (String)StudioFlags.DEEPLINKS_GRPC_SERVER.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/google/urlassistant/datalayer/grpc/DeeplinkAssistantChannelService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "address", "", "kotlin.jvm.PlatformType", "channelForTests", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "getChannelForTests", "()Lcom/android/tools/idea/io/grpc/ManagedChannel;", "setChannelForTests", "(Lcom/android/tools/idea/io/grpc/ManagedChannel;)V", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ManagedChannel getChannelForTests() {
            return channelForTests;
        }

        public final void setChannelForTests(@Nullable ManagedChannel managedChannel) {
            channelForTests = managedChannel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

