/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.datalayer.feature;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.google.urlassistant.datalayer.feature.LinkInfoUtilsKt;
import com.google.urlassistant.datalayer.model.HostAndPort;
import com.google.urlassistant.datalayer.model.intentfilter.DataTagsConfig;
import com.google.urlassistant.datalayer.model.intentfilter.PathsConfig;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.PathType;
import com.google.urlassistant.datalayer.model.validation.singlelinkdatatagconfig.SingleLinkDataTagConfig;
import com.google.urlassistant.util.ApplicationIdService;
import com.google.urlassistant.util.IntentFilterUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Data;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0012\u0010\b\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a8\u0010\t\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0001\u001a\u001a\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0001\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a(\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u00180\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0081@\u00a2\u0006\u0002\u0010\u0019\u001a(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0081@\u00a2\u0006\u0002\u0010\u0019\u001a\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0001\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001d*\u00020\u001eH\u0003\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0005H\u0001\u001a\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00132\u0006\u0010#\u001a\u00020\u001eH\u0001\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u001eH\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"MAXIMUM_PORT_VALUE", "", "isWebScheme", "", "scheme", "", "isNullOrNumeric", "s", "isValidPort", "createInterpretedUrlPattern", "singleLinkDataTagConfig", "Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/SingleLinkDataTagConfig;", "host", "port", "pathType", "Lcom/google/urlassistant/datalayer/model/validation/singlelinkdatatagconfig/PathType;", "rawPath", "createInterpretedPathPattern", "getManifestDoms", "", "Lorg/jetbrains/android/dom/manifest/Manifest;", "project", "Lcom/intellij/openapi/project/Project;", "getApplicationIdManifestDomPairs", "Lkotlin/Pair;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getApplicationIdsToDomains", "", "getIntentFilters", "", "Lorg/jetbrains/android/dom/manifest/IntentFilter;", "manifests", "dataTags", "Lorg/jetbrains/android/dom/manifest/Data;", "getDataTagAttributesResolvingStringReferences", "intentFilter", "attributeName", "getHostPortPairsResolvingStringReferences", "Lcom/google/urlassistant/datalayer/model/HostAndPort;", "getDataTagsConfig", "Lcom/google/urlassistant/datalayer/model/intentfilter/DataTagsConfig;", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nLinkInfoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkInfoUtils.kt\ncom/google/urlassistant/datalayer/feature/LinkInfoUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1069#2,2:219\n1374#3:221\n1460#3,2:222\n1617#3,9:224\n1869#3:233\n1870#3:235\n1626#3:236\n1462#3,3:237\n2746#3,3:240\n1563#3:243\n1634#3,3:244\n1374#3:247\n1460#3,5:248\n1374#3:253\n1460#3,2:254\n1617#3,9:256\n1869#3:265\n1870#3:267\n1626#3:268\n1563#3:269\n1634#3,3:270\n1462#3,3:273\n1374#3:276\n1460#3,5:277\n1617#3,9:282\n1869#3:291\n1870#3:294\n1626#3:295\n1617#3,9:296\n1869#3:305\n1870#3:308\n1626#3:309\n774#3:310\n865#3,2:311\n1#4:234\n1#4:266\n1#4:292\n1#4:293\n1#4:306\n1#4:307\n*S KotlinDebug\n*F\n+ 1 LinkInfoUtils.kt\ncom/google/urlassistant/datalayer/feature/LinkInfoUtilsKt\n*L\n45#1:219,2\n111#1:221\n111#1:222,2\n111#1:224,9\n111#1:233\n111#1:235\n111#1:236\n111#1:237,3\n135#1:240,3\n139#1:243\n139#1:244,3\n149#1:247\n149#1:248,5\n119#1:253\n119#1:254,2\n121#1:256,9\n121#1:265\n121#1:267\n121#1:268\n121#1:269\n121#1:270,3\n119#1:273,3\n151#1:276\n151#1:277,5\n171#1:282,9\n171#1:291\n171#1:294\n171#1:295\n184#1:296,9\n184#1:305\n184#1:308\n184#1:309\n203#1:310\n203#1:311,2\n111#1:234\n121#1:266\n171#1:293\n184#1:307\n*E\n"})
public final class LinkInfoUtilsKt {
    private static final int MAXIMUM_PORT_VALUE = 65535;

    public static final boolean isWebScheme(@Nullable String scheme) {
        return Intrinsics.areEqual((Object)scheme, (Object)"http") || Intrinsics.areEqual((Object)scheme, (Object)"https");
    }

    public static final boolean isNullOrNumeric(@Nullable String s) {
        return s == null || StringsKt.toIntOrNull((String)s) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidPort(@Nullable String s) {
        if (s == null) return true;
        CharSequence $this$all$iv = s;
        boolean $i$f$all = false;
        for (int i = 0; i < $this$all$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(i);
            boolean bl = false;
            if (Character.isDigit(it)) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (0 > Integer.parseInt(s)) return false;
        if (Integer.parseInt(s) > 65535) return false;
        return true;
    }

    @WorkerThread
    @NotNull
    public static final String createInterpretedUrlPattern(@NotNull SingleLinkDataTagConfig singleLinkDataTagConfig) {
        String string;
        String scheme;
        Intrinsics.checkNotNullParameter((Object)singleLinkDataTagConfig, (String)"singleLinkDataTagConfig");
        String string2 = singleLinkDataTagConfig.getScheme();
        if (string2 == null) {
            string2 = scheme = "";
        }
        if ((string = singleLinkDataTagConfig.getRawHost()) == null) {
            string = "";
        }
        String host = string;
        String path = LinkInfoUtilsKt.createInterpretedPathPattern(singleLinkDataTagConfig.getPathType(), singleLinkDataTagConfig.getRawPath());
        return singleLinkDataTagConfig.getPort() == null ? scheme + "://" + host + path : scheme + "://" + host + ":" + singleLinkDataTagConfig.getPort() + path;
    }

    @WorkerThread
    @NotNull
    public static final String createInterpretedUrlPattern(@Nullable String scheme, @Nullable String host, @Nullable String port, @NotNull PathType pathType, @Nullable String rawPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)pathType), (String)"pathType");
        String path = LinkInfoUtilsKt.createInterpretedPathPattern(pathType, rawPath);
        if (port == null) {
            String string2;
            String string3 = scheme;
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = host) == null) {
                string2 = "";
            }
            string = string3 + "://" + string2 + path;
        } else {
            String string4;
            String string5 = scheme;
            if (string5 == null) {
                string5 = "";
            }
            if ((string4 = host) == null) {
                string4 = "";
            }
            string = string5 + "://" + string4 + ":" + port + path;
        }
        return string;
    }

    @WorkerThread
    @NotNull
    public static final String createInterpretedPathPattern(@NotNull PathType pathType, @Nullable String rawPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)pathType), (String)"pathType");
        return switch (WhenMappings.$EnumSwitchMapping$0[pathType.ordinal()]) {
            case 1 -> {
                CharSequence var2_2 = rawPath;
                if (var2_2 == null || var2_2.length() == 0) {
                    yield "/.*";
                }
                if (StringsKt.startsWith$default((String)rawPath, (String)"/", (boolean)false, (int)2, null)) {
                    yield rawPath;
                }
                yield "/" + rawPath;
            }
            case 2 -> {
                CharSequence var2_3 = rawPath;
                if (var2_3 == null || var2_3.length() == 0) {
                    yield "/.*";
                }
                if (StringsKt.startsWith$default((String)rawPath, (String)"/", (boolean)false, (int)2, null)) {
                    yield rawPath + ".*";
                }
                yield "/" + rawPath + ".*";
            }
            case 3, 4 -> {
                String var2_4 = rawPath;
                if (Intrinsics.areEqual((Object)var2_4, (Object)".*")) {
                    yield "/.*";
                }
                if (Intrinsics.areEqual((Object)var2_4, (Object)".")) {
                    yield "/";
                }
                CharSequence var3_6 = rawPath;
                if (var3_6 == null || var3_6.length() == 0) {
                    yield "/.*";
                }
                if (StringsKt.startsWith$default((String)rawPath, (String)"/", (boolean)false, (int)2, null)) {
                    yield rawPath;
                }
                yield "/" + rawPath;
            }
            case 5 -> {
                CharSequence var2_5 = rawPath;
                if (var2_5 == null || var2_5.length() == 0) {
                    yield "/.*";
                }
                yield "/.*" + rawPath;
            }
            case 6 -> "/.*";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public static final Set<Manifest> getManifestDoms(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$flatMap$iv = ProjectSystemUtil.getAndroidFacets((Project)project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            AndroidFacet facet = (AndroidFacet)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = SourceProvidersKt.getManifestFiles((AndroidFacet)facet);
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Manifest it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                VirtualFile it = (VirtualFile)element$iv$iv2;
                boolean bl3 = false;
                if ((Manifest)AndroidUtils.loadDomElement((Module)facet.getModule(), (VirtualFile)it, Manifest.class) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @WorkerThread
    @Nullable
    public static final Object getApplicationIdManifestDomPairs(@NotNull Project project, @NotNull Continuation<? super Set<? extends Pair<String, ? extends Manifest>>> $completion) {
        return CoroutinesKt.readAction(() -> LinkInfoUtilsKt.getApplicationIdManifestDomPairs$lambda$0(project), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    @Nullable
    public static final Object getApplicationIdsToDomains(@NotNull Project var0, @NotNull Continuation<? super Map<String, ? extends Set<String>>> $completion) {
        if (!($completion instanceof getApplicationIdsToDomains.1)) ** GOTO lbl-1000
        var23_2 = $completion;
        if ((var23_2.label & -2147483648) != 0) {
            var23_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LinkInfoUtilsKt.getApplicationIdsToDomains(null, (Continuation<? super Map<String, ? extends Set<String>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = new LinkedHashMap<K, V>();
                $continuation.L$0 = result;
                $continuation.label = 1;
                v0 = LinkInfoUtilsKt.getApplicationIdManifestDomPairs(project, (Continuation<? super Set<? extends Pair<String, ? extends Manifest>>>)$continuation);
                if (v0 == var24_4) {
                    return var24_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                result = (Map)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 3 sources

                for (Pair var4_7 : (Set)v0) {
                    appId = (String)var4_7.component1();
                    manifest = (Manifest)var4_7.component2();
                    v1 = (Set)result.get(appId);
                    if (v1 == null) {
                        v1 = new LinkedHashSet<E>();
                    }
                    setToModify = v1;
                    for (IntentFilter intentFilter : LinkInfoUtilsKt.getIntentFilters(SetsKt.setOf((Object)manifest))) {
                        dataTagsConfig = LinkInfoUtilsKt.getDataTagsConfig(intentFilter);
                        if (!dataTagsConfig.getHasDeeplink()) continue;
                        $this$none$iv = LinkInfoUtilsKt.getDataTagAttributesResolvingStringReferences(intentFilter, "scheme");
                        $i$f$none = false;
                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl38
                        v2 = true;
                        ** GOTO lbl45
lbl38:
                        // 2 sources

                        for (T element$iv : $this$none$iv) {
                            p0 = (String)element$iv;
                            $i$a$-none-LinkInfoUtilsKt$getApplicationIdsToDomains$2 = false;
                            if (!LinkInfoUtilsKt.isWebScheme(p0)) continue;
                            v2 = false;
                            ** GOTO lbl45
                        }
                        v2 = true;
lbl45:
                        // 3 sources

                        if (v2) continue;
                        $this$none$iv = LinkInfoUtilsKt.getDataTagAttributesResolvingStringReferences(intentFilter, "host");
                        var20_25 = setToModify;
                        $i$f$map = false;
                        var13_16 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var18_23 = (String)item$iv$iv;
                            var21_26 = destination$iv$iv;
                            $i$a$-map-LinkInfoUtilsKt$getApplicationIdsToDomains$3 = false;
                            v3 = host.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                            var21_26.add(v3);
                        }
                        var20_25.addAll((List)destination$iv$iv);
                    }
                    result.put(appId, setToModify);
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @NotNull
    public static final List<IntentFilter> getIntentFilters(@NotNull Set<? extends Manifest> manifests) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(manifests, (String)"manifests");
        Iterable $this$flatMap$iv = manifests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Manifest manifest = (Manifest)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)ActionsKt.runReadAction(() -> LinkInfoUtilsKt.getIntentFilters$lambda$0$0(manifest));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @WorkerThread
    private static final List<Data> dataTags(IntentFilter $this$dataTags) {
        Object object;
        try {
            object = ActionsKt.runReadAction(() -> LinkInfoUtilsKt.dataTags$lambda$0($this$dataTags));
            Intrinsics.checkNotNull((Object)object);
            object = (List)object;
        }
        catch (Throwable t) {
            Logger.getInstance((String)"LinkInfoUtils").warn(t);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @WorkerThread
    @NotNull
    public static final Set<String> getDataTagAttributesResolvingStringReferences(@NotNull IntentFilter intentFilter, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return CollectionsKt.toSet((Iterable)((Iterable)ActionsKt.runReadAction(() -> LinkInfoUtilsKt.getDataTagAttributesResolvingStringReferences$lambda$0(intentFilter, attributeName))));
    }

    @WorkerThread
    @NotNull
    public static final Set<HostAndPort> getHostPortPairsResolvingStringReferences(@NotNull IntentFilter intentFilter) {
        Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
        return CollectionsKt.toSet((Iterable)((Iterable)ActionsKt.runReadAction(() -> LinkInfoUtilsKt.getHostPortPairsResolvingStringReferences$lambda$0(intentFilter))));
    }

    @WorkerThread
    @NotNull
    public static final DataTagsConfig getDataTagsConfig(@NotNull IntentFilter intentFilter) {
        Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
        Set<String> schemes = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "scheme");
        Set<HostAndPort> hostPortPairs = LinkInfoUtilsKt.getHostPortPairsResolvingStringReferences(intentFilter);
        Set<String> pathExacts = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "path");
        Set<String> pathPrefixes = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "pathPrefix");
        Set<String> pathPatterns = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "pathPattern");
        Set<String> pathAdvancedPatterns = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "pathAdvancedPattern");
        Set<String> pathSuffixes = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "pathSuffix");
        PathsConfig pathsConfig = new PathsConfig(pathExacts, pathPrefixes, pathPatterns, pathAdvancedPatterns, pathSuffixes);
        Set<String> mimeTypes = LinkInfoUtilsKt.getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(intentFilter, "mimeType");
        return new DataTagsConfig(schemes, hostPortPairs, pathsConfig, mimeTypes);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getApplicationIdManifestDomPairs$lambda$0(Project $project) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = ProjectSystemUtil.getAndroidFacets((Project)$project);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            AndroidFacet facet = (AndroidFacet)element$iv$iv;
            boolean bl = false;
            if (ApplicationIdService.Companion.getInstance($project).getApplicationId(facet) == null) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = SourceProvidersKt.getManifestFiles((AndroidFacet)facet);
                boolean $i$f$mapNotNull = false;
                Iterable iterable3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Manifest manifest = $this$forEach$iv$iv$iv.iterator();
                while (manifest.hasNext()) {
                    Manifest it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = manifest.next();
                    boolean bl2 = false;
                    VirtualFile it = (VirtualFile)element$iv$iv2;
                    boolean bl3 = false;
                    if ((Manifest)AndroidUtils.loadDomElement((Module)facet.getModule(), (VirtualFile)it, Manifest.class) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String appId;
                    manifest = (Manifest)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(new Pair((Object)appId, (Object)it));
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final List getIntentFilters$lambda$0$0(Manifest $manifest) {
        Iterable list$iv$iv;
        Activity it;
        Iterable $this$flatMapTo$iv$iv;
        List list = $manifest.getApplication().getActivities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActivities(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Activity)element$iv$iv;
            boolean bl = false;
            List list2 = it.getIntentFilters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIntentFilters(...)");
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        List list3 = $manifest.getApplication().getActivityAliases();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getActivityAliases(...)");
        $this$flatMap$iv = list3;
        Collection collection2 = collection;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ActivityAlias)element$iv$iv;
            boolean bl = false;
            List list4 = it.getIntentFilters();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getIntentFilters(...)");
            list$iv$iv = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
    }

    private static final List dataTags$lambda$0(IntentFilter $this_dataTags) {
        return $this_dataTags.getDataElements();
    }

    /*
     * WARNING - void declaration
     */
    private static final List getDataTagAttributesResolvingStringReferences$lambda$0(IntentFilter $intentFilter, String $attributeName) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = LinkInfoUtilsKt.dataTags($intentFilter);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            block5: {
                XmlAttributeValue value;
                block7: {
                    Data data;
                    block6: {
                        XmlTag xmlTag;
                        block4: {
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl = false;
                            data = (Data)element$iv$iv;
                            boolean bl2 = false;
                            xmlTag = data.getXmlTag();
                            if (xmlTag != null && (xmlTag = xmlTag.getAttribute($attributeName, "http://schemas.android.com/apk/res/android")) != null) break block4;
                            object = null;
                            break block5;
                        }
                        XmlTag attribute = xmlTag;
                        if (attribute.getValueElement() != null) break block6;
                        object = null;
                        break block5;
                    }
                    XmlTag xmlTag = data.getXmlTag();
                    Intrinsics.checkNotNull((Object)xmlTag, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                    String string = value.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    ResourceItem resourceItem = IntentFilterUtils.INSTANCE.getResourceItem$url_assistant(xmlTag, string);
                    object = resourceItem;
                    if (object == null) break block7;
                    ResourceItem it = object;
                    boolean bl = false;
                    ResourceValue resourceValue = it.getResourceValue();
                    String string2 = resourceValue != null ? resourceValue.getValue() : null;
                    object = string2;
                    if (string2 != null) break block5;
                }
                String string = value.getValue();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            }
            if (object == null) continue;
            ResourceItem it$iv$iv = object;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getHostPortPairsResolvingStringReferences$lambda$0(IntentFilter $intentFilter) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = LinkInfoUtilsKt.dataTags($intentFilter);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            HostAndPort hostAndPort;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Data data = (Data)element$iv$iv;
            boolean bl2 = false;
            if (data.getXmlTag() == null) {
                hostAndPort = null;
            } else {
                String port;
                XmlTag xmlTag;
                XmlAttribute xmlAttribute = xmlTag.getAttribute("host", "http://schemas.android.com/apk/res/android");
                String host = xmlAttribute != null && (xmlAttribute = xmlAttribute.getValueElement()) != null ? xmlAttribute.getValue() : null;
                XmlAttribute xmlAttribute2 = xmlTag.getAttribute("port", "http://schemas.android.com/apk/res/android");
                String string = xmlAttribute2 != null && (xmlAttribute2 = xmlAttribute2.getValueElement()) != null ? xmlAttribute2.getValue() : (port = null);
                if (host == null && port == null) {
                    hostAndPort = null;
                } else {
                    String string2;
                    String string3;
                    String resolvedPort;
                    String resolvedHost;
                    if (host != null) {
                        String it;
                        boolean bl3 = false;
                        ResourceItem resourceItem = IntentFilterUtils.INSTANCE.getResourceItem$url_assistant(xmlTag, it);
                        v5 = resourceItem != null && (resourceItem = resourceItem.getResourceValue()) != null ? resourceItem.getValue() : null;
                    } else {
                        v5 = resolvedHost = null;
                    }
                    if (port != null) {
                        String it;
                        boolean bl4 = false;
                        ResourceItem resourceItem = IntentFilterUtils.INSTANCE.getResourceItem$url_assistant(xmlTag, it);
                        v7 = resourceItem != null && (resourceItem = resourceItem.getResourceValue()) != null ? resourceItem.getValue() : null;
                    } else {
                        v7 = resolvedPort = null;
                    }
                    if ((string3 = resolvedHost) == null) {
                        string3 = host;
                    }
                    if ((string2 = resolvedPort) == null) {
                        string2 = port;
                    }
                    hostAndPort = new HostAndPort(string3, string2);
                }
            }
            if (hostAndPort == null) continue;
            HostAndPort it$iv$iv = hostAndPort;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> getDataTagsConfig$getNonEmptyAttributesResolvingStringReferences(IntentFilter $intentFilter, String attributeName) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = LinkInfoUtilsKt.getDataTagAttributesResolvingStringReferences($intentFilter, attributeName);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PREFIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PATTERN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.ADVANCED_PATTERN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.SUFFIX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.EMPTY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

