/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.annotationprocessor.ProcessExpressions;
import android.databinding.tool.CompilerArguments;
import android.databinding.tool.Context;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ,\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0001J\u001d\u0010\u001b\u001a\u0004\u0018\u0001H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Landroid/databinding/tool/util/GenerationalClassUtil;", "", "inputDir", "Ljava/io/File;", "outputDir", "<init>", "(Ljava/io/File;Ljava/io/File;)V", "args", "Landroid/databinding/tool/CompilerArguments;", "(Landroid/databinding/tool/CompilerArguments;)V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGSON$annotations", "()V", "load", "", "T", "ext", "Landroid/databinding/tool/util/GenerationalClassUtil$ExtensionFilter;", "klass", "Ljava/lang/Class;", "write", "", "pkg", "", "item", "deserializeObject", "file", "(Ljava/io/File;)Ljava/lang/Object;", "Companion", "ExtensionFilter", "IgnoreSerialIdObjectInputStream", "db-compiler"})
@SourceDebugExtension(value={"SMAP\nGenerationalClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerationalClassUtil.kt\nandroid/databinding/tool/util/GenerationalClassUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class GenerationalClassUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File inputDir;
    @Nullable
    private final File outputDir;
    private final Gson GSON;

    public GenerationalClassUtil(@NotNull File inputDir, @Nullable File outputDir) {
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.GSON = new GsonBuilder().setLenient().disableHtmlEscaping().serializeNulls().enableComplexMapKeySerialization().create();
    }

    private GenerationalClassUtil(CompilerArguments args) {
        this(args.getDependencyArtifactsDir(), args.getAarOutDir());
    }

    private static /* synthetic */ void getGSON$annotations() {
    }

    @NotNull
    public final <T> List<T> load(@NotNull ExtensionFilter ext, @NotNull Class<T> klass) {
        Intrinsics.checkNotNullParameter((Object)((Object)ext), (String)"ext");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.inputDir)), arg_0 -> GenerationalClassUtil.load$lambda$0(ext, arg_0)), arg_0 -> GenerationalClassUtil.load$lambda$1(ext, this, klass, arg_0)));
    }

    public final /* synthetic */ <T> List<T> load(ExtensionFilter ext) {
        Intrinsics.checkNotNullParameter((Object)((Object)ext), (String)"ext");
        boolean $i$f$load = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.load(ext, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String pkg, @NotNull ExtensionFilter ext, @NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)((Object)ext), (String)"ext");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object[] objectArray = new Object[]{pkg, ext, this.outputDir};
        L.d("writing output file for %s, %s into %s", objectArray);
        try {
            Object[] objectArray2;
            Preconditions.checkNotNull(this.outputDir, "incremental out directory should be set to aar output directory.", new Object[0]);
            File file = this.outputDir;
            Intrinsics.checkNotNull((Object)file);
            file.mkdirs();
            File outFile = new File(this.outputDir, pkg + ext.getExt());
            if (ext.isJson()) {
                objectArray2 = outFile;
                Object object = Charsets.UTF_8;
                int n = 8192;
                Object[] objectArray3 = objectArray2;
                objectArray2 = (objectArray3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)objectArray3), (Charset)object)) instanceof BufferedWriter ? (BufferedWriter)objectArray3 : new BufferedWriter((Writer)objectArray3, n);
                object = null;
                try {
                    BufferedWriter it = (BufferedWriter)objectArray2;
                    boolean bl = false;
                    this.GSON.toJson(item, (Appendable)it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    object = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)objectArray2, (Throwable)object);
                }
            }
            objectArray2 = new FileOutputStream(outFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)objectArray2;
                boolean bl = false;
                Closeable closeable = new ObjectOutputStream(it);
                Throwable throwable2 = null;
                try {
                    ObjectOutputStream it2 = (ObjectOutputStream)closeable;
                    boolean bl2 = false;
                    it2.writeObject(item);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)objectArray2, (Throwable)throwable);
            }
            objectArray2 = new Object[]{pkg, outFile.getCanonicalPath()};
            L.d("done writing output file %s into %s", objectArray2);
        }
        catch (Throwable t) {
            L.e(t, "cannot write file " + pkg + ' ' + (Object)((Object)ext), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final <T> T deserializeObject(File file) {
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                IgnoreSerialIdObjectInputStream in = new IgnoreSerialIdObjectInputStream(it);
                Object object = in.readObject();
                return (T)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            block13: {
                Object object;
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                L.e(t, "Could not read Binding properties intermediate file. %s", objectArray);
                InputStream inputStream = null;
                try {
                    inputStream = FileUtils.openInputStream((File)file);
                    IgnoreSerialIdObjectInputStream in = new IgnoreSerialIdObjectInputStream(inputStream);
                    object = in.readObject();
                }
                catch (IOException e) {
                    Object[] objectArray2 = new Object[]{file.getAbsolutePath()};
                    L.e(e, "Could not merge in Bindables from %s", objectArray2);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    break block13;
                }
                catch (ClassNotFoundException e2) {
                    Object[] objectArray3 = new Object[]{file.getAbsolutePath()};
                    L.e(e2, "Could not read Binding properties intermediate file. %s", objectArray3);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return (T)object;
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean load$lambda$0(ExtensionFilter $ext, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFile()) return false;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)$ext.getExt(), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object load$lambda$1(ExtensionFilter $ext, GenerationalClassUtil this$0, Class $klass, File it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($ext.isJson()) {
            Object object2 = it;
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object2;
            object2 = (object4 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object4), (Charset)object3)) instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            object3 = null;
            try {
                BufferedReader reader = (BufferedReader)object2;
                boolean bl = false;
                Object object5 = this$0.GSON.fromJson((Reader)reader, $klass);
                object = object5;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
        } else {
            object = this$0.deserializeObject(it);
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final GenerationalClassUtil create(@NotNull CompilerArguments args) {
        return Companion.create(args);
    }

    @JvmStatic
    @NotNull
    public static final GenerationalClassUtil get() {
        return Companion.get();
    }

    public /* synthetic */ GenerationalClassUtil(CompilerArguments args, DefaultConstructorMarker $constructor_marker) {
        this(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Landroid/databinding/tool/util/GenerationalClassUtil$Companion;", "", "<init>", "()V", "create", "Landroid/databinding/tool/util/GenerationalClassUtil;", "args", "Landroid/databinding/tool/CompilerArguments;", "get", "db-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GenerationalClassUtil create(@NotNull CompilerArguments args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return new GenerationalClassUtil(args, null);
        }

        @JvmStatic
        @NotNull
        public final GenerationalClassUtil get() {
            GenerationalClassUtil generationalClassUtil = Context.getGenerationalClassUtil();
            Intrinsics.checkNotNull((Object)generationalClassUtil);
            return generationalClassUtil;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Landroid/databinding/tool/util/GenerationalClassUtil$ExtensionFilter;", "", "ext", "", "isJson", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getExt", "()Ljava/lang/String;", "()Z", "SETTER_STORE_JSON", "BR", "LAYOUT", "SETTER_STORE", "db-compiler"})
    public static final class ExtensionFilter
    extends Enum<ExtensionFilter> {
        @NotNull
        private final String ext;
        private final boolean isJson;
        public static final /* enum */ ExtensionFilter SETTER_STORE_JSON = new ExtensionFilter("-setter_store.json", true);
        public static final /* enum */ ExtensionFilter BR = new ExtensionFilter("-br.bin", false);
        public static final /* enum */ ExtensionFilter LAYOUT = new ExtensionFilter("-layoutinfo.bin", false);
        public static final /* enum */ ExtensionFilter SETTER_STORE = new ExtensionFilter("-setter_store.bin", false);
        private static final /* synthetic */ ExtensionFilter[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExtensionFilter(String ext, boolean isJson) {
            this.ext = ext;
            this.isJson = isJson;
        }

        @NotNull
        public final String getExt() {
            return this.ext;
        }

        public final boolean isJson() {
            return this.isJson;
        }

        public static ExtensionFilter[] values() {
            return (ExtensionFilter[])$VALUES.clone();
        }

        public static ExtensionFilter valueOf(String value) {
            return Enum.valueOf(ExtensionFilter.class, value);
        }

        @NotNull
        public static EnumEntries<ExtensionFilter> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = extensionFilterArray = new ExtensionFilter[]{ExtensionFilter.SETTER_STORE_JSON, ExtensionFilter.BR, ExtensionFilter.LAYOUT, ExtensionFilter.SETTER_STORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Landroid/databinding/tool/util/GenerationalClassUtil$IgnoreSerialIdObjectInputStream;", "Ljava/io/ObjectInputStream;", "in", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "readClassDescriptor", "Ljava/io/ObjectStreamClass;", "db-compiler"})
    private static final class IgnoreSerialIdObjectInputStream
    extends ObjectInputStream {
        public IgnoreSerialIdObjectInputStream(@NotNull InputStream in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            super(in);
        }

        @Override
        @NotNull
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass objectStreamClass;
            ObjectStreamClass original = super.readClassDescriptor();
            if (Intrinsics.areEqual((Object)ProcessExpressions.IntermediateV1.class.getName(), (Object)original.getName())) {
                ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(ProcessExpressions.IntermediateV1.class);
                Intrinsics.checkNotNull((Object)objectStreamClass2);
                objectStreamClass = objectStreamClass2;
            } else {
                Intrinsics.checkNotNull((Object)original);
                objectStreamClass = original;
            }
            return objectStreamClass;
        }
    }
}

