/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import java.util.List;

public class InjectedMethod
extends ModelMethod {
    private final InjectedClass mContainingClass;
    private final String mName;
    private final String mReturnTypeName;
    private final String[] mParameterTypeNames;
    private final ImportBag mImports;
    private ModelClass[] mParameterTypes;
    private ModelClass mReturnType;
    private boolean mIsStatic;

    public InjectedMethod(InjectedClass containingClass, boolean isStatic, String name, ImportBag imports, String returnType, String ... parameters) {
        this.mContainingClass = containingClass;
        this.mName = name;
        this.mIsStatic = isStatic;
        this.mReturnTypeName = returnType;
        this.mParameterTypeNames = parameters;
        this.mImports = imports;
    }

    @Override
    public ModelClass getDeclaringClass() {
        return this.mContainingClass;
    }

    @Override
    public ModelClass[] getParameterTypes() {
        if (this.mParameterTypes == null) {
            if (this.mParameterTypeNames == null) {
                this.mParameterTypes = new ModelClass[0];
            } else {
                this.mParameterTypes = new ModelClass[this.mParameterTypeNames.length];
                ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
                for (int i = 0; i < this.mParameterTypeNames.length; ++i) {
                    this.mParameterTypes[i] = modelAnalyzer.findClass(this.mParameterTypeNames[i], this.mImports);
                }
            }
        }
        return this.mParameterTypes;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public ModelClass getReturnType(List<ModelClass> args) {
        if (this.mReturnType == null) {
            this.mReturnType = ModelAnalyzer.getInstance().findClass(this.mReturnTypeName, this.mImports);
        }
        return this.mReturnType;
    }

    @Override
    public boolean isVoid() {
        return this.getReturnType().isVoid();
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.mIsStatic;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public int getMinApi() {
        return 0;
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("public ");
        if (this.mIsStatic) {
            sb.append("static ");
        }
        sb.append(this.mReturnTypeName).append(' ').append(this.mName).append("(");
        if (this.mParameterTypeNames != null) {
            for (int i = 0; i < this.mParameterTypeNames.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.mParameterTypeNames[i]);
            }
        }
        sb.append(')');
        return sb.toString();
    }
}

