/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.writer.KCode;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.ArrayList;
import java.util.List;

public class ListenerExpr
extends Expr {
    private final String mName;
    private final ModelClass mListenerType;
    private final ModelMethod mMethod;

    ListenerExpr(Expr expr, String name, ModelClass listenerType, ModelMethod method) {
        super(expr);
        this.mName = name;
        this.mListenerType = listenerType;
        this.mMethod = method;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.mListenerType;
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    public ModelMethod getMethod() {
        return this.mMethod;
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isDynamic() {
        return this.getTarget().isDynamic();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Dependency dependency = new Dependency(this, this.getTarget());
        dependency.setMandatory(true);
        dependencies.add(dependency);
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return ListenerExpr.join(this.getTarget(), "::", this.mName, "(", this.getResolvedType().getCanonicalName(), ")");
    }

    @Override
    public KCode generateCode() {
        KCode code = new KCode("(");
        int minApi = Math.max(this.mListenerType.getMinApi(), this.mMethod.getMinApi());
        if (minApi > 1) {
            code.app("(getBuildSdkInt() < " + minApi + ") ? null : ");
        }
        String fieldName = LayoutBinderWriterKt.getFieldName(this);
        String listenerClassName = LayoutBinderWriterKt.getListenerClassName(this);
        KCode value = this.getTarget().toCode();
        code.app("((").app(fieldName).app(" == null) ? (").app(fieldName).app(" = new ").app(listenerClassName).app("()) : ").app(fieldName).app(")");
        if (this.getTarget().isDynamic()) {
            code.app(".setValue(", value).app(")");
        }
        code.app(")");
        return code;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.listenerExpr(this.getTarget().cloneToModel(model), this.mName, this.mListenerType, this.mMethod);
    }

    @Override
    public String getInvertibleError() {
        return "Listeners cannot be the target of a two-way binding";
    }

    @Override
    public String toString() {
        return this.getTarget().toString() + "::" + this.mName;
    }
}

