/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.LintIdeFixPerformer;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Location;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001aR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/lint/common/AnnotateQuickFix;", "Lcom/intellij/modcommand/ModCommandAction;", "project", "Lcom/intellij/openapi/project/Project;", "displayName", "", "familyName", "annotationSource", "replace", "", "range", "Lcom/android/tools/lint/detector/api/Location;", "selectPattern", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "rangePointer", "Lcom/intellij/psi/SmartPsiFileRange;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "findPsiTarget", "Lcom/intellij/psi/PsiElement;", "applyFixFun", "element", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nAnnotateQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotateQuickFix.kt\ncom/android/tools/idea/lint/common/AnnotateQuickFix\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,197:1\n11228#2:198\n11563#2,3:199\n67#3:202\n*S KotlinDebug\n*F\n+ 1 AnnotateQuickFix.kt\ncom/android/tools/idea/lint/common/AnnotateQuickFix\n*L\n150#1:198\n150#1:199,3\n168#1:202\n*E\n"})
public final class AnnotateQuickFix
implements ModCommandAction {
    @Nullable
    private final String displayName;
    @Nullable
    private final String familyName;
    @NotNull
    private final String annotationSource;
    private final boolean replace;
    @Nullable
    private final String selectPattern;
    @Nullable
    private final SmartPsiFileRange rangePointer;

    public AnnotateQuickFix(@NotNull Project project, @Nullable String displayName, @Nullable String familyName, @NotNull String annotationSource, boolean replace, @Nullable Location range, @Nullable String selectPattern) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)annotationSource, (String)"annotationSource");
        this.displayName = displayName;
        this.familyName = familyName;
        this.annotationSource = annotationSource;
        this.replace = replace;
        this.selectPattern = selectPattern;
        this.rangePointer = LintIdeFixPerformer.Companion.getRangePointer(project, range);
    }

    public /* synthetic */ AnnotateQuickFix(Project project, String string, String string2, String string3, boolean bl, Location location, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            string4 = null;
        }
        this(project, string, string2, string3, bl, location, string4);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.familyName;
        if (string == null) {
            string = "Annotate";
        }
        return string;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.findPsiTarget(context) != null) {
            String string = this.displayName;
            if (string == null) {
                string = this.getFamilyName();
            }
            presentation = Presentation.of((String)string);
        } else {
            presentation = null;
        }
        return presentation;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = this.findPsiTarget(context);
        if (psiElement == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        PsiElement element = psiElement;
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (arg_0, arg_1) -> AnnotateQuickFix.perform$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    @Nullable
    public final PsiElement findPsiTarget(@NotNull ActionContext context) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SmartPsiFileRange smartPsiFileRange = this.rangePointer;
        PsiFile rangeFile = smartPsiFileRange != null && (smartPsiFileRange = (PsiFile)smartPsiFileRange.getElement()) != null ? smartPsiFileRange.getContainingFile() : null;
        PsiElement psiElement = context.findLeaf();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement element = psiElement;
        if (rangeFile != null && (Intrinsics.areEqual((Object)rangeFile.getContainingFile(), (Object)context.file()) || !Intrinsics.areEqual((Object)context.file().getOriginalFile(), (Object)rangeFile.getContainingFile()))) {
            Segment range;
            Segment segment = range = this.rangePointer.getRange();
            Intrinsics.checkNotNull((Object)segment);
            PsiElement newStartElement = rangeFile.findElementAt(segment.getStartOffset());
            if (newStartElement != null) {
                element = newStartElement;
            }
        }
        return Intrinsics.areEqual((Object)(language = element.getLanguage()), (Object)JavaLanguage.INSTANCE) ? (PsiElement)AnnotateQuickFixKt.findJavaAnnotationTarget(element) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? AnnotateQuickFixKt.access$findKotlinAnnotationTarget(element) : null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final PsiElement applyFixFun(@NotNull PsiElement element) {
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                var2_2 = element.getLanguage();
                if (!Intrinsics.areEqual((Object)var2_2, (Object)JavaLanguage.INSTANCE)) break block17;
                owner = (PsiModifierListOwner)element;
                v0 = ((PsiModifierListOwner)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                project = v0;
                v1 = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getElementFactory(...)");
                factory = v1;
                v2 = factory.createAnnotationFromText(this.annotationSource, element);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"createAnnotationFromText(...)");
                newAnnotation = v2;
                v3 = newAnnotation.getQualifiedName();
                if (v3 == null) {
                    return null;
                }
                annotationName = v3;
                var9_13 = new String[]{annotationName};
                annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])var9_13);
                if (annotation != null && !(annotation instanceof SyntheticElement) && this.replace) {
                    return annotation.replace((PsiElement)newAnnotation);
                }
                if (annotation != null && !this.replace) {
                    return annotation.getParent().addBefore((PsiElement)newAnnotation, (PsiElement)annotation);
                }
                v4 = newAnnotation.getParameterList().getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getAttributes(...)");
                attributes = v4;
                v5 = ((PsiModifierListOwner)element).getModifierList();
                if (v5 == null) {
                    return null;
                }
                elementModifierList = v5;
                v6 = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)annotationName, (PsiNameValuePair[])attributes, (PsiAnnotationOwner)((PsiAnnotationOwner)elementModifierList));
                if (v6 != null) {
                    it = v6;
                    $i$a$-let-AnnotateQuickFix$applyFixFun$1 = false;
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)it);
                }
                v7 = ((PsiModifierListOwner)element).getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getAnnotations(...)");
                for (Object var15_24 : (Object[])v7) {
                    a = (PsiAnnotation)var15_24;
                    $i$a$-find-AnnotateQuickFix$applyFixFun$2 = false;
                    if (!Intrinsics.areEqual((Object)a.getQualifiedName(), (Object)annotationName)) ** GOTO lbl-1000
                    v8 = a.getParameterList().getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getAttributes(...)");
                    $this$map$iv = v8;
                    $i$f$map = false;
                    var20_29 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        var26_35 = (PsiNameValuePair)item$iv$iv;
                        var27_36 = destination$iv$iv;
                        $i$a$-map-AnnotateQuickFix$applyFixFun$2$1 = false;
                        var27_36.add(it.getName());
                    }
                    $this$map$iv = attributes;
                    var27_36 = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    var24_33 = $this$mapTo$iv$iv.length;
                    for (var23_32 = 0; var23_32 < var24_33; ++var23_32) {
                        it = item$iv$iv = $this$mapTo$iv$iv[var23_32];
                        var29_38 = destination$iv$iv;
                        $i$a$-map-AnnotateQuickFix$applyFixFun$2$2 = false;
                        var29_38.add(it.getName());
                    }
                    if (Intrinsics.areEqual(var27_36, (Object)((List)destination$iv$iv))) {
                        v9 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = false;
                    }
                    if (!v9) continue;
                    v10 = var15_24;
                    break block16;
                }
                v10 = null;
            }
            return (PsiElement)v10;
        }
        if (Intrinsics.areEqual((Object)var2_2, (Object)KotlinLanguage.INSTANCE)) {
            if (!(element instanceof KtModifierListOwner)) {
                return null;
            }
            v11 = ((KtModifierListOwner)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getProject(...)");
            psiFactory = new KtPsiFactory(v11, true);
            annotationEntry = psiFactory.createAnnotationEntry(this.annotationSource);
            fqName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.removePrefix((String)this.annotationSource, (CharSequence)"@"), (char)':', null, (int)2, null), (char)'(', null, (int)2, null);
            classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)ClassContext.Companion.getInternalName(fqName), (boolean)false, (int)2, null);
            existing = AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)((KtAnnotated)element), (ClassId)classId, null, (boolean)false, (int)6, null);
            if (existing != null && !(existing instanceof SyntheticElement) && this.replace) {
                v12 = existing.replace((PsiElement)annotationEntry);
                Intrinsics.checkNotNull((Object)v12, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
                v13 = (KtAnnotationEntry)v12;
            } else {
                attributes = ((KtModifierListOwner)element).addAnnotationEntry(annotationEntry);
                Intrinsics.checkNotNull((Object)attributes);
                v13 = attributes;
            }
            addedAnnotation = v13;
            v14 = shortened = ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)addedAnnotation);
            if (v14 != null) {
                elementModifierList = v14;
                withSelf$iv = true;
                $i$f$parentOfType = false;
                v15 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtAnnotationEntry.class, (boolean)false);
            } else {
                v15 = null;
            }
            return (PsiElement)v15;
        }
        return null;
    }

    private static final void perform$lambda$0(AnnotateQuickFix this$0, PsiElement e, ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiElement element = this$0.applyFixFun(e);
        if (element != null && this$0.selectPattern != null) {
            MatchGroup group;
            String text = element.getText();
            Regex regex = new Regex(this$0.selectPattern);
            Intrinsics.checkNotNull((Object)text);
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null);
            if (matchResult == null) {
                return;
            }
            MatchResult result = matchResult;
            MatchGroupCollection groups = result.getGroups();
            MatchGroup matchGroup = group = groups.size() > 1 ? groups.get(1) : groups.get(0);
            if (group != null) {
                int startIndex = group.getRange().getFirst();
                int begin = element.getTextOffset() + startIndex;
                TextRange range = new TextRange(begin, begin + group.getValue().length());
                updater.select(range);
                return;
            }
        }
    }
}

