/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.gradle.Dependency;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeFixPerformerKt;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/lint/common/AndroidLintGradleDynamicVersionInspection;", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "<init>", "()V", "getQuickFixes", "", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/android/tools/lint/detector/api/Incident;)[Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "intellij.lint"})
public final class AndroidLintGradleDynamicVersionInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDynamicVersionInspection() {
        super(LintBundle.Companion.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        LintFix fixData = incident.getFix();
        String gc = LintFix.Companion.getString(fixData, "coordinate", null);
        String revision = LintFix.Companion.getString(fixData, "revision", null);
        if (fixData == null || gc == null || revision == null) {
            LintIdeQuickFix[] lintIdeQuickFixArray = super.getQuickFixes(startElement, endElement, incident);
            Intrinsics.checkNotNullExpressionValue((Object)lintIdeQuickFixArray, (String)"getQuickFixes(...)");
            return lintIdeQuickFixArray;
        }
        LintFix newFix = LintFix.Companion.create().replace().name("Replace with specific version").text(gc).with("placeholder").build();
        LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[1];
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        lintIdeQuickFixArray[0] = LintIdeFixPerformerKt.toIdeFix(newFix, project, incident, (Function2<? super LintFixPerformer.PendingEditFile, ? super LintFixPerformer.PendingEdit, String>)((Function2)(arg_0, arg_1) -> AndroidLintGradleDynamicVersionInspection.getQuickFixes$lambda$0(gc, startElement, arg_0, arg_1)));
        return lintIdeQuickFixArray;
    }

    private static final String getQuickFixes$lambda$0(String $gc, PsiElement $startElement, LintFixPerformer.PendingEditFile pendingEditFile, LintFixPerformer.PendingEdit pendingEdit) {
        Intrinsics.checkNotNullParameter((Object)pendingEditFile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)pendingEdit, (String)"<unused var>");
        Dependency dependency = Dependency.Companion.parse($gc);
        LintIdeSupport lintIdeSupport = LintIdeSupport.Companion.get();
        Project project = $startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String resolved = lintIdeSupport.resolveDynamicDependency(project, dependency);
        return resolved == null ? $gc : dependency.getGroup() + ":" + dependency.getName() + ":" + resolved;
    }
}

