/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.execution.testing.CidrTestIndexContributor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.testing.ClangBadTLMSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J4\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J6\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u0014\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00152\u001c\u0010\u0016\u001a\u000f\u0012\u000b\b\u0001\u0012\u00070\u0018\u00a2\u0006\u0002\b\u00150\u0017\"\u00070\u0018\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor;", "Lcom/jetbrains/cidr/execution/testing/CidrTestIndexContributor;", "<init>", "()V", "gatherTestLinks", "", "", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "pFile", "Lcom/intellij/psi/PsiFile;", "fwProtocol", "transformTestSuite", "Lkotlin/Pair;", "testName", "suiteName", "getPrimaryProtocol", "canProcessFile", "", "log", "", "message", "Lorg/jetbrains/annotations/NonNls;", "details", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "Companion", "intellij.cidr.clangd.legacyBridge"})
public final class ClangTestIndexContributor
extends CidrTestIndexContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> ALL_FRAMEWORK_NAMES;

    @NotNull
    public Map<String, CidrTestScopeElement> gatherTestLinks(@NotNull PsiFile pFile, @NotNull String fwProtocol) {
        Object v2;
        Document doc;
        Project project;
        block10: {
            Intrinsics.checkNotNullParameter((Object)pFile, (String)"pFile");
            Intrinsics.checkNotNullParameter((Object)fwProtocol, (String)"fwProtocol");
            Project project2 = pFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            doc = PsiDocumentManager.getInstance((Project)project).getDocument(pFile);
            if (doc == null) {
                return MapsKt.emptyMap();
            }
            String fwProtocolPrefix = fwProtocol + "://";
            List list = OCTestFrameworks.getFrameworks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFrameworks(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                OCTestFramework it = (OCTestFramework)t;
                boolean bl = false;
                if (!(it instanceof CidrTestWithScopeElementsAndGeneratorFramework && Intrinsics.areEqual((Object)((CidrTestWithScopeElementsAndGeneratorFramework)it).getProtocolPrefix(), (Object)fwProtocolPrefix))) continue;
                v2 = t;
                break block10;
            }
            v2 = null;
        }
        OCTestFramework frameworkInst = v2;
        if (frameworkInst == null || !((CidrTestWithScopeElementsAndGeneratorFramework)frameworkInst).isPotentialTestHolderFile(pFile)) {
            return MapsKt.emptyMap();
        }
        VirtualFile vFile = pFile.getVirtualFile();
        Intrinsics.checkNotNull((Object)vFile);
        List<ClionTestRunLineMarker> rawMarkers = Companion.getClangdTestLineMarkers(vFile, project, CollectionsKt.listOf((Object)fwProtocol));
        HashMap result = new HashMap();
        OCResolveContext oCResolveContext = OCResolveContext.forPsi((PsiElement)((PsiElement)pFile));
        Intrinsics.checkNotNullExpressionValue((Object)oCResolveContext, (String)"forPsi(...)");
        OCResolveContext context = oCResolveContext;
        for (ClionTestRunLineMarker marker : rawMarkers) {
            Object[] macro;
            int offsetOfTest = doc.getLineStartOffset(marker.getLineNumber()) + marker.getColumnNumber();
            Ref.ObjectRef testQName = new Ref.ObjectRef();
            testQName.element = StringsKt.replace$default((String)marker.getQDeclName(), (String)"::(anonymous namespace)", (String)"", (boolean)false, (int)4, null);
            Ref psiGoodTestCandidate = new Ref();
            Ref.ObjectRef psiBestTestCandidate = new Ref.ObjectRef();
            psiBestTestCandidate.element = new Ref();
            Ref offsetAsNaturalOrder = Ref.create((Object)offsetOfTest);
            Ref kindOfTestSymbol = new Ref();
            Ref uniqueTestBodyElementId = new Ref();
            Ref bestTestCandidateIsFound = Ref.create((Object)false);
            for (PsiElement psiMaybeTestHolderAtOffset = pFile.findElementAt(offsetOfTest); psiMaybeTestHolderAtOffset != null && !(psiMaybeTestHolderAtOffset instanceof PsiFile) && psiMaybeTestHolderAtOffset.getTextOffset() == offsetOfTest && !((Boolean)bestTestCandidateIsFound.get()).booleanValue(); psiMaybeTestHolderAtOffset = psiMaybeTestHolderAtOffset.getParent()) {
                ProgressManager.checkCanceled();
                if (!((CidrTestWithScopeElementsAndGeneratorFramework)frameworkInst).canBeTestHolder(psiMaybeTestHolderAtOffset)) continue;
                if (((Ref)psiBestTestCandidate.element).get() == null) {
                    psiGoodTestCandidate.set((Object)psiMaybeTestHolderAtOffset);
                }
                if (ClangTestIndexContributor.gatherTestLinks$checkPotentialTestHolder((Ref.ObjectRef<Ref<PsiElement>>)psiBestTestCandidate, (Ref<Long>)offsetAsNaturalOrder, (Ref<OCSymbolKind>)kindOfTestSymbol, context, (Ref<String>)uniqueTestBodyElementId, (Ref.ObjectRef<String>)testQName, (Ref<Boolean>)bestTestCandidateIsFound, psiMaybeTestHolderAtOffset)) break;
                if (!(psiMaybeTestHolderAtOffset instanceof OCMacroCall)) continue;
                macro = (Object[])psiMaybeTestHolderAtOffset;
                Ref psiPreviouslyProcessed = new Ref();
                long macroCallOffset = macro.getComplexOffset();
                macro.processExpansionLeaves(arg_0 -> ClangTestIndexContributor.gatherTestLinks$lambda$2(arg_0 -> ClangTestIndexContributor.gatherTestLinks$lambda$1(frameworkInst, macroCallOffset, psiPreviouslyProcessed, psiBestTestCandidate, offsetAsNaturalOrder, kindOfTestSymbol, context, uniqueTestBodyElementId, testQName, bestTestCandidateIsFound, arg_0), arg_0));
            }
            if (((Ref)psiBestTestCandidate.element).isNull()) {
                psiBestTestCandidate.element = psiGoodTestCandidate;
            }
            if (((Ref)psiBestTestCandidate.element).isNull()) {
                macro = new Object[]{marker};
                this.log("ERROR: TestMarker was not found: ", macro);
                if (CidrTestIndexContributor.indexTestsByClangOnly()) continue;
                this.log("WARNING! TestMarker fallback to native contributor", new Object[0]);
                throw new ClangBadTLMSource();
            }
            if (!((Boolean)bestTestCandidateIsFound.get()).booleanValue()) {
                this.log("TestMarker found NOT BEST for " + marker + ":\n  looking: " + testQName.element + "       vs: " + uniqueTestBodyElementId.get() + ", kind:" + kindOfTestSymbol.get(), new Object[0]);
                if (!uniqueTestBodyElementId.isNull()) {
                    Intrinsics.checkNotNullExpressionValue((Object)uniqueTestBodyElementId.get(), (String)"get(...)");
                    testQName.element = testQName.element;
                }
            }
            Pair<String, String> testSuite = this.transformTestSuite(marker.getTestName(), marker.getSuiteName(), fwProtocol);
            Map map = result;
            Object object = testQName.element;
            CidrTestWithScopeElementsAndGeneratorFramework cidrTestWithScopeElementsAndGeneratorFramework = (CidrTestWithScopeElementsAndGeneratorFramework)frameworkInst;
            String string = (String)testSuite.getFirst();
            String string2 = (String)testSuite.getSecond();
            Object object2 = offsetAsNaturalOrder.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            CidrTestScopeElement cidrTestScopeElement = cidrTestWithScopeElementsAndGeneratorFramework.cacheResultForTestHolder(string, string2, ((Number)object2).longValue(), (String)testQName.element, (PsiElement)((Ref)psiBestTestCandidate.element).get(), (OCSymbolKind)kindOfTestSymbol.get());
            map.put(object, cidrTestScopeElement);
        }
        return result;
    }

    private final Pair<String, String> transformTestSuite(String testName, String suiteName, String fwProtocol) {
        if (Intrinsics.areEqual((Object)fwProtocol, (Object)"gtest")) {
            String string = testName;
            String string2 = suiteName;
            return new Pair(string == null ? null : "test:" + string, string2 == null ? null : "suite:" + string2);
        }
        return new Pair((Object)testName, (Object)suiteName);
    }

    @NotNull
    public String getPrimaryProtocol() {
        return "clang";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canProcessFile(@NotNull PsiFile pFile, @NotNull String fwProtocol) {
        Intrinsics.checkNotNullParameter((Object)pFile, (String)"pFile");
        Intrinsics.checkNotNullParameter((Object)fwProtocol, (String)"fwProtocol");
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)pFile.getProject());
        if (!CidrTestIndexContributor.isOpened((PsiFile)pFile)) {
            if (!CidrTestIndexContributor.indexTestsByClangOnly()) return false;
        }
        if (!ClangdSettings.getInstance((Project)pFile.getProject()).isClangdOn()) return false;
        ClangLanguageService clangLanguageService = service;
        if (clangLanguageService != null ? clangLanguageService.isFileBanned(pFile.getVirtualFile().getUrl()) : false) return false;
        if (!ClangTestIndexContributor.Companion.getEnabledProtocolsForClangProcessing().contains(fwProtocol)) return false;
        return true;
    }

    public final void log(@NotNull String message, Object ... details) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        CidrTestLog.LOG.debug(message, Arrays.copyOf(details, details.length));
    }

    private static final boolean gatherTestLinks$checkPotentialTestHolder(Ref.ObjectRef<Ref<PsiElement>> psiBestTestCandidate, Ref<Long> offsetAsNaturalOrder, Ref<OCSymbolKind> kindOfTestSymbol, OCResolveContext context, Ref<String> uniqueTestBodyElementId, Ref.ObjectRef<String> testQName, Ref<Boolean> bestTestCandidateIsFound, PsiElement psiMaybeTestHolder) {
        OCSymbol symbol;
        if (psiMaybeTestHolder instanceof OCSymbolDeclarator && (symbol = ((OCSymbolDeclarator)psiMaybeTestHolder).getSymbol()) != null && symbol instanceof OCSymbolWithQualifiedName) {
            ((Ref)psiBestTestCandidate.element).set((Object)psiMaybeTestHolder);
            offsetAsNaturalOrder.set((Object)((OCSymbolWithQualifiedName)symbol).getComplexOffset());
            kindOfTestSymbol.set((Object)((OCSymbolWithQualifiedName)symbol).getKind());
            String symbolQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)((OCSymbolWithQualifiedName)symbol), (OCResolveContext)context);
            if (symbolQName != null) {
                uniqueTestBodyElementId.set((Object)symbolQName);
                if (Intrinsics.areEqual((Object)symbolQName, (Object)testQName.element)) {
                    bestTestCandidateIsFound.set((Object)true);
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean gatherTestLinks$lambda$1(OCTestFramework $frameworkInst, long $macroCallOffset, Ref $psiPreviouslyProcessed, Ref.ObjectRef $psiBestTestCandidate, Ref $offsetAsNaturalOrder, Ref $kindOfTestSymbol, OCResolveContext $context, Ref $uniqueTestBodyElementId, Ref.ObjectRef $testQName, Ref $bestTestCandidateIsFound, PsiElement leaf) {
        Class[] classArray = ((CidrTestWithScopeElementsAndGeneratorFramework)$frameworkInst).getTestHolderClassWithoutMacroCall();
        OCElement testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])Arrays.copyOf(classArray, classArray.length));
        if (testHolder != null && testHolder.getComplexOffset() > $macroCallOffset && !Intrinsics.areEqual((Object)$psiPreviouslyProcessed.get(), (Object)testHolder)) {
            $psiPreviouslyProcessed.set((Object)testHolder);
            if (ClangTestIndexContributor.gatherTestLinks$checkPotentialTestHolder((Ref.ObjectRef<Ref<PsiElement>>)$psiBestTestCandidate, (Ref<Long>)$offsetAsNaturalOrder, (Ref<OCSymbolKind>)$kindOfTestSymbol, $context, (Ref<String>)$uniqueTestBodyElementId, (Ref.ObjectRef<String>)$testQName, (Ref<Boolean>)$bestTestCandidateIsFound, (PsiElement)testHolder)) {
                return false;
            }
        }
        return true;
    }

    private static final boolean gatherTestLinks$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"Gtest", "Boost", "Doctest", "Catch"};
        ALL_FRAMEWORK_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$Companion;", "", "<init>", "()V", "ALL_FRAMEWORK_NAMES", "", "", "getALL_FRAMEWORK_NAMES", "()Ljava/util/List;", "getEnabledProtocolsForClangProcessing", "getClangdTestLineMarkers", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionTestRunLineMarker;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "enabledFrameworks", "intellij.cidr.clangd.legacyBridge"})
    @SourceDebugExtension(value={"SMAP\nClangTestIndexContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangTestIndexContributor.kt\ncom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1563#2:232\n1634#2,3:233\n*S KotlinDebug\n*F\n+ 1 ClangTestIndexContributor.kt\ncom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$Companion\n*L\n50#1:232\n50#1:233,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getALL_FRAMEWORK_NAMES() {
            return ALL_FRAMEWORK_NAMES;
        }

        private final List<String> getEnabledProtocolsForClangProcessing() {
            ArrayList<String> enabledFrameworks = new ArrayList<String>();
            for (String pr : this.getALL_FRAMEWORK_NAMES()) {
                String registryKeyStr = "cidr.enable.testRunLineMarkers.clang" + pr + "TestFrameworkSupport";
                boolean enabled = Registry.Companion.is(registryKeyStr);
                if (!enabled) continue;
                String string = pr.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                enabledFrameworks.add(string);
            }
            return enabledFrameworks;
        }

        @NotNull
        public final List<ClionTestRunLineMarker> getClangdTestLineMarkers(@NotNull VirtualFile vFile, @NotNull Project project, @NotNull List<String> enabledFrameworks) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(enabledFrameworks, (String)"enabledFrameworks");
            ClangLanguageService clangdService = ClangLanguageServiceProvider.getOrStart((Project)project);
            Ref ref = Ref.create((Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
            Ref clangdMarkersRef = ref;
            ClangLanguageService clangLanguageService = clangdService;
            if (clangLanguageService != null) {
                clangLanguageService.runWithOpenedAndParsed(vFile, arg_0 -> Companion.getClangdTestLineMarkers$lambda$2(clangdService, vFile, enabledFrameworks, clangdMarkersRef, arg_0));
            }
            Object object = clangdMarkersRef.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (List)object;
        }

        public static /* synthetic */ List getClangdTestLineMarkers$default(Companion companion, VirtualFile virtualFile, Project project, List list, int n, Object object) {
            if ((n & 4) != 0) {
                list = companion.getEnabledProtocolsForClangProcessing();
            }
            return companion.getClangdTestLineMarkers(virtualFile, project, list);
        }

        private static final void getClangdTestLineMarkers$lambda$2$lambda$1(Ref $clangdMarkersRef, ClangResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            try {
                List list = (List)it.waitForResult();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                $clangdMarkersRef.set((Object)list);
            }
            catch (ExecutionException e) {
                CidrLogService.LOG.warn((Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final void getClangdTestLineMarkers$lambda$2(ClangLanguageService $clangdService, VirtualFile $vFile, List $enabledFrameworks, Ref $clangdMarkersRef, ClangParseResponse it) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $enabledFrameworks;
            VirtualFile virtualFile = $vFile;
            ClangLanguageService clangLanguageService = $clangdService;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            clangLanguageService.getTestLineMarkers(virtualFile, (List)collection, arg_0 -> Companion.getClangdTestLineMarkers$lambda$2$lambda$1($clangdMarkersRef, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

