/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.namehint;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.TreeTraversal;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionFunctionInfoKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHintFunctionInfo;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangFunctionInfo;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangInlayHintsProviderBase;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006H\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010%\u001a\u00020\tH\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\tH\u0002J\b\u0010(\u001a\u00020\u0010H\u0016R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider;", "Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayHintsProviderBase;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "<init>", "()V", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "element", "Lcom/intellij/psi/PsiElement;", "_file", "Lcom/intellij/psi/PsiFile;", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "_element", "getInlayPresentation", "", "inlayText", "file", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "getHintInfoForElement", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClangdInlayHint;", "isShowHintsForEnumConstants", "Lcom/intellij/codeInsight/hints/Option;", "()Lcom/intellij/codeInsight/hints/Option;", "isShowHintsForConstructorExpressions", "isShowHintsForNonConstReferences", "isShowHintsForArrayIndices", "getSupportedOptions", "getProperty", "key", "canShowHintsWhenDisabled", "", "getDefaultBlackList", "", "createTraversal", "Lcom/intellij/psi/SyntaxTraverser;", "root", "isValidTokenTypeForHint", "elem", "getBlacklistExplanationHTML", "defaultBlacklist", "Companion", "intellij.cidr.clangd.legacyBridge"})
public final class ClangInlayParameterHintsProvider
extends ClangInlayHintsProviderBase
implements InlayParameterHintsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Option isShowHintsForEnumConstants;
    @NotNull
    private final Option isShowHintsForConstructorExpressions;
    @NotNull
    private final Option isShowHintsForNonConstReferences;
    @NotNull
    private final Option isShowHintsForArrayIndices;
    @NotNull
    private final Set<String> defaultBlacklist;

    public ClangInlayParameterHintsProvider() {
        Supplier supplier = OCBundle.messagePointer((String)"oc.inlay.hints.show.hints.for.enum.constants", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        this.isShowHintsForEnumConstants = new Option("oc.clangd.namehints.enums", supplier, true);
        Supplier supplier2 = OCBundle.messagePointer((String)"oc.inlay.hints.show.hints.for.constructors", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
        this.isShowHintsForConstructorExpressions = new Option("oc.clangd.namehints.construct.expr", supplier2, true);
        Supplier supplier3 = OCBundle.messagePointer((String)"oc.inlay.hints.show.amp.nonconst.references", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"messagePointer(...)");
        this.isShowHintsForNonConstReferences = new Option("oc.clangd.namehints.non.const.references", supplier3, true);
        Supplier supplier4 = OCBundle.messagePointer((String)"oc.inlay.hints.show.array.indices", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"messagePointer(...)");
        this.isShowHintsForArrayIndices = new Option("oc.clangd.namehints.array.indices", supplier4, true);
        Object[] objectArray = new String[]{"assert(*)", "std::forward(*)", "std::min(*, *)", "std::max(*, *)", "*strcmp(*, *)", "*strncmp(*, *, *)", "*wcscmp(*, *)", "std::vector::push_back(*)", "std::array::array(*)"};
        this.defaultBlacklist = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element, @NotNull PsiFile _file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
        if (!ClangUtils.isClangdOn((Project)element.getProject())) {
            return CollectionsKt.emptyList();
        }
        OCPsiFile oCPsiFile = _file instanceof OCPsiFile ? (OCPsiFile)_file : null;
        if (oCPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        OCPsiFile file = oCPsiFile;
        return this.getParameterHints(element, file);
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement _element, @NotNull PsiFile _file) {
        Intrinsics.checkNotNullParameter((Object)_element, (String)"_element");
        Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
        if (!ClangUtils.isClangdOn((Project)_element.getProject())) {
            return null;
        }
        OCPsiFile oCPsiFile = _file instanceof OCPsiFile ? (OCPsiFile)_file : null;
        if (oCPsiFile == null) {
            return null;
        }
        OCPsiFile file = oCPsiFile;
        PsiElement psiElement = file.asElementFromOCFile(_element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"asElementFromOCFile(...)");
        PsiElement element = psiElement;
        return this.getHintInfo(element, file);
    }

    @NotNull
    public String getInlayPresentation(@NotNull String inlayText) {
        Intrinsics.checkNotNullParameter((Object)inlayText, (String)"inlayText");
        return inlayText;
    }

    private final List<InlayInfo> getParameterHints(PsiElement element, OCPsiFile file) {
        Map<Integer, ClangdInlayHint> hints = this.getParameterHints((PsiFile)file);
        int elementOffset = element.getTextOffset();
        ClangdInlayHint clangdInlayHint = hints.get(elementOffset);
        if (clangdInlayHint == null) {
            return CollectionsKt.emptyList();
        }
        ClangdInlayHint hint = clangdInlayHint;
        String string = hint.getLabel();
        Intrinsics.checkNotNull((Object)string);
        InlayInfo inlayInfo = new InlayInfo(((Object)StringsKt.trim((CharSequence)string)).toString(), elementOffset, false);
        return CollectionsKt.listOf((Object)inlayInfo);
    }

    private final HintInfo getHintInfo(PsiElement element, OCPsiFile file) {
        ClangdInlayHint clangdInlayHint = this.getHintInfoForElement(element, file);
        if (clangdInlayHint == null) {
            return null;
        }
        ClangdInlayHint inlayHint = clangdInlayHint;
        ClangdInlayHintFunctionInfo clangdInlayHintFunctionInfo = inlayHint.getFunctionInfo();
        if (clangdInlayHintFunctionInfo == null) {
            return null;
        }
        ClangdInlayHintFunctionInfo functionInfo = clangdInlayHintFunctionInfo;
        String string = functionInfo.getName();
        Intrinsics.checkNotNull((Object)string);
        List list = functionInfo.getParamNames();
        Intrinsics.checkNotNull((Object)list);
        CLionFunctionInfoKind cLionFunctionInfoKind = functionInfo.getKind();
        Intrinsics.checkNotNull((Object)cLionFunctionInfoKind);
        return (HintInfo)new ClangFunctionInfo(string, list, cLionFunctionInfoKind);
    }

    private final ClangdInlayHint getHintInfoForElement(PsiElement element, OCPsiFile file) {
        int elemOffset = element.getTextOffset();
        return this.getParameterHints((PsiFile)file).get(elemOffset);
    }

    @NotNull
    public final Option isShowHintsForEnumConstants() {
        return this.isShowHintsForEnumConstants;
    }

    @NotNull
    public final Option isShowHintsForConstructorExpressions() {
        return this.isShowHintsForConstructorExpressions;
    }

    @NotNull
    public final Option isShowHintsForNonConstReferences() {
        return this.isShowHintsForNonConstReferences;
    }

    @NotNull
    public final Option isShowHintsForArrayIndices() {
        return this.isShowHintsForArrayIndices;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        Object[] objectArray = new Option[]{this.isShowHintsForEnumConstants, this.isShowHintsForConstructorExpressions, this.isShowHintsForNonConstReferences, this.isShowHintsForArrayIndices};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public String getProperty(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return OCBundle.message((String)key, (Object[])new Object[0]);
    }

    public boolean canShowHintsWhenDisabled() {
        return false;
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return this.defaultBlacklist;
    }

    @NotNull
    public SyntaxTraverser<PsiElement> createTraversal(@NotNull PsiElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        FilteredTraverserBase filteredTraverserBase = ((SyntaxTraverser)super.createTraversal(OCPsiFile.tryGetElementFromOCFile((PsiElement)root)).withTraversal(TreeTraversal.LEAVES_DFS)).filter(arg_0 -> ClangInlayParameterHintsProvider.createTraversal$lambda$0((Function1)new Function1<PsiElement, Boolean>((Object)this){

            public final Boolean invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ClangInlayParameterHintsProvider.access$isValidTokenTypeForHint((ClangInlayParameterHintsProvider)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        return (SyntaxTraverser)filteredTraverserBase;
    }

    private final boolean isValidTokenTypeForHint(PsiElement elem) {
        return !(elem instanceof PsiWhiteSpace);
    }

    @NotNull
    public String getBlacklistExplanationHTML() {
        String string = OCBundle.message((String)"oc.inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final boolean createTraversal$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isValidTokenTypeForHint(ClangInlayParameterHintsProvider $this, PsiElement elem) {
        return $this.isValidTokenTypeForHint(elem);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider;", "intellij.cidr.clangd.legacyBridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClangInlayParameterHintsProvider getInstance() {
            Object object = InlayParameterHintsExtension.INSTANCE.forLanguage(LanguageUtils.Companion.getInstance().getConfigLanguage());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.daemon.clang.namehint.ClangInlayParameterHintsProvider");
            return (ClangInlayParameterHintsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

